solve.cubic <-
function(a,b=NULL,...){
x<-a
if(class(x)!="cubic"){
	stop("object x must be a cubic!\n")
}
r<-NULL
a<-x[1]
b<-x[2]/a
c<-x[3]/a
d<-x[4]/a

m=2*b^3-9*b*c+27*d
k=b^2-3*c
n=m^2-4*k^3
w1=complex(re=-.5,im=.5*sqrt(3))
w2=complex(re=-.5,im=-.5*sqrt(3))

roots1=rootsofunity(3)*nthroot((m+nthroot(n,2))/2,3)
roots2=rootsofunity(3)*nthroot((m-nthroot(n,2))/2,3)

rtab=outer(roots1,roots2)

q=which(abs(Re(rtab)-k)<1e-8,arr.ind=TRUE)
r1=roots1[q[1,1]]
r2=roots2[q[1,2]]

x1=b+r1+r2
x2=b+w2*r1+w1*r2
x3=b+w1*r1+w2*r2

r<-unique(c(x1,x2,x3))

class(r)<-"roots"

return(r)
}

