cuberoot <-
function(x)
   return(x^(1/3))

fourthroot <-
function(x)
{
   if (x<0)
      stop("negative arguments not allowed")
   ans <- 0
   out <- .Fortran("fthrt",as.double(x),ans=as.double(ans),PACKAGE="roots")

   return(out$ans)
}

fifthroot <-
function(x)
{
   out <- .C("fifrt",as.double(x),ans=double(1),PACKAGE="roots")
   return(out$ans)
}

table.of.roots <-
structure(list(number = 1:10, cuberoot = c(1, 1.259921, 1.44225, 
1.587401, 1.709976, 1.817121, 1.912931, 2, 2.080084, 2.154435
), fourthroot = c(1, 1.189207, 1.316074, 1.414214, 1.495349, 
1.565085, 1.626577, 1.681793, 1.732051, 1.778279), fifthroot = c(1, 
1.148698, 1.245731, 1.319508, 1.37973, 1.430969, 1.475773, 1.515717, 
1.551846, 1.584893)), .Names = c("number", "cuberoot", "fourthroot", 
"fifthroot"), class = "data.frame", row.names = c(NA, -10L))
