\name{checkngon}
\alias{checkngon}
\title{
Check whether a polygon is constructible from straight line and compasses
}
\description{
The function uses Gauss' condition to check whether it is possible to 
construct the n-sided polygon.

}
\usage{
checkngon(n, plot.it = F)
}
\arguments{
  \item{n}{an integer giving the number of sides of the polygon to 
  check.
}
  \item{plot.it}{a boolean value indicating whether to plot the polygon.
}
}
\details{
The first five Fermat primes are calculated and then used as 
candidate divisors of \env{n}.  Since Gauss' condition specifies the 
distinctness of the factor primes, factor powers greater than 1 aren't 
allowed, nor a remainder which isn't a power of two.
}
\value{
\item{valid}{a boolean indicating whether the polygon can be 
constructed.}
\item{powers}{the factor powers of the Fermat primes, as well as the 
power of two of the remainder.}
}
\author{
Matt Nunes
}
\seealso{
\code{\link{plotngon}}
}
\examples{
#should be TRUE
checkngon(5,FALSE)$valid

#should be FALSE
checkngon(7,FALSE)$valid

}
\keyword{manip}
