nthroot <-
function(z,n,all=FALSE){

if(!is.complex(z)){
	z<-as.complex(z)
}

switch(n,
{M=Mod(z)},
{M=sqrt(Mod(z))},
{M=cuberoot(Mod(z))},
{M=fourthroot(Mod(z))},
{M=fifthroot(Mod(z))}
)

A=Arg(z)/n

pnew=complex(mod=M,arg=A)

if(all){
	pnew=pnew*rootsofunity(n)
}
class(pnew)<-"roots"
pnew
}

