                                        # functional data PCO based on dtw distances

source("funcs.R")
load("funcs.rda")

tt <- 1:240
p <- nrow(fd)

pdf("funmean.pdf",height=3.5,width=5.5)
par(mar=c(3.1,3.1,0.1,0.1),mgp=c(1.5,0.5,0),tck=-0.01)
matplot(tt,t(fd),type="l",col=gray(0.5),lty=1,xlab="Frame number",ylab="Percentage change")
meandm <- apply(fd,2,mean) 
lines(tt,meandm,lwd=3)  
dev.off()
  
require(dtw)
# difference based matching

i1 <- 14
i2 <- 7
i3 <- 27


f1 <- fd[i1,]
f2 <- fd[i2,]
f3 <- fd[i3,]


al <- dtw(diff(f1),diff(f2),keep=TRUE,window.type="itakura")
y <- (f1[al$index1]+f2[al$index2])/2
tx <- (al$index1+al$index2)/2

# example pair
pdf("wmean.pdf",height=3.5,width=5.5)
par(mar=c(3.1,3.1,0.1,0.1),mgp=c(1.5,0.5,0),tck=-0.01)
matplot(tt,cbind(f1,f2),type="l",lty=1,col=1,xlab="Frame number",ylab="",lwd=1.5)
segments(al$index1,f1[al$index1],al$index2,f2[al$index2],col=gray(0.75))
lines(tt,f1,lty=1,lwd=1.5)
lines(tt,f2,lty=1,lwd=1.5)
lines(tx,y,lwd=2,lty=2)
lines(tt,(f1+f2)/2,lty=5,lwd=2)
dev.off()

# example 3 way
fm <- cbind(f1,f2,f3)
matplot(tt,fm,type="l",lty=1,xlab="Frame number",ylab="",col=1,lwd=2)
#lines(w3f(fm,c(1,1,1)/3),col=4,lwd=2)
lines(w3f(fm,c(1,1,1)/3,diff=TRUE),col=2,lwd=2)
#lines(apply(fm,1,mean),col=4,lwd=1)

# MDS
distd <- getdist(fd,diff=TRUE)
mds2 <- cmdscale(distd,eig=TRUE,x.ret=TRUE)
plot(mds2$points[,1],mds2$points[,2],type="n",xlab="",ylab="")
text(mds2$points[,1],mds2$points[,2],as.character(1:p))
abline(h=0,v=0)

# traditional interpretation
sp <- c(12,7,11,25,19)
matplot(tt,t(fd[sp,]),type="l",xlab="",ylab="",col=1) # direction of 1st PC
text(120,fd[sp,120],as.character(1:length(sp)))

sp <- c(22,1,11,15,29)
matplot(tt,t(fd[sp,]),type="l") # direction of 2nd PC
text(120,fd[sp,120],as.character(1:length(sp)))

system.time({

ma <- cenfuna(fd,mds2,diff=TRUE)




pc1u <- backscorea(fd,ma$mean,c(1,0),mds2,diff=TRUE)


pc1d <- backscorea(fd,ma$mean,c(-1,0),mds2,diff=TRUE)


pc2u <- backscorea(fd,ma$mean,c(0,1),mds2,diff=TRUE)


pc2d <- backscorea(fd,ma$mean,c(0,-1),mds2,diff=TRUE)

})

matplot(tt,t(fd),type="l",col=gray(0.75),lty=1,xlab="Frame number",ylab="")
lines(tt,ma$mean,lwd=2)
lines(tt,pc1u$bestfun,col=2,lwd=2)
lines(tt,pc1d$bestfun,col=2,lwd=2)
lines(tt,pc2u$bestfun,col=3,lwd=2)
lines(tt,pc2d$bestfun,col=3,lwd=2)

# Solutions are
meanbest3 <- c(7,15,16)
pc1ubest3 <- c(7,17,25)
pc1dbest3 <- c(1,4,28)
pc2ubest3 <- c(9,18,29)
pc2dbest3 <- c(3,8,16)

# Compute directly using these trios
mak <- cenfunak(fd,mds2,meanbest3,diff=TRUE)
pc1uk <- backscoreak(fd,mak$mean,c(1,0),mds2,pc1ubest3,diff=TRUE)
pc1dk <- backscoreak(fd,mak$mean,c(-1,0),mds2,pc1dbest3,diff=TRUE)
pc2uk <- backscoreak(fd,mak$mean,c(0,1),mds2,pc2ubest3,diff=TRUE)
pc2dk <- backscoreak(fd,mak$mean,c(0,-1),mds2,pc2dbest3,diff=TRUE)

# print version
matplot(tt,t(fd),type="l",col=gray(0.75),lty=1,xlab="Frame number",ylab="")
lines(tt,mak$mean,col=1,lwd=3)
lines(tt,pc1uk$bestfun,lty=1)
lines(tt,pc1dk$bestfun,lty=1)
lines(tt,pc2uk$bestfun,lty=5)
lines(tt,pc2dk$bestfun,lty=5)

dev.off()
