# PCO analysis of shapes
require(shapes)
require(abind)
source("funcs.R")

load("faceshapes.rda")

k <- 38 #no of landmarks
m <- 3
n <- 50 # max no. of shapes


# plot unregistered
plotshapes(shapex, orthproj=c(3,2))

# PCA
spca <- procGPA(shapex, scale=TRUE, tangentresiduals = TRUE)
plotshapes(spca$rotated, orthproj=c(3,2))

# computations based on riemann distance
shapdist <- riemdist

# compute distance matrix
n <- dim(shapex)[3]
distm <- matrix(0,n,n)
for(i in 2:n){
  for(j in 1:(i-1)){
    dd <- riemdist(shapex[,,i],shapex[,,j])
    distm[i,j] <- dd
    distm[j,i] <- dd
  }
}
diag(distm) <- 0

qcmds <- cmdscale(distm,k=2,eig=TRUE,x.ret=TRUE)

# very little difference between PCA and PCO (when scaled right)
plot(spca$scores[,1],spca$scores[,2],type="n")
text(spca$scores[,1],spca$scores[,2],as.character(1:n))

scaled.mds <- scale(qcmds$points)

# arbitrary change of sign
text(-scaled.mds[,1],scaled.mds[,2],as.character(1:n))

cor(spca$scores[,1],-qcmds$points[,1])
cor(spca$scores[,2],qcmds$points[,2])

# PCA based distance to centroid
cendist(shapex,spca$mshap)



# exhaustive search of all triplets
system.time({
mf <- backscore(shapex,NA,c(0,0),qcmds,NA,TRUE)

meanshap <- mf$shapes[,,which.min(mf$rotang)]

pc1u <- backscore(shapex,meanshap,c(1,0),qcmds,NA,TRUE)
pc1d <- backscore(shapex,meanshap,c(-1,0),qcmds,NA,TRUE)
})

# solutions
pc1d$trios[which.min(pc1d$rotang),]
#  3 27 35
pc1u$trios[which.min(pc1u$rotang),]
# 15 16 18
mf$trios[which.min(mf$rotang),]
#  4 18 35

# construct PCA solutions
spcb <- procGPA(shapex, scale=TRUE, tangentresiduals = TRUE)
pcau <- backpca(spcb,c(1,0))
pcad <- backpca(spcb,c(-1,0))

# verify these have the correct scores
scoredat(pcad,shapex,qcmds)/sd(qcmds$points)
scoredat(pcau,shapex,qcmds)/sd(qcmds$points)

# extract the PCO solutions
pcou <- pc1u$shapes[,,which.min(pc1u$rotang)]
pcod <- pc1d$shapes[,,which.min(pc1d$rotang)]

# distances between PCO and PCA solutions
riemdist(meanshap, spcb$mshape)
riemdist(pcou,pcad)
riemdist(pcod,pcau)

# make plotted comparison
cdm <- array(NA,c(38,3,2))
cdm[,,1] <- meanshap
cdm[,,2] <- spcb$mshape
cda <- procGPA(cdm)
plotshapes(cda$rotated,orthproj=c(3,2))


# Search-based solution
set.seed(123)
mf <- centroidfun(shapex,qcmds,100,0.1,TRUE)

pcu <- backpco(shapex,qcmds,c(1,0),mf$shape, 50, step= 0.1, verbose=TRUE)
pcd <- backpco(shapex,qcmds,c(-1,0),mf$shape, 50, step= 0.1, verbose=TRUE)

# distances between PCO and PCA solutions
riemdist(mf$shape, spcb$mshape)
riemdist(pcu$shape,pcad)
riemdist(pcd$shape,pcau)

# make plotted comparison
cdm <- array(NA,c(38,3,2))
cdm[,,1] <- mf$shape
cdm[,,2] <- spcb$mshape
cda <- procGPA(cdm)
plotshapes(cda$rotated,orthproj=c(3,2))

cdm <- array(NA,c(38,3,3))
cdm[,,1] <- mf$shape
cdm[,,2] <- pcu$shape
cdm[,,3] <- pcd$shape
cda <- procGPA(cdm)
plotshapes(cda$rotated,orthproj=c(3,2))



pdf("facepca.pdf",height=3.5,width=6.5)
par(mfrow=c(1,2),mar=c(3.1,3.1,0.1,0.1),mgp=c(1.5,0.5,0))
plotface(mf$shape,dirm="segments",num=FALSE)
plotface(cda$rotated[,,1],cda$rot[,,2],cda$rot[,,3])
dev.off()



# computations based on lele distance
shapdist <- leledist

# compute distance matrix
n <- dim(shapex)[3]
distl <- matrix(0,n,n)
for(i in 2:n){
  for(j in 1:(i-1)){
    dd <- shapdist(shapex[,,i],shapex[,,j])
    distl[i,j] <- dd
    distl[j,i] <- dd
  }
}
diag(distl) <- 0

lmds <- cmdscale(distl,k=2,eig=TRUE,x.ret=TRUE)

# comparison to riemann
cor(lmds$points[,1],qcmds$points[,1])
cor(lmds$points[,2],qcmds$points[,2])

# Search-based solution

mfl <- centroidfun(shapex,lmds,100,0.1,TRUE)

# make plotted comparison
cdm <- array(NA,c(38,3,2))
cdm[,,1] <- mfl$shape
cdm[,,2] <- spcb$mshape
cda <- procGPA(cdm)
plotshapes(cda$rotated,orthproj=c(3,2))


lpcu <- backpco(shapex,lmds,c(1,0),mfl$shape, 100, step= 0.1, verbose=TRUE)
lpcd <- backpco(shapex,lmds,c(-1,0),mfl$shape, 100, step= 0.1, verbose=TRUE)

cdm <- array(NA,c(38,3,3))
cdm[,,1] <- mfl$shape
cdm[,,2] <- lpcu$shape
cdm[,,3] <- lpcd$shape
cda <- procGPA(cdm)

pdf("lelepco.pdf",height=3.5,width=3.5)
par(mar=c(2.1,2.1,0.1,0.1),mgp=c(1.5,0.5,0))
plotface(cda$rotated[,,1],cda$rot[,,2],cda$rot[,,3])
dev.off()
