library(faraway)
data(savings,package="faraway")
lmod <- lm(sr ~ pop15+pop75+dpi+ddpi,savings)
plot(fitted(lmod),residuals(lmod),xlab="Fitted",ylab="Residuals")
abline(h=0)
plot(fitted(lmod),sqrt(abs(residuals(lmod))), xlab="Fitted",ylab=expression(sqrt(hat(epsilon))))
sumary(lm(sqrt(abs(residuals(lmod))) ~ fitted(lmod)))
par(mfrow=c(3,3))
n <- 50
for(i in 1:9) {x <- runif(n) ; plot(x,rnorm(n))}
for(i in 1:9) {x <- runif(n) ; plot(x,x*rnorm(n))}
for(i in 1:9) {x <- runif(n) ; plot(x,sqrt((x))*rnorm(n))}
for(i in 1:9) {x <- runif(n) ; plot(x,cos(x*pi/25)+rnorm(n,sd=1))}
par(mfrow=c(1,1))
plot(savings$pop15,residuals(lmod),  xlab="Population under 15",ylab="Residuals")
abline(h=0)
plot(savings$pop75,residuals(lmod),  xlab="Population over 75",ylab="Residuals")
abline(h=0)
var.test(residuals(lmod)[savings$pop15>35], residuals(lmod)[savings$pop15<35])
data(gala, package="faraway")
lmod <- lm(Species ~ Area + Elevation + Scruz + Nearest  + Adjacent, gala)
plot(fitted(lmod),residuals(lmod),xlab="Fitted",ylab="Residuals")
abline(h=0)
lmod <- lm(sqrt(Species) ~ Area + Elevation + Scruz + Nearest  + Adjacent, gala)
plot(fitted(lmod),residuals(lmod),xlab="Fitted",ylab="Residuals")
abline(h=0)
lmod <- lm(sr ~ pop15+pop75+dpi+ddpi,savings)
qqnorm(residuals(lmod),ylab="Residuals",main="")
qqline(residuals(lmod))
hist(residuals(lmod),xlab="Residuals",main="")
par(mfrow=c(3,3))
n <- 50
for(i in 1:9) {x <- rnorm(n); qqnorm(x); qqline(x)}
for(i in 1:9) {x <- exp(rnorm(n)); qqnorm(x); qqline(x)}
for(i in 1:9) {x <- rcauchy(n); qqnorm(x); qqline(x)}
for(i in 1:9) {x <- runif(n); qqnorm(x); qqline(x)}
par(mfrow=c(1,1))
shapiro.test(residuals(lmod))
data(globwarm,package="faraway")
lmod <- lm(nhtemp ~ wusa + jasper + westgreen + chesapeake + tornetrask + urals + mongolia + tasman, globwarm)
plot(residuals(lmod) ~ year, na.omit(globwarm), ylab="Residuals")
abline(h=0)
n <- length(residuals(lmod))
plot(tail(residuals(lmod),n-1) ~ head(residuals(lmod),n-1), xlab= expression(hat(epsilon)[i]),ylab=expression(hat(epsilon)[i+1]))
abline(h=0,v=0,col=grey(0.75))
sumary(lm(tail(residuals(lmod),n-1) ~ head(residuals(lmod),n-1) -1))
require(lmtest)
dwtest(nhtemp ~ wusa + jasper + westgreen + chesapeake + tornetrask + urals + mongolia + tasman, data=globwarm)
lmod <- lm(sr ~ pop15 + pop75 + dpi + ddpi, savings)
hatv <- hatvalues(lmod)
head(hatv)
sum(hatv)
countries <- row.names(savings)
halfnorm(hatv,labs=countries,ylab="Leverages")
qqnorm(rstandard(lmod))
abline(0,1)
set.seed(123)
testdata <- data.frame(x=1:10,y=1:10+rnorm(10))
lmod <- lm(y ~ x, testdata)
p1 <- c(5.5,12)
lmod1 <- lm(y ~ x, rbind(testdata, p1))
plot(y ~ x, rbind(testdata, p1))
points(5.5,12,pch=4,cex=2)
abline(lmod)
abline(lmod1, lty=2)
p2 <- c(15,15.1)
lmod2 <- lm(y ~ x, rbind(testdata, p2))
plot(y ~ x, rbind(testdata, p2))
points(15,15.1,pch=4,cex=2)
abline(lmod)
abline(lmod2,lty=2)
p3 <- c(15,5.1)
lmod3 <- lm(y ~ x, rbind(testdata, p3))
plot(y ~ x, rbind(testdata, p3))
points(15,5.1,pch=4,cex=2)
abline(lmod)
abline(lmod3,lty=2)
stud <- rstudent(lmod)
stud[which.max(abs(stud))]
qt(.05/(50*2),44)
data(star, package="faraway")
plot(star$temp,star$light,xlab="log(Temperature)",  ylab="log(Light Intensity)")
lmod <- lm(light ~ temp, star)
abline(lmod)
range(rstudent(lmod))
lmodi <- lm(light ~ temp, data=star, subset=(temp>3.6))
abline(lmodi,lty=2)
lmod <- lm(sr ~ pop15+pop75+dpi+ddpi,savings)
cook <- cooks.distance(lmod)
halfnorm(cook,3,labs=countries,ylab="Cook's distances")
lmodi <- lm(sr ~ pop15+pop75+dpi+ddpi,savings,subset=(cook < max(cook)))
sumary(lmodi)
sumary(lmod)
plot(dfbeta(lmod)[,2],ylab="Change in pop15 coef")
abline(h=0)
lmodj <- lm(sr ~ pop15+pop75+dpi+ddpi,savings,subset=(countries != "Japan"))
sumary(lmodj)
plot(lmod)
d <- residuals(lm(sr ~ pop75 + dpi + ddpi,savings))
m <- residuals(lm(pop15 ~ pop75 + dpi + ddpi,savings))
plot(m,d,xlab="pop15 residuals",ylab="Savings residuals")
coef(lm(d ~ m))
lmod <- lm(sr ~ pop15+pop75+dpi+ddpi,savings)
coef(lmod)
abline(0,coef(lmod)['pop15'])
termplot(lmod, partial.resid=TRUE, terms=1)
mod1 <- lm(sr ~ pop15+pop75+dpi+ddpi,savings,subset=(pop15 > 35))
mod2 <- lm(sr ~ pop15+pop75+dpi+ddpi,savings,subset=(pop15 < 35))
sumary(mod1)
sumary(mod2)
savings$status <- ifelse(savings$pop15 > 35, "young", "old")
require(ggplot2)
ggplot(savings,aes(x=ddpi,y=sr,shape=status))+geom_point()
ggplot(savings,aes(x=ddpi,y=sr))+geom_point()+facet_grid(~ status)+stat_smooth(method="lm")
