library(faraway)
data(oatvar,package="faraway")
xtabs(yield ~ variety + block, oatvar)
plot(yield ~ variety, oatvar)
plot(yield ~ block, oatvar)
with(oatvar,interaction.plot(variety,block,yield))
with(oatvar,interaction.plot(block,variety,yield))
require(ggplot2)
ggplot(oatvar,aes(x=variety,y=yield,group=block,linetype=block))+geom_line()+theme(legend.position = "top", legend.direction = "horizontal")
ggplot(oatvar,aes(x=block,y=yield,group=block,linetype=block))+geom_line()
lmod <- lm(yield ~ block+variety, oatvar)
anova(lmod)
anova(lm(yield ~ block, oatvar))
anova(lm(yield ~ variety+block, oatvar))
anova(lm(yield ~ block+variety,subset=-1, oatvar))
anova(lm(yield ~ variety+block,subset=-1, oatvar))
drop1(lm(yield ~ variety+block,subset=-1, oatvar),test="F")
plot(lmod,which=1:2,caption=NULL)
varcoefs <-  c(0,coef(lmod)[6:12])
blockcoefs <-c(0,coef(lmod)[2:5])
ab <- rep(varcoefs,each=5)*rep(blockcoefs,8)
h <- update(lmod,.~.+ab)
anova(h)
lmcrd <- lm(yield ~ variety, oatvar)
summary(lmcrd)$sig
summary(lmod)$sig
(47.047/36.564)^2
data(abrasion,package="faraway")
xtabs(wear ~ run + position, abrasion)
matrix(abrasion$material,4,4,byrow=TRUE)
ggplot(abrasion,aes(x=run,y=wear,shape=position,group=material))+geom_point()+geom_line(aes(linetype=material))
ggplot(abrasion,aes(x=position,y=wear,shape=run,group=material))+geom_point()+geom_line(aes(linetype=material))
lmod <- lm(wear ~ material+run+position, abrasion)
drop1(lmod,test="F")
sumary(lmod)
qtukey(0.95,4,6)*5.53/sqrt(2)
scoefs <- c(0,coef(lmod)[2:4])
outer(scoefs,scoefs,"-")
lmodr <- lm(wear ~ material,abrasion)
(summary(lmodr)$sig/summary(lmod)$sig)^2
data(rabbit,package="faraway")
xtabs(gain ~ treat+block, rabbit)
ggplot(rabbit,aes(y=gain,x=block,shape=treat))+geom_point()+theme(legend.position = "top", legend.direction = "horizontal")
ggplot(rabbit,aes(y=gain,x=treat))+geom_point(position = position_jitter(width = .1))
lmod <- lm(gain ~ block+treat,rabbit)
drop1(lmod, test="F")
plot(lmod, which=1:2)
sumary(lmod)
qtukey(0.95,6,15)
4.59*2.24/sqrt(2)
tcoefs <- c(0,coef(lmod)[11:15])
abs(outer(tcoefs,tcoefs,"-")) > 7.27
lmodt <- lm(gain ~ treat,rabbit)
(summary(lmodt)$sig/summary(lmod)$sig)^2
