library(faraway)
data(coagulation, package="faraway")
coagulation
plot(coag ~ diet, coagulation,ylab="coagulation time")
stripchart(coag ~ diet, coagulation, vertical=TRUE, method="stack",xlab="diet",ylab="coagulation time")
lmod <- lm(coag ~ diet, coagulation)
sumary(lmod)
round(coef(lmod),1)
model.matrix(lmod)
anova(lmod)
lmodi <- lm(coag ~ diet -1, coagulation)
sumary(lmodi)
lmnull <- lm(coag ~ 1, coagulation)
anova(lmnull,lmodi)
options(contrasts=c("contr.sum","contr.poly"))
lmods <- lm(coag ~ diet , coagulation)
sumary(lmods)
qqnorm(residuals(lmod))
qqline(residuals(lmod))
plot(jitter(fitted(lmod)),residuals(lmod),xlab="Fitted",ylab="Residuals")
abline(h=0)
med <- with(coagulation,tapply(coag,diet,median))
ar <- with(coagulation,abs(coag -med[diet]))
anova(lm(ar ~ diet,coagulation))
bartlett.test(coag ~ diet, coagulation)
5 + c(-1,1) * qt(0.975, 24-4) * 1.53
se <- summary(lmod)$sigma
5 + c(-1,1) * qtukey(0.95, 4, 24-4)/sqrt(2) * se * sqrt(1/4 +1/6)
(tci <- TukeyHSD(aov(coag ~ diet, coagulation)))
plot(tci)
data(jsp, package="faraway")
jsp$mathcent <- jsp$math - mean(jsp$math)
require(ggplot2)
ggplot(aes(x=school,y=mathcent),data=jsp)+geom_boxplot() + theme(axis.text.x = element_text(angle = 90))+ylab("Centered Math Scores")
lmod <- lm(mathcent ~ school-1, jsp)
sumary(lmod)
anova(lm(mathcent ~ school, jsp))
pvals <- summary(lmod)$coef[,4]
padj <- p.adjust(pvals, method="bonferroni")
coef(lmod)[padj < 0.05]
names(which(sort(pvals) < (1:49)*0.05/49))
padj <- p.adjust(pvals, method="fdr")
coef(lmod)[padj < 0.05]
