library(faraway)
data(composite, package="faraway")
composite
require(ggplot2)
ggplot(composite,aes(x=laser,y=strength,group=tape,linetype=tape))+geom_line()+theme(legend.position = "top", legend.direction = "horizontal")
ggplot(composite,aes(x=tape,y=strength,group=laser,linetype=laser))+geom_line()+theme(legend.position = "top", legend.direction = "horizontal")
lmod <- lm(strength ~ laser + tape + laser:tape, composite)
sumary(lmod)
lmod <- lm(strength ~ laser + tape, composite)
coef(lmod)
lasercoefs <- rep(c(0,6.5733,12.2133),3)
tapecoefs <- rep(c(0,4.0367,-1.4800),each=3)
tmod <- update(lmod, . ~ . + I(lasercoefs*tapecoefs))
anova(tmod)
anova(lmod)
composite$laser <- as.ordered(composite$laser)
composite$tape <- as.ordered(composite$tape)
lmod <- lm(strength ~ laser + tape, composite)
sumary(lmod)
round(model.matrix(lmod),2)
composite$Ntape <- rep(c(6.42,13,27),each=3)
composite$Nlaser <- rep(c(40,50,60),3)
lmodn <- lm(strength ~ Nlaser + poly(log(Ntape),2), composite)
sumary(lmodn)
data(pvc, package="faraway")
require(ggplot2)
p <- ggplot(pvc, aes(x=operator,y=psize))+geom_point()+stat_summary(fun.y="mean",geom="line",aes(group=resin))
op1means <- with(pvc[pvc$operator == 1,],sapply(split(psize,resin),mean))
tdf <- data.frame(x=rep(0.9,8),y=op1means,label=1:8)
p + geom_text(data=tdf,aes(x=x,y=y,label=label))
ggplot(pvc, aes(x=resin,y=psize,shape=operator))+geom_point()+stat_summary(fun.y="mean",geom="line",aes(group=operator,linetype=operator))+theme(legend.position = "top", legend.direction = "horizontal")
lmod <- lm(psize ~ operator*resin, pvc)
anova(lmod)
anova(lm(psize ~ operator + resin, pvc))
qqnorm(residuals(lmod),main="")
qqline(residuals(lmod))
plot(fitted(lmod),residuals(lmod),xlab="Fitted",ylab="Residuals")
abline(h=0)
plot(residuals(lmod) ~ operator, pvc, ylab="Residuals")
pvce <- pvc[(1:24)*2,]
pvce$res <- sqrt(abs(residuals(lmod))[(1:24)*2])
vmod <- lm(res ~ operator + resin, pvce)
anova(vmod)
lmod <- lm(psize ~ operator+resin, pvc)
sumary(lmod)
TukeyHSD(aov(psize ~ operator+resin,data=pvc))
plot(breaks ~ wool, warpbreaks)
with(warpbreaks,interaction.plot(wool,tension,breaks))
require(ggplot2)
ggplot(warpbreaks, aes(x=wool,y=breaks,shape=tension))+geom_point(position = position_jitter(width = .1))+stat_summary(fun.y="mean",geom="line",aes(group=tension,linetype=tension))+theme(legend.position = "top", legend.direction = "horizontal")
ggplot(warpbreaks, aes(x=tension,y=breaks,shape=wool))+geom_point(position = position_jitter(width = .1))+stat_summary(fun.y="mean",geom="line",aes(group=wool,linetype=wool))+theme(legend.position = "top", legend.direction = "horizontal")
lmod <- lm(breaks ~ wool*tension, warpbreaks)
plot(residuals(lmod) ~ fitted(lmod),xlab="Fitted",ylab="Residuals")
abline(h=0)
lmod <- lm(sqrt(breaks) ~ wool*tension, warpbreaks)
plot(residuals(lmod) ~ fitted(lmod),xlab="Fitted",ylab="Residuals")
abline(h=0)
anova(lmod)
sumary(lmod)
lmod <- lm(sqrt(breaks) ~ wool:tension-1, warpbreaks)
sumary(lmod)
TukeyHSD(aov(breaks ~ wool:tension, warpbreaks))
data(speedo, package="faraway")
speedo
lmod <- lm(y ~ .,speedo)
sumary(lmod)
model.matrix(lmod)
qqnorm(coef(lmod)[-1],pch=names(coef(lmod)[-1]))
halfnorm(coef(lmod)[-1],labs=names(coef(lmod)[-1]))
