library(faraway)
data(cars)
plot(dist ~ speed, cars,ylab="distance")
lmod <- lm(dist ~ speed, cars)
sumary(lmod)
abline(lmod)
lmod1 <- lm(dist ~ I(speed+rnorm(50)), cars)
coef(lmod1)
abline(lmod1,lty=2)
lmod2 <- lm(dist ~ I(speed+2*rnorm(50)), cars)
coef(lmod2)
abline(lmod2,lty=3)
lmod5 <- lm(dist ~ I(speed+5*rnorm(50)), cars)
coef(lmod5)
abline(lmod5,lty=4)
vv <- rep(1:5/10,each=1000)
slopes <- numeric(5000)
for(i in 1:5000) slopes[i] <- lm(dist ~   I(speed+sqrt(vv[i])*rnorm(50)), cars)$coef[2]
betas <- c(coef(lmod)[2],colMeans(matrix(slopes,nrow=1000)))
variances <- c(0,1:5/10)+0.5
plot(variances,betas,xlim=c(0,1),ylim=c(3.86,4))
gv <- lm(betas ~ variances)
coef(gv)
points(0,gv$coef[1],pch=3)
require(simex)
set.seed(123)
lmod <- lm(dist ~ speed, cars, x=TRUE)
simout <- simex(lmod,"speed",0.5, B=1000)
simout
data(savings, package="faraway")
lmod <- lm(sr ~ pop15+pop75+dpi+ddpi,savings)
sumary(lmod)
lmod <- lm(sr ~ pop15+pop75+I(dpi/1000)+ddpi,savings)
sumary(lmod)
scsav <- data.frame(scale(savings))
lmod <- lm(sr ~ ., scsav)
sumary(lmod)
edf <- data.frame(coef(lmod),confint(lmod))[-1,]
names(edf) <- c('Estimate','lb','ub')
require(ggplot2)
p <- ggplot(aes(y=Estimate,ymin=lb,ymax=ub,x=row.names(edf)),data=edf) + geom_pointrange()
p+coord_flip()+xlab("Predictor")+geom_hline(xint=0,col=gray(0.75))
savings$age <- ifelse(savings$pop15 > 35, 0, 1)
savings$dpis <- (savings$dpi-mean(savings$dpi))/(2*sd(savings$dpi))
savings$ddpis <- (savings$ddpi - mean(savings$ddpi))/(2*sd(savings$ddpi))
sumary(lm(sr ~ age + dpis + ddpis, savings))
data(seatpos, package="faraway")
lmod <- lm(hipcenter ~ ., seatpos)
sumary(lmod)
round(cor(seatpos[,-9]),2)
x <- model.matrix(lmod)[,-1]
e <- eigen(t(x) %*% x)
e$val
sqrt(e$val[1]/e$val)
summary(lm(x[,1] ~ x[,-1]))$r.squared
1/(1-0.49948)
require(faraway)
vif(x)
lmod <- lm(hipcenter+10*rnorm(38) ~ ., seatpos)
sumary(lmod)
round(cor(x[,3:8]),2)
lmod2 <- lm(hipcenter ~ Age + Weight + Ht, seatpos)
sumary(lmod2)
