data(ozone, package="faraway")
library(rpart)
(tmod <- rpart(O3 ~ .,ozone))
plot(tmod)
text(tmod)
plot(tmod,compress=T,uniform=T,branch=0.4)
text(tmod)
plot(jitter(predict(tmod)),residuals(tmod),xlab="Fitted",ylab="Residuals")
abline(h=0)
qqnorm(residuals(tmod))
qqline(residuals(tmod))
(x0 <- apply(ozone[,-1],2,median))
predict(tmod,data.frame(t(x0)))
set.seed(123)
tmode <- rpart(O3 ~ .,ozone,cp=0.001)
printcp(tmode)
plotcp(tmod)
library(rpart.plot)
rpart.plot(tmod, type=3)
tmodr <- prune.rpart(tmod,0.0154)
1-sum(residuals(tmodr)^2)/sum((ozone$O3-mean(ozone$O3))^2)
set.seed(123)
tmod <- rpart(O3 ~ ., ozone[sample(330,165),])
(tmods <- prune.rpart(tmod,0.0154))
library(randomForest)
fmod <- randomForest(O3 ~ ., ozone)
plot(fmod, main="")
cvr <- rfcv(ozone[,-1],ozone[,1],step=0.9)
cbind(nvars=cvr$n.var,MSE=cvr$error.cv)
fmod <- randomForest(O3 ~ ., ozone, mtry=9)
1-sum((fmod$predict-ozone$O3)^2)/sum((ozone$O3-mean(ozone$O3))^2)
tgrid <- 20:100
meds <- apply(ozone, 2, median)[-match(c("O3","temp"),names(ozone))]
tdf <- cbind(temp=tgrid, data.frame(t(meds)))
head(tdf)
medfor <- predict(fmod, tdf)
partialPlot(fmod, ozone, "temp", main="")
lines(tgrid, medfor, lty=5)
lmod <- lm(O3 ~ ., ozone)
lmpred <- predict(lmod, tdf)
lines(tgrid, lmpred, lty=2)
importance(fmod)
data(kanga, package="faraway")
x0 <- c(1115,NA,748,182,NA,NA,178,311,756,226,NA,NA,NA,48,1009,NA,204,593)
kanga <- kanga[,c(T,F,!is.na(x0))]
kanga[1:2,]
apply(kanga,2,function(x) sum(is.na(x)))
round(cor(kanga[,-1],use="pairwise.complete.obs")[,c(3,9)],2)
newko <- na.omit(kanga[,-c(4,10)])
dim(newko)
dim(na.omit(kanga))
ggplot(newko, aes(x=zygomatic.width,y=foramina.length,shape=species))+geom_point()+theme(legend.position = "top", legend.direction = "horizontal", legend.title=element_blank())
set.seed(123)
kt <- rpart(species ~ ., data=newko,cp=0.001)
printcp(kt)
(ktp <- prune(kt,cp=0.0211))
plot(ktp,compress=T,uniform=T,branch=0.4)
text(ktp)
(tt <- table(actual=newko$species, predicted=predict(ktp, type="class")))
1-sum(diag(tt))/sum(tt)
pck <- princomp(newko[,-1])
pcdf <- data.frame(species=newko$species,pck$scores)
kt <- rpart(species ~ ., pcdf,cp=0.001)
printcp(kt)
(ktp <- prune.rpart(kt,0.0421))
(tt <- table(newko$species,predict(ktp,type="class")))
1-sum(diag(tt))/sum(tt)
nx0 <- x0[!is.na(x0)]
nx0 <- nx0[-c(3,9)]
nx0 <- (nx0-pck$center)/pck$scale
ndf <- data.frame(nx0 %*% pck$loadings)
predict(ktp, ndf)
library(MASS)
ldamod <- lda(species ~ ., newko)
(tt <- table(newko$species,predict(ldamod)$class))
1-sum(diag(tt))/sum(tt)
cvr <- rfcv(newko[,-1],newko[,1],step=0.9)
cbind(nvars=cvr$n.var,error.rate=cvr$error.cv)
fmod <- randomForest(species ~ ., newko, mtry=6)
(tt <- table(actual=newko$species,predicted=predict(fmod)))
1-sum(diag(tt))/sum(tt)
pck <- princomp(newko[,-1])
pcdf <- data.frame(species=newko$species,pck$scores)
fmod <- randomForest(species ~ ., pcdf, mtry=6)
tt <- table(actual=newko$species,predicted=predict(fmod))
1-sum(diag(tt))/sum(tt)
