data(wcgs, package="faraway")
summary(wcgs[,c("chd","height","cigs")])
plot(height ~ chd, wcgs)
wcgs$y <- ifelse(wcgs$chd == "no",0,1)
plot(jitter(y,0.1) ~ jitter(height), wcgs, xlab="Height",  ylab="Heart Disease", pch=".")
library(ggplot2)
ggplot(wcgs, aes(x=height, color=chd)) + geom_histogram(position="dodge", binwidth=1)
ggplot(wcgs, aes(x=cigs, color=chd)) + geom_histogram(position="dodge", binwidth=5, aes(y=..density..))
ggplot(wcgs, aes(x=height,y=cigs))+geom_point(alpha=0.2, position=position_jitter())+facet_grid(~ chd)
library(faraway)
curve(ilogit(x),-6,6, xlab=expression(eta), ylab="p")
lmod <- glm(chd ~ height + cigs, family = binomial, wcgs)
summary(lmod)
library(faraway)
sumary(lmod)
(beta <- coef(lmod))
plot(jitter(y,0.1) ~ jitter(height), wcgs, xlab="Height", ylab="Heart Disease",pch=".")
curve(ilogit(beta[1] + beta[2]*x + beta[3]*0),add=TRUE)
curve(ilogit(beta[1] + beta[2]*x + beta[3]*20),add=TRUE,lty=2)
plot(jitter(y,0.1) ~ jitter(cigs), wcgs, xlab="Cigarette Use", ylab="Heart Disease",pch=".")
curve(ilogit(beta[1] + beta[2]*60 + beta[3]*x),add=TRUE)
curve(ilogit(beta[1] + beta[2]*78 + beta[3]*x),add=TRUE,lty=2)
exp(beta)
exp(beta[3]*20)
c(ilogit(sum(beta*c(1,68,20))),ilogit(sum(beta*c(1,68,0))))
ilogit(sum(beta*c(1,68,20)))/ilogit(sum(beta*c(1,68,0)))
1-pchisq(32.2,2)
lmodc <- glm(chd ~ cigs, family = binomial, wcgs)
anova(lmodc,lmod, test="Chi")
drop1(lmod,test="Chi")
0.02521 + c(-1,1) * 1.96 * 0.02633
confint(lmod)
linpred <- predict(lmod)
predprob <- predict(lmod, type="response")
head(linpred)
head(predprob)
head(ilogit(linpred))
rawres <- wcgs$y - predprob
plot(rawres ~ linpred, xlab="linear predictor", ylab="residuals")
library(dplyr)
wcgs <- mutate(wcgs, residuals=residuals(lmod), linpred=predict(lmod))
gdf <- group_by(wcgs, cut(linpred, breaks=unique(quantile(linpred, (1:100)/101))))
diagdf <- summarise(gdf, residuals=mean(residuals), linpred=mean(linpred))
plot(residuals ~ linpred, diagdf, xlab="linear predictor")
gdf <- group_by(wcgs, height)
diagdf <- summarise(gdf, residuals=mean(residuals))
ggplot(diagdf, aes(x=height,y=residuals)) + geom_point()
filter(wcgs, height==77) %>% select(height, cigs, chd, residuals)
group_by(wcgs, cigs) %>% summarise(residuals=mean(residuals), count=n()) %>% ggplot(aes(x=cigs, y=residuals, size=sqrt(count))) + geom_point()
qqnorm(residuals(lmod))
halfnorm(hatvalues(lmod))
filter(wcgs, hatvalues(lmod) > 0.015) %>% select(height, cigs, chd)
wcgs$bmi <- with(wcgs, 703*wcgs$weight/(wcgs$height^2))
lmod <- glm(chd ~ age + height + weight +bmi + sdp + dbp + chol + dibep + cigs +arcus, family=binomial, wcgs)
lmodr <- step(lmod, trace=0)
sumary(lmodr)
 drop1(glm(chd ~ dbp, family=binomial, wcgs), test="Chi")
wcgsm <- na.omit(wcgs)
wcgsm <- mutate(wcgsm, predprob=predict(lmod,type="response"))
gdf <- group_by(wcgsm, cut(linpred, breaks=unique(quantile(linpred, (1:100)/101))))
hldf <- summarise(gdf, y=sum(chd=='yes'), ppred=mean(predprob), count=n())
hldf <- mutate(hldf, se.fit=sqrt(ppred*(1-ppred)/count))
ggplot(hldf,aes(x=ppred,y=y/count,ymin=y/count-2*se.fit,ymax=y/count+2*se.fit))+geom_point()+geom_linerange(color=grey(0.75))+geom_abline(intercept=0,slope=1)+xlab("Predicted Probability")+ylab("Observed Proportion")
hlstat <- with(hldf, sum( (y-count*ppred)^2/(count*ppred*(1-ppred))))
c(hlstat, nrow(hldf))
1-pchisq(63.212, 56-1)
wcgsm <- mutate(wcgsm, predout=ifelse(predprob < 0.5, "no", "yes"))
xtabs( ~ chd + predout, wcgsm)
(2882+2)/(2882+3+253+2)
thresh <- seq(0.01,0.5,0.01)
Sensitivity <- numeric(length(thresh))
Specificity <- numeric(length(thresh))
for(j in seq(along=thresh)){
    pp <- ifelse(wcgsm$predprob < thresh[j],"no","yes")
    xx <- xtabs( ~ chd + pp, wcgsm)
    Specificity[j] <- xx[1,1]/(xx[1,1]+xx[1,2])
    Sensitivity[j] <- xx[2,2]/(xx[2,1]+xx[2,2])
}
matplot(thresh,cbind(Sensitivity,Specificity),type="l",xlab="Threshold",ylab="Proportion",lty=1:2)
plot(1-Specificity,Sensitivity,type="l")
abline(0,1,lty=2)
lmodr <- glm(chd ~ age + height  +bmi + sdp + chol + dibep + cigs +arcus, family=binomial, wcgs)
(1-exp((lmodr$dev-lmodr$null)/3140))/(1-exp(-lmodr$null/3140))
library(dplyr)
irisr <- filter(iris, Species != "virginica") %>%  select(Sepal.Width, Sepal.Length,Species)
(p <- ggplot(irisr, aes(x=Sepal.Width, y=Sepal.Length, shape=Species))+geom_point())
lmod <- glm(Species ~ Sepal.Width + Sepal.Length, family=binomial, irisr)
sumary(lmod)
library(brglm)
bmod <- brglm(Species ~ Sepal.Width + Sepal.Length, family=binomial, irisr)
summary(bmod)
p + geom_abline(intercept=(0.5+24.51)/9.73, slope=8.9/9.73)
      plot(Class ~ BNucl, wbca)
    data(kyphosis,package="rpart")
    data(nodal, package="boot")
    help(nodal, package="boot")
  nodal$m <- NULL
  image(as.matrix(nodal))
