data(pulp, package="faraway")
pulpdat <- list(N=20, J=4, response=pulp$bright, predictor=as.numeric(pulp$operator))
library(rstan)
fit <- stan(file = "oneway.stan", data = pulpdat)
traceplot(fit, pars="mu", inc_warmup = TRUE)
traceplot(fit, pars="mu", inc_warmup = FALSE)
fit
library(reshape2)
postsig <- extract(fit, pars=c("sigmaalpha","sigmaepsilon"))
ref <- melt(postsig,value.name="bright")
ggplot(data=ref,aes(x=bright, linetype=L1)) + geom_density()+xlim(0,2)+scale_linetype(name="SD",labels=c("operator","error"))
mean(postsig$sigmaalpha < 0.1)
opre <- rstan::extract(fit, pars="a")
ref <- melt(opre, value.name="bright")
ggplot(data=ref,aes(x=bright, linetype=factor(Var2)))+geom_density()+scale_linetype(name="operator",labels=LETTERS[1:4])
mean(ref[,1] > ref[,4])
fit <- stan(file = "onewaycauchy.stan", data = pulpdat)
print(fit, pars=c("mu","sigmaalpha","sigmaepsilon","a"))
data(penicillin, package="faraway")
penidat <- list(N=20, Nt=4, Nb=5, y=penicillin$yield, treat=as.numeric(penicillin$treat), blk=as.numeric(penicillin$blend))
rt <- stanc(file="rbd.stan")
sm <- stan_model(stanc_ret = rt, verbose=FALSE)
fit <- sampling(sm, data=penidat)
save(sm,file="rbd.RData")
load("rbd.RData")
traceplot(fit, pars="sigmablk", inc_warmup = FALSE)
print(fit, pars=c("trt","sigmablk","sigmaepsilon","bld"), probs=c(0.025,0.5,0.975))
postsig <- rstan::extract(fit, pars=c("sigmablk","sigmaepsilon"))
ref <- melt(postsig,value.name="yield")
ggplot(data=ref,aes(x=yield, linetype=L1))+geom_density()+scale_linetype(name="SD",labels=c("block","error"))
mean(postsig$sigmablk < 1)
bldeff <- rstan::extract(fit, pars="bld")
rdf <- data.frame(yield=unlist(bldeff), blend=gl(5,4000))
ggplot(data=rdf,aes(x=yield, linetype=blend))+geom_density()
trteff <- rstan::extract(fit, pars="trt")
rdf <- data.frame(yield=unlist(trteff), treat=gl(4,4000, labels=LETTERS[1:4]))
ggplot(data=rdf,aes(x=yield, linetype=treat))+geom_density()
mean(trteff$trt[,1] > trteff$trt[,3])
library(INLA)
data(pulp, package="faraway")
formula <- bright ~ f(operator, model="iid")
result <- inla(formula, family="gaussian", data=pulp)
summary(result)
sdres <- sd(pulp$bright)
pcprior <- list(prec = list(prior="pc.prec", param = c(3*sdres,0.01)))
formula <- bright ~ f(operator, model="iid", hyper = pcprior)
result <- inla(formula, family="gaussian", data=pulp)
result <- inla.hyperpar(result)
summary(result)
sigmaalpha <- inla.tmarginal(function(x) 1/sqrt(exp(x)),result$internal.marginals.hyperpar[[2]])
sigmaepsilon <- inla.tmarginal(function(x) 1/sqrt(exp(x)),result$internal.marginals.hyperpar[[1]])
ddf <- data.frame(rbind(sigmaalpha,sigmaepsilon),errterm=gl(2,1024,labels = c("alpha","epsilon")))
ggplot(ddf, aes(x,y, linetype=errterm))+geom_line()+xlab("bright")+ylab("density")+xlim(0,2)
inla.pmarginal(0.1, sigmaalpha)
rdf <- do.call(rbind.data.frame, result$marginals.random$operator)
rdf <- cbind(operator=gl(4,nrow(rdf)/4,labels=letters[1:4]),rdf)
ggplot(rdf, aes(x=x,y=y,linetype=operator))+geom_line()+xlim(-1.5, 1.5)+xlab("bright")+ylab("density")
restab <- sapply(result$marginals.fixed, function(x) inla.zmarginal(x,silent=TRUE))
restab <- cbind(restab, inla.zmarginal(sigmaalpha,silent=TRUE))
restab <- cbind(restab, inla.zmarginal(sigmaepsilon,silent=TRUE))
restab <- cbind(restab, sapply(result$marginals.random$operator,function(x) inla.zmarginal(x, silent=TRUE)))
colnames(restab) = c("mu","alpha","epsilon",levels(pulp$operator))
data.frame(restab)
data(penicillin, package="faraway")
lmod <- lm(yield ~ treat, data=penicillin)
sdres <- sd(residuals(lmod))
pcprior <- list(prec = list(prior="pc.prec", param = c(3*sdres,0.01)))
formula <- yield ~ treat + f(blend, model="iid", hyper = pcprior)
result <- inla(formula, family="gaussian", data=penicillin)
result <- inla.hyperpar(result)
summary(result)
sigmaalpha <- inla.tmarginal(function(x) 1/sqrt(exp(x)),result$internal.marginals.hyperpar[[2]])
sigmaepsilon <- inla.tmarginal(function(x) 1/sqrt(exp(x)),result$internal.marginals.hyperpar[[1]])
restab <- sapply(result$marginals.fixed, function(x) inla.zmarginal(x,silent <- TRUE))
restab <- cbind(restab, inla.zmarginal(sigmaalpha,silent=TRUE))
restab <- cbind(restab, inla.zmarginal(sigmaepsilon,silent=TRUE))
colnames(restab) <- c("mu","B-A","C-A","D-A","alpha","epsilon")
data.frame(restab)
c(inla.mmarginal(sigmaalpha), inla.mmarginal(sigmaepsilon))
ddf <- data.frame(rbind(sigmaalpha,sigmaepsilon),errterm=gl(2,1024,labels = c("alpha","epsilon")))
ggplot(ddf, aes(x,y, linetype=errterm))+geom_line()+xlab("yield")+ylab("density")+xlim(0,15)
inla.pmarginal(1, sigmaalpha)
x <- seq(-15,15,length.out = 100)
rden <- sapply(result$marginals.fixed,function(y) inla.dmarginal(x, y))[,-1]
ddf <- data.frame(yield=rep(x,3), density=as.vector(rden), treat=gl(3,100, labels=c("B-A","C-A","D-A")))
ggplot(ddf, aes(x=yield, y=density, linetype=treat))+geom_line()
inla.pmarginal(0,result$marginals.fixed$treatC)
