data(nes96, package="faraway")
party <-  nes96$PID
levels(party) <- c("Democrat","Democrat","Independent","Independent", "Independent","Republican","Republican")
inca <- c(1.5,4,6,8,9.5,10.5,11.5,12.5,13.5,14.5,16,18.5,21,23.5, 27.5,32.5,37.5,42.5,47.5,55,67.5,82.5,97.5,115)
income <- inca[unclass(nes96$income)]
rnes96 <- data.frame(party, income, education=nes96$educ, age=nes96$age)
summary(rnes96)
library(dplyr)
egp <- group_by(rnes96, education, party) %>% summarise(count=n()) %>% group_by(education) %>% mutate(etotal=sum(count), proportion=count/etotal)
ggplot(egp, aes(x=education, y=proportion, group=party, linetype=party))+geom_line()
igp <- mutate(rnes96, incomegp=cut_number(income,7)) %>% group_by(incomegp, party) %>% summarise(count=n()) %>% group_by(incomegp) %>% mutate(etotal=sum(count), proportion=count/etotal)
ggplot(igp, aes(x=incomegp, y=proportion, group=party, linetype=party))+geom_line()
library(nnet)
mmod <- multinom(party ~ age + education + income, rnes96)
mmodi <- step(mmod)
mmode <- multinom(party ~ age +  income, rnes96)
deviance(mmode) - deviance(mmod)
pchisq(16.206,mmod$edf-mmode$edf,lower=F)
inclevels <- 0:110
preds <- data.frame(income=inclevels,predict(mmodi,data.frame(income=inclevels),type="probs"))
library(tidyr)
lpred <- gather(preds, party, probability, -income)
ggplot(lpred, aes(x=income,y=probability,group=party,linetype=party))+geom_line()
predict(mmodi,data.frame(income=inclevels))
xtabs( ~ predict(mmodi) + rnes96$party)
(284+0+159)/nrow(rnes96)
summary(mmodi)
cc <- c(0,-1.17493,-0.95036)
exp(cc)/sum(exp(cc))
predict(mmodi,data.frame(income=0),type="probs")
(pp <- predict(mmodi,data.frame(income=c(0,1)),type="probs"))
log(pp[1,1]*pp[2,2]/(pp[1,2]*pp[2,1]))
log(pp[1,1]*pp[2,3]/(pp[1,3]*pp[2,1]))
library(MASS)
mlda <- lda(party ~ age + income, rnes96)
mlda
preds <- predict(mlda)
head(preds$posterior)
xtabs( ~ predict(mlda)$class + rnes96$party)
data(cns, package="faraway")
cns
cns$CNS <- cns$An+cns$Sp+cns$Other
plot(log(CNS/NoCNS) ~ Water, cns, pch=as.character(Work))
binmodw <- glm(cbind(CNS,NoCNS) ~ Water + Work, cns, family=binomial)
binmoda <- glm(cbind(CNS,NoCNS) ~ Area + Work, cns, family=binomial)
anova(binmodw,binmoda,test="Chi")
library(faraway)
halfnorm(residuals(binmodw))
sumary(binmodw)
exp(-0.339058)
cmmod <- multinom(cbind(An,Sp,Other) ~ Water + Work, cns)
nmod <- step(cmmod)
nmod
cc <- c(0,0.28963,-0.98083)
names(cc) <- c("An","Sp","Other")
exp(cc)/sum(exp(cc))
multinom(cbind(NoCNS,An,Sp,Other) ~ Water + Work, cns)
x <- seq(-5,5,by=0.1)
xa <- c(21,41,71)
plot(x,dlogis(x),type="l",axes=FALSE,ylab="",xlab="")
segments(x[xa],rep(0,3),x[xa],dlogis(x[xa]))
axis(1,at=x[xa],c(expression(theta[1]),expression(theta[2]),expression(theta[3])))
library(MASS)
pomod <- polr(party ~ age + education + income, rnes96)
c(deviance(pomod),pomod$edf)
c(deviance(mmod),mmod$edf)
pomodi <- step(pomod)
deviance(pomodi)-deviance(pomod)
pchisq(11.151,pomod$edf-pomodi$edf,lower=F)
pim <- with(rnes96,prop.table(table(income,party),1))
logit(pim[,1])-logit(pim[,1]+pim[,2])
summary(pomodi)
ilogit(0.209)
ilogit(1.292)-ilogit(0.209)
inclevels <- seq(0,100,by=20)
predict(pomodi,data.frame(income=inclevels,row.names=inclevels), type="probs")
x <- seq(-4,4,by=0.05)
plot(x,dlogis(x),type="l")
abline(v=c(0.209,1.292))
abline(v=c(0.209,1.292)-50*0.013120,lty=2)
abline(v=c(0.209,1.292)-100*0.013120,lty=5)
library(VGAM)
nmod <- vglm(party ~ income, family=cumulative(parallel=FALSE),rnes96)
summary(nmod)
pmod <- vglm(party ~ income, family=cumulative(parallel=TRUE), rnes96)
deviance(pmod) - deviance(nmod)
1-pchisq(7.82,1)
(1.148-0.329)/(0.0105-0.0162)
opmod <- polr(party ~ income, method="probit", rnes96)
summary(opmod)
dems <- pnorm(0.128-inclevels*0.008182)
demind <- pnorm(0.798-inclevels*0.008182)
data.frame(Democrat=dems,Independent=demind-dems,Republican=1-demind,row.names=inclevels)
polr(party ~ income, method="cloglog")
levels(nes96$income)
inca <- c(1.5,4,6,8,9.5,10.5,11.5,12.5,13.5,14.5,16,18.5,21,23.5, 27.5,32.5,37.5,42.5,47.5,55,67.5,82.5,97.5,115)
nes96$sincome <- inca[unclass(nes96$income)]
lmod <- lm(sincome ~ age + educ + PID, nes96)
sumary(lmod)
lmod2 <- lm(sincome ~ unclass(educ) + unclass(PID), nes96)
anova(lmod2,lmod)
levels(nes96$educ)
levels(nes96$PID)
sumary(lmod2)
