data(orings, package="faraway")
plot(damage/6 ~ temp, orings, xlim=c(25,85), ylim = c(0,1), xlab="Temperature", ylab="Prob of damage")
lmod <- glm(cbind(damage,6-damage) ~ temp, family=binomial,orings)
sumary(lmod)
x <- seq(25,85,1)
lines(x,ilogit(11.6630-0.2162*x))
ilogit(11.6630-0.2162*31)
pchisq(deviance(lmod),df.residual(lmod),lower=FALSE)
pchisq(38.9,22,lower=FALSE)
pchisq(38.9-16.9,1,lower=FALSE)
erings <- with(orings, data.frame(temp=rep(temp,each=6), damage=as.vector(sapply(orings$damage, function(x) rep(c(0,1), times=c(6-x,x))))))
head(erings)
emod <- glm(damage ~ temp, family=binomial, erings)
sumary(emod)
confint(lmod)

deviance(lmod)
1-pchisq(28.067, 21)
data(troutegg, package="faraway")
ftable(xtabs(cbind(survive,total) ~ location+period, troutegg))
bmod <- glm(cbind(survive,total-survive) ~ location+period, family=binomial,troutegg)
sumary(bmod)
halfnorm(residuals(bmod))
elogits <- with(troutegg,log((survive+0.5)/(total- survive+0.5)))
with(troutegg,interaction.plot(period,location,elogits))
(sigma2 <- sum(residuals(bmod,type="pearson")^2)/12)
drop1(bmod,scale=sigma2,test="F")
sumary(bmod,dispersion=sigma2)
library(dispmod)
dmod <- glm.binomial.disp(bmod)
summary(dmod)
data(mammalsleep, package="faraway")
mammalsleep$pdr <- with(mammalsleep, dream/sleep)
summary(mammalsleep$pdr)
modl <- glm(pdr ~ log(body)+ log(brain) + log(lifespan) + log(gestation) + predation + exposure + danger, family=quasibinomial, mammalsleep)
drop1(modl,test="F")
modl <- glm(pdr ~ log(body) + log(lifespan) + danger, family=quasibinomial, mammalsleep )
sumary(modl)
ll <- row.names(na.omit(mammalsleep[,c(1,6,10,11)]))
halfnorm(cooks.distance(modl),labs=ll)
plot(predict(modl),residuals(modl,type="pearson"),  xlab="Linear Predictor", ylab="Pearson Residuals")
data(mammalsleep, package="faraway")
mammalsleep$pdr <- with(mammalsleep, dream/sleep)
library(mgcv)
modb <- gam(pdr ~ log(body)+log(lifespan), family=betar(), mammalsleep)
summary(modb)
data(esoph)
help(esoph)
