data(ctsib, package="faraway")
ctsib$stable <- ifelse(ctsib$CTSIB==1,1,0)
xtabs(stable ~ Surface + Vision, ctsib)/80
library(dplyr)
subsum <- ctsib %>% group_by(Subject) %>% summarise(Height=Height[1],  Weight=Weight[1], stable=mean(stable), Age=Age[1], Sex=Sex[1])
library(ggplot2)
ggplot(subsum, aes(x=Height,y=stable))+geom_point()
ggplot(subsum, aes(x=Weight,y=stable))+geom_point()
ggplot(subsum, aes(x=Age,y=stable))+geom_point()
ggplot(subsum, aes(x=Sex,y=stable))+geom_boxplot()
gf <- glm(stable ~ Sex+Age+Height+Weight+Surface+Vision,binomial,data=ctsib)
sumary(gf)
gfs <- glm(stable ~ Sex + Age + Height + Weight + Surface + Vision + factor(Subject), binomial,data=ctsib)
library(MASS)
modpql <- glmmPQL(stable ~ Sex + Age + Height + Weight + Surface + Vision,  random=~1|Subject,  family=binomial,data=ctsib)
summary(modpql)
library(lme4)
modlap <- glmer(stable ~ Sex + Age + Height + Weight + Surface +  Vision + (1|Subject), family=binomial, data=ctsib)
modgh <- glmer(stable ~ Sex + Age + Height + Weight + Surface +  Vision + (1|Subject), nAGQ=25, family=binomial, data=ctsib)
summary(modgh)
modgh2 <- glmer(stable ~  Surface +  Vision + (1|Subject), nAGQ=25, family=binomial, data=ctsib)
anova(modgh, modgh2)
dd <- fortify(modgh2)
ggplot(dd, aes(sample=.resid))+stat_qq() + facet_grid(Surface~Vision)
library(INLA)
formula <- stable ~  Surface +  Vision + f(Subject, model="iid")
result <- inla(formula, family="binomial", data=ctsib)
sigmaalpha <- inla.tmarginal(function(x) 1/sqrt(x), result$marginals.hyperpar$"Precision for Subject")
x <- seq(0,7,length.out = 100)
sdf <- data.frame(yield = x, density=inla.dmarginal(x, sigmaalpha))
ggplot(sdf,aes(x=yield,y=density))+geom_line()
restab <- sapply(result$marginals.fixed, function(x) inla.zmarginal(x,silent=TRUE))
restab <- cbind(restab, inla.zmarginal(sigmaalpha,silent=TRUE))
colnames(restab) = c("mu","norm","dome","open","alpha")
data.frame(restab)
x <- seq(-2,11,length.out = 100)
rden <- sapply(result$marginals.fixed,function(y) inla.dmarginal(x, y))[,-1]
ddf <- data.frame(yield=rep(x,3), density=as.vector(rden), treat=gl(3,100, labels=c("norm","dome","open")))
ggplot(ddf, aes(x=yield, y=density, linetype=treat))+geom_line()
2*inla.pmarginal(0,result$marginals.fixed$Visiondome)
xm <- model.matrix(~ Sex + Age + Height + Weight + Surface + Vision, ctsib)
stabledat <- with(ctsib, list(Nobs=nrow(ctsib),
  Nsubs=length(unique(ctsib$Subject)), Npreds=ncol(xm),
  y=stable, subject=Subject, x=xm))
library(rstan)
rt <- stanc("glmmbin.stan")
sm <- stan_model(stanc_ret = rt, verbose=FALSE)
fit <- sampling(sm, data=stabledat)
traceplot(fit,pars="sigmasubj", inc_warmup=FALSE)
print(fit,pars=c("sigmasubj","beta"))
ipars <- data.frame(extract(fit, pars=c("sigmasubj","beta")))
colnames(ipars)[-1] <- colnames(xm)
library(reshape2)
rdf <- melt(ipars)
ggplot(rdf, aes(x=value))+geom_density() + facet_wrap(~ variable, scales="free")+geom_vline(xintercept=0)
ppars <- data.frame(extract(fit, pars="subeff"))
sort(colMeans(ppars))
data(epilepsy, package="faraway")
epilepsy$period <- rep(0:4, 59)
epilepsy$drug <- factor(c("placebo","treatment")[epilepsy$treat+1])
epilepsy$phase <- factor(c("baseline","experiment")[epilepsy$expind+1])
epilepsy[epilepsy$id < 2.5,]
library(dplyr)
epilepsy %>%
 group_by(drug, phase) %>%
 summarise(rate=mean(seizures/timeadj)) %>%
 xtabs(formula=rate ~ phase + drug)
ggplot(epilepsy, aes(x=period, y=seizures,  linetype=drug, group=id)) + geom_line() + xlim(1,4) + scale_y_sqrt(breaks=(0:10)^2) + theme(legend.position = "top", legend.direction = "horizontal")
ratesum <- epilepsy %>%
 group_by(id, phase, drug) %>%
 summarise(rate=mean(seizures/timeadj))
library(tidyr)
comsum <- spread(ratesum, phase, rate)
ggplot(comsum, aes(x=baseline, y=experiment, shape=drug)) + geom_point() + scale_x_sqrt() + scale_y_sqrt() + geom_abline(intercept=0, slope=1)+ theme(legend.position = "top", legend.direction = "horizontal")
epilo <- filter(epilepsy, id != 49)
modglm <- glm(seizures ~offset(log(timeadj)) + expind + treat + I(expind*treat), family=poisson, data=epilo)
sumary(modglm)
library(MASS)
modpql <- glmmPQL(seizures ~offset(log(timeadj)) + expind + treat + I(expind*treat), random = ~1|id, family=poisson, data=epilo)
summary(modpql)
library(lme4)
modgh <- glmer(seizures ~offset(log(timeadj)) + expind + treat + I(expind*treat)+ (1|id), nAGQ=25, family=poisson, data=epilo)
summary(modgh)
exp(-0.302)
epilo$id[epilo$id == 59] <- 49
xm <- model.matrix( ~ expind + treat + I(expind*treat), epilo)
epildat <- with(epilo,list(Nobs=nrow(epilo), Nsubs=length(unique(id)),
                              Npreds=ncol(xm),
                              y=seizures,
                              subject=id,
                              x=xm, offset=timeadj))
library(rstan)
rt <- stanc("glmmpois.stan")
sm <- stan_model(stanc_ret = rt, verbose=FALSE)
fit <- sampling(sm, data=epildat)
traceplot(fit,pars="sigmasubj", inc_warmup=FALSE)
ipars <- data.frame(rstan::extract(fit, pars=c("sigmasubj","beta")))
colnames(ipars) <- c("subject","intercept","expind","treat","interaction")
ggplot(ipars, aes(x=subject))+geom_density()
ggplot(ipars, aes(x=interaction))+geom_density() +geom_vline(xintercept=0)
bayespval <- function(x) {p <- mean(x > 0); 2*min(p,1-p)}
smat <-  apply(ipars, 2, function(x) c(mean(x), quantile(x,c(0.025, 0.975)), bayespval(x)))
row.names(smat) <- c("mean","LCB","UCB","pvalue")
t(smat)
formula <- seizures ~offset(log(timeadj)) + expind + treat + I(expind*treat) + f(id,model="iid")
result <- inla(formula, family="poisson", data = epilo)
sigmaalpha <- inla.tmarginal(function(x) 1/sqrt(x), result$marginals.hyperpar$"Precision for id")
restab <- sapply(result$marginals.fixed, function(x) inla.zmarginal(x,silent=TRUE))
restab <- cbind(restab, inla.zmarginal(sigmaalpha,silent=TRUE))
colnames(restab) = c("mu","expind","treat","interaction","alpha")
data.frame(restab)
data(ctsib, package="faraway")
ctsib$stable <- ifelse(ctsib$CTSIB==1,1,0)
library(geepack)
modgeep <- geeglm(stable ~ Sex + Age + Height + Weight + Surface +  Vision, id=Subject, corstr="exchangeable", scale.fix=TRUE,  data=ctsib, family=binomial)
summary(modgeep)
modgeep2 <- geeglm(stable ~ Sex + Age + Height + Weight +  Surface, id=Subject, corstr="exchangeable", scale.fix=TRUE,  data=ctsib, family=binomial)
anova(modgeep2, modgeep)
data(epilepsy, package="faraway")
modgeep <- geeglm(seizures ~offset(log(timeadj)) + expind + treat + I(expind*treat), id=id, family=poisson, corstr="ar1", data=epilepsy, subset=(id!=49))
summary(modgeep)
