data(ozone, package="faraway")
ggplot(ozone, aes(x=temp, y=O3)) + geom_point(size=1) + geom_smooth()
ggplot(ozone, aes(x=ibh, y=O3)) + geom_point(size=1) + geom_smooth() + theme(axis.text.x = element_text(angle = 90))
ggplot(ozone, aes(x=ibt, y=O3)) + geom_point(size=1) + geom_smooth()
olm <- lm(O3 ~ temp + ibh + ibt, ozone)
sumary(olm)
library(effects)
plot(Effect("temp", olm, partial.residuals=TRUE))
plot(Effect("ibh", olm, partial.residuals=TRUE))
plot(Effect("ibt", olm, partial.residuals=TRUE))
library(mgcv)
ammgcv <- gam(O3 ~ s(temp)+s(ibh)+s(ibt),data=ozone)
summary(ammgcv)
plot(ammgcv, residuals=TRUE, select=1)
plot(ammgcv, residuals=TRUE, select=2)
plot(ammgcv, residuals=TRUE, select=3)
am1 <- gam(O3 ~ s(temp)+s(ibh),data=ozone)
am2 <- gam(O3 ~ temp+s(ibh),data=ozone)
anova(am2,am1,test="F")
amint <- gam(O3 ~ te(temp,ibh)+s(ibt),data=ozone)
summary(amint)
anova(ammgcv,amint,test="F")
plot(amint, select=1)
vis.gam(amint,theta=-45,color="gray")
rhs <- function(x,c) ifelse(x > c, x-c, 0)
lhs <- function(x,c) ifelse(x < c, c-x, 0)
olm2 <- lm(O3 ~ rhs(temp,60)+lhs(temp,60)+rhs(ibh,1000)+lhs(ibh,1000),  ozone)
sumary(olm2)
predict(ammgcv,data.frame(temp=60,ibh=2000,ibt=100),se=T)
predict(ammgcv,data.frame(temp=120,ibh=2000,ibt=100),se=T)
plot(residuals(ammgcv)~predict(ammgcv),xlab="Predicted",ylab="Residuals")
abline(h=0)
qqnorm(residuals(ammgcv),main="")
qqline(residuals(ammgcv))
amred <- gam(O3 ~ s(vh)+s(wind)+s(humidity)+s(temp)+s(dpg)+ s(vis)+s(doy),data=ozone)
summary(amred)
alm <- lm(O3 ~ vis+doy+ibt+humidity+temp,data=ozone)
sumary(alm)
gammgcv <- gam(O3 ~ s(temp)+s(ibh)+s(ibt),family=poisson,  scale=-1,data=ozone)
summary(gammgcv)
plot(gammgcv, residuals=TRUE, select=1)
plot(gammgcv, residuals=TRUE, select=2)
plot(gammgcv, residuals=TRUE, select=3)
x <- ozone[,c("temp","ibh","ibt")]
library(acepack)
acefit <- ace(x,ozone$O3)
sumary(lm(ty ~ tx-1, acefit))
plot(ozone$O3,acefit$ty,xlab="O3", ylab=expression(theta(O3)))
plot(x[,1],acefit$tx[,1],xlab="temp",ylab="f(temp)")
plot(x[,2],acefit$tx[,2],xlab="ibh",ylab="f(ibh)")
plot(x[,3],acefit$tx[,3],xlab="ibt",ylab="f(ibt)")
x <- ozone[,-1]
acefit <- ace(x,ozone$O3)
sumary(lm(acefit$ty ~ acefit$tx-1))
y <- cbind(ozone$O3,ozone$O3^2,sqrt(ozone$O3))
x <- ozone[,c("temp","ibh","ibt")]
cancor(x,y)
avasfit <- avas(x,ozone$O3)
plot(ozone$O3,avasfit$ty,xlab="O3",ylab=expression(theta(O3)))
plot(x[,1],avasfit$tx[,1],xlab="temp",ylab="f(temp)")
plot(x[,2],avasfit$tx[,2],xlab="ibh",ylab="f(ibh)")
plot(x[,3],avasfit$tx[,3],xlab="ibt",ylab="f(ibt)")
i <- order(ozone$O3)
plot(ozone$O3[i],avasfit$ty[i],type="l",xlab="O3",ylab=expression(theta(O3)))
gs <- lm(avasfit$ty[i] ~ sqrt(ozone$O3[i]))
lines(ozone$O3[i],gs$fit,lty=2)
gl <- lm(avasfit$ty[i] ~ log(ozone$O3[i]))
lines(ozone$O3[i],gl$fit,lty=5)
lmod <- lm(avasfit$ty ~ avasfit$tx - 1)
sumary(lmod)
plot(predict(lmod),residuals(lmod),xlab="Fitted",ylab="Residuals")
data(epilepsy, package="faraway")
egamm <- gamm(seizures ~ offset(timeadj) + treat*expind+s(age), family=poisson,  random=list(id=~1), data=epilepsy, subset=(id!=49))
summary(egamm$gam)
library(earth)
mmod <- earth(O3 ~ ., ozone)
summary(mmod)
mmod <- earth(O3 ~ ., ozone, nk=7)
summary(mmod)
mmod <- earth(O3 ~ ., ozone, nk=7, degree=2)
summary(mmod)
plotmo(mmod)
plot(mmod,3)
plot(mmod,4)
