/*
 * Decompiled with CFR 0.152.
 */
package javafrontend;

import com.sun.opengl.util.Screenshot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafrontend.AboutFrame;
import javafrontend.AccessoryForm;
import javafrontend.CustomOpenFileFilter;
import javafrontend.CustomSaveFileFilter;
import javafrontend.GLRenderer;
import javafrontend.GraphWindow;
import javafrontend.RectangleBorder;
import javafrontend.WriteFiles;
import javax.imageio.ImageIO;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class MainWindow
extends JFrame {
    public DefaultListModel listModel;
    private JButton aboutButton;
    private JButton backViewButton;
    private JButton bottomViewButton;
    private JButton colorChooserButton;
    private JTextField commandBox;
    private JButton dumpGraphicsButton;
    private JButton editMacroButton;
    private JMenuItem editMacroMenuItem;
    private JMenuItem exit;
    private JMenu fileMenu;
    private JButton frontViewButton;
    private GLCanvas gLJPanel1;
    private JButton isomViewButton;
    private JLabel jLabel1;
    public JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JToolBar.Separator jSeparator10;
    private JToolBar.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JToolBar.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JToolBar jToolBar1;
    private JButton leftViewButton;
    private JTextField macroTitleTextField;
    private JMenuBar mainMenuBar;
    private JButton onlineHelpButton;
    private JList outputBox;
    private JButton panButton;
    private JMenuItem readMacro;
    private JMenuItem reinitialise;
    private JButton repaintButton;
    private JButton rightViewButton;
    private JButton rotateDownButton;
    private JButton rotateLeftButton;
    private JButton rotateRightButton;
    private JButton rotateUpButton;
    private JMenuItem screenShotItem;
    private JButton stopDigButton;
    private JButton submitButton;
    private JButton topViewButton;
    private JLabel uniLogoLabel;
    private JButton zoomAllButton;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JButton zoomWinButton;
    private BindingGroup bindingGroup;
    private GLRenderer myRenderer;
    private String startUpFilesDir;
    private final JFileChooser fc;
    private JFileChooser fs;
    private JComponent Current;
    private Boolean rubberBandFlag = false;
    private RectangleBorder rubberBand = null;
    private int startX;
    private int startY;
    private JDialog dialog = null;
    private GraphWindow graph = null;
    private int graphId = -1;
    private String mainMacroPath = null;
    public Hashtable graphWindowList;
    private String applicationVer = "3.0.7";
    private String applicationBuildDate = "Jan 2011";

    public MainWindow() {
        String property = "java.io.tmpdir";
        String tempDir = System.getProperty(property);
        this.fc = new JFileChooser();
        CustomOpenFileFilter fcFilter = new CustomOpenFileFilter();
        fcFilter.setFilter(this.fc);
        this.fs = new JFileChooser();
        CustomSaveFileFilter fsFilter = new CustomSaveFileFilter();
        fsFilter.setFilter(this.fs);
        this.initComponents();
        this.gLJPanel1.setMinimumSize(new Dimension(0, 0));
        Toolkit toolkit = this.getToolkit();
        ClassLoader cl = this.getClass().getClassLoader();
        Image icon = toolkit.createImage(cl.getResource("icon.png"));
        this.setIconImage(icon);
        this.startUpFilesDir = tempDir;
        try {
            WriteFiles.writeToFile(tempDir + "startup/start.mac", cl.getResourceAsStream("startup/start.mac"), true);
            WriteFiles.writeToFile(tempDir + "startup/start1.mac", cl.getResourceAsStream("startup/start1.mac"), true);
            WriteFiles.writeToFile(tempDir + "startup/sw2.cmd", cl.getResourceAsStream("startup/sw2.cmd"), true);
            WriteFiles.writeToFile(tempDir + "startup/token.dat", cl.getResourceAsStream("startup/token.dat"), true);
            WriteFiles.writeToFile(tempDir + "startup/user.dat", cl.getResourceAsStream("startup/user.dat"), true);
            WriteFiles.writeToFile(tempDir + "startup/deflight.mac", cl.getResourceAsStream("startup/deflight.mac"), true);
        }
        catch (IOException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.listModel = new DefaultListModel();
        this.outputBox.setModel(this.listModel);
        this.graphWindowList = new Hashtable();
        this.myRenderer = new GLRenderer(this);
        this.gLJPanel1.addGLEventListener((GLEventListener)this.myRenderer);
        this.gLJPanel1.setAutoSwapBufferMode(false);
        try {
            this.startCM(this.startUpFilesDir);
        }
        catch (Exception e) {
            System.out.println("In Java:\n\t" + e);
        }
        this.gLJPanel1.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent evt) {
                MainWindow.this.setupViewportForGLCanvas();
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jScrollPane1 = new JScrollPane();
        this.outputBox = new JList();
        this.commandBox = new JTextField();
        this.submitButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jToolBar1 = new JToolBar();
        this.repaintButton = new JButton();
        this.editMacroButton = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.zoomAllButton = new JButton();
        this.zoomInButton = new JButton();
        this.zoomOutButton = new JButton();
        this.zoomWinButton = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.panButton = new JButton();
        this.jSeparator8 = new JToolBar.Separator();
        this.topViewButton = new JButton();
        this.bottomViewButton = new JButton();
        this.frontViewButton = new JButton();
        this.backViewButton = new JButton();
        this.leftViewButton = new JButton();
        this.rightViewButton = new JButton();
        this.isomViewButton = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.rotateUpButton = new JButton();
        this.rotateDownButton = new JButton();
        this.rotateLeftButton = new JButton();
        this.rotateRightButton = new JButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.dumpGraphicsButton = new JButton();
        this.stopDigButton = new JButton();
        this.jSeparator10 = new JToolBar.Separator();
        this.colorChooserButton = new JButton();
        this.jSeparator11 = new JToolBar.Separator();
        this.onlineHelpButton = new JButton();
        this.aboutButton = new JButton();
        this.jSeparator3 = new JSeparator();
        this.gLJPanel1 = new GLCanvas(this.createGLCapabilites());
        this.uniLogoLabel = new JLabel();
        this.macroTitleTextField = new JTextField();
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.readMacro = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.editMacroMenuItem = new JMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.screenShotItem = new JMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.reinitialise = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.exit = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Constraint Modeller Web Interface");
        this.setMinimumSize(new Dimension(799, 700));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainWindow.this.windowClosing(evt);
            }
        });
        this.outputBox.setSelectionMode(0);
        this.outputBox.setCursor(new Cursor(0));
        this.jScrollPane1.setViewportView(this.outputBox);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.outputBox, (Property)ELProperty.create((String)"${selectedElement}"), (Object)this.commandBox, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST"));
        this.bindingGroup.addBinding((Binding)binding);
        this.commandBox.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainWindow.this.commandBoxKeyPressed(evt);
            }
        });
        this.submitButton.setText("Submit!");
        this.submitButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.submitButtonMousePressed(evt);
            }
        });
        this.jLabel1.setText("Command:");
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setToolTipText("Repaint");
        this.repaintButton.setIcon(new ImageIcon(this.getClass().getResource("/repaint.png")));
        this.repaintButton.setToolTipText("Repaint");
        this.repaintButton.setFocusable(false);
        this.repaintButton.setHorizontalTextPosition(0);
        this.repaintButton.setMaximumSize(new Dimension(32, 32));
        this.repaintButton.setMinimumSize(new Dimension(32, 32));
        this.repaintButton.setPreferredSize(new Dimension(32, 32));
        this.repaintButton.setVerticalTextPosition(3);
        this.repaintButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.repaintButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.repaintButton);
        this.editMacroButton.setIcon(new ImageIcon(this.getClass().getResource("/edit.PNG")));
        this.editMacroButton.setToolTipText("Edit main macro");
        this.editMacroButton.setFocusable(false);
        this.editMacroButton.setHorizontalTextPosition(0);
        this.editMacroButton.setVerticalTextPosition(3);
        this.editMacroButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.editMacroButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.editMacroButton);
        this.jToolBar1.add(this.jSeparator5);
        this.zoomAllButton.setIcon(new ImageIcon(this.getClass().getResource("/zoom_all.png")));
        this.zoomAllButton.setToolTipText("Zoom all");
        this.zoomAllButton.setFocusable(false);
        this.zoomAllButton.setHorizontalTextPosition(0);
        this.zoomAllButton.setMaximumSize(new Dimension(32, 32));
        this.zoomAllButton.setMinimumSize(new Dimension(32, 32));
        this.zoomAllButton.setPreferredSize(new Dimension(32, 32));
        this.zoomAllButton.setVerticalTextPosition(3);
        this.zoomAllButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.zoomAllButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.zoomAllButton);
        this.zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("/zoom_in.png")));
        this.zoomInButton.setToolTipText("Zoom in");
        this.zoomInButton.setFocusable(false);
        this.zoomInButton.setHorizontalTextPosition(0);
        this.zoomInButton.setMaximumSize(new Dimension(32, 32));
        this.zoomInButton.setMinimumSize(new Dimension(32, 32));
        this.zoomInButton.setPreferredSize(new Dimension(32, 32));
        this.zoomInButton.setVerticalTextPosition(3);
        this.zoomInButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.zoomInButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.zoomInButton);
        this.zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("/zoom_out.png")));
        this.zoomOutButton.setToolTipText("Zoom out");
        this.zoomOutButton.setFocusable(false);
        this.zoomOutButton.setHorizontalTextPosition(0);
        this.zoomOutButton.setMaximumSize(new Dimension(32, 32));
        this.zoomOutButton.setMinimumSize(new Dimension(32, 32));
        this.zoomOutButton.setPreferredSize(new Dimension(32, 32));
        this.zoomOutButton.setVerticalTextPosition(3);
        this.zoomOutButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.zoomOutButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.zoomOutButton);
        this.zoomWinButton.setIcon(new ImageIcon(this.getClass().getResource("/zoom_window.png")));
        this.zoomWinButton.setToolTipText("Zoom window");
        this.zoomWinButton.setCursor(new Cursor(0));
        this.zoomWinButton.setFocusable(false);
        this.zoomWinButton.setHorizontalTextPosition(0);
        this.zoomWinButton.setVerticalTextPosition(3);
        this.zoomWinButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.zoomWinButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.zoomWinButton);
        this.jToolBar1.add(this.jSeparator4);
        this.panButton.setIcon(new ImageIcon(this.getClass().getResource("/pan.png")));
        this.panButton.setToolTipText("Pan");
        this.panButton.setFocusable(false);
        this.panButton.setHorizontalTextPosition(0);
        this.panButton.setVerticalTextPosition(3);
        this.panButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.panButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.panButton);
        this.jToolBar1.add(this.jSeparator8);
        this.topViewButton.setIcon(new ImageIcon(this.getClass().getResource("/top_view.png")));
        this.topViewButton.setToolTipText("Top view");
        this.topViewButton.setFocusable(false);
        this.topViewButton.setHorizontalTextPosition(0);
        this.topViewButton.setMaximumSize(new Dimension(32, 32));
        this.topViewButton.setMinimumSize(new Dimension(32, 32));
        this.topViewButton.setPreferredSize(new Dimension(32, 32));
        this.topViewButton.setVerticalTextPosition(3);
        this.topViewButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.topViewButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.topViewButton);
        this.bottomViewButton.setIcon(new ImageIcon(this.getClass().getResource("/bottom_view.png")));
        this.bottomViewButton.setToolTipText("Bottom view");
        this.bottomViewButton.setFocusable(false);
        this.bottomViewButton.setHorizontalTextPosition(0);
        this.bottomViewButton.setMaximumSize(new Dimension(32, 32));
        this.bottomViewButton.setMinimumSize(new Dimension(32, 32));
        this.bottomViewButton.setPreferredSize(new Dimension(32, 32));
        this.bottomViewButton.setVerticalTextPosition(3);
        this.bottomViewButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.bottomViewButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.bottomViewButton);
        this.frontViewButton.setIcon(new ImageIcon(this.getClass().getResource("/front_view.png")));
        this.frontViewButton.setToolTipText("Front view");
        this.frontViewButton.setFocusable(false);
        this.frontViewButton.setHorizontalTextPosition(0);
        this.frontViewButton.setMaximumSize(new Dimension(32, 32));
        this.frontViewButton.setMinimumSize(new Dimension(32, 32));
        this.frontViewButton.setPreferredSize(new Dimension(32, 32));
        this.frontViewButton.setVerticalTextPosition(3);
        this.frontViewButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.frontViewButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.frontViewButton);
        this.backViewButton.setIcon(new ImageIcon(this.getClass().getResource("/back_view.png")));
        this.backViewButton.setToolTipText("Back view");
        this.backViewButton.setFocusable(false);
        this.backViewButton.setHorizontalTextPosition(0);
        this.backViewButton.setMaximumSize(new Dimension(32, 32));
        this.backViewButton.setMinimumSize(new Dimension(32, 32));
        this.backViewButton.setPreferredSize(new Dimension(32, 32));
        this.backViewButton.setVerticalTextPosition(3);
        this.backViewButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.backViewButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.backViewButton);
        this.leftViewButton.setIcon(new ImageIcon(this.getClass().getResource("/left_view.png")));
        this.leftViewButton.setToolTipText("Left view");
        this.leftViewButton.setFocusable(false);
        this.leftViewButton.setHorizontalTextPosition(0);
        this.leftViewButton.setMaximumSize(new Dimension(32, 32));
        this.leftViewButton.setMinimumSize(new Dimension(32, 32));
        this.leftViewButton.setPreferredSize(new Dimension(32, 32));
        this.leftViewButton.setVerticalTextPosition(3);
        this.leftViewButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.leftViewButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.leftViewButton);
        this.rightViewButton.setIcon(new ImageIcon(this.getClass().getResource("/right_view.png")));
        this.rightViewButton.setToolTipText("Right View");
        this.rightViewButton.setFocusable(false);
        this.rightViewButton.setHorizontalTextPosition(0);
        this.rightViewButton.setMaximumSize(new Dimension(32, 32));
        this.rightViewButton.setMinimumSize(new Dimension(32, 32));
        this.rightViewButton.setPreferredSize(new Dimension(32, 32));
        this.rightViewButton.setVerticalTextPosition(3);
        this.rightViewButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.rightViewButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.rightViewButton);
        this.isomViewButton.setIcon(new ImageIcon(this.getClass().getResource("/isom_view.png")));
        this.isomViewButton.setToolTipText("Isometric view");
        this.isomViewButton.setFocusable(false);
        this.isomViewButton.setHorizontalTextPosition(0);
        this.isomViewButton.setMaximumSize(new Dimension(32, 32));
        this.isomViewButton.setMinimumSize(new Dimension(32, 32));
        this.isomViewButton.setPreferredSize(new Dimension(32, 32));
        this.isomViewButton.setVerticalTextPosition(3);
        this.isomViewButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.isomViewButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.isomViewButton);
        this.jToolBar1.add(this.jSeparator6);
        this.rotateUpButton.setIcon(new ImageIcon(this.getClass().getResource("/up.png")));
        this.rotateUpButton.setToolTipText("Rotate up");
        this.rotateUpButton.setFocusable(false);
        this.rotateUpButton.setHorizontalTextPosition(0);
        this.rotateUpButton.setVerticalTextPosition(3);
        this.rotateUpButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.rotateUpButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.rotateUpButton);
        this.rotateDownButton.setIcon(new ImageIcon(this.getClass().getResource("/down.png")));
        this.rotateDownButton.setToolTipText("Rotate down");
        this.rotateDownButton.setFocusable(false);
        this.rotateDownButton.setHorizontalTextPosition(0);
        this.rotateDownButton.setVerticalTextPosition(3);
        this.rotateDownButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.rotateDownButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.rotateDownButton);
        this.rotateLeftButton.setIcon(new ImageIcon(this.getClass().getResource("/left.png")));
        this.rotateLeftButton.setToolTipText("Rotate left");
        this.rotateLeftButton.setFocusable(false);
        this.rotateLeftButton.setHorizontalTextPosition(0);
        this.rotateLeftButton.setVerticalTextPosition(3);
        this.rotateLeftButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.rotateLeftButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.rotateLeftButton);
        this.rotateRightButton.setIcon(new ImageIcon(this.getClass().getResource("/right.png")));
        this.rotateRightButton.setToolTipText("Rotate right");
        this.rotateRightButton.setFocusable(false);
        this.rotateRightButton.setHorizontalTextPosition(0);
        this.rotateRightButton.setVerticalTextPosition(3);
        this.rotateRightButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.rotateRightButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.rotateRightButton);
        this.jToolBar1.add(this.jSeparator7);
        this.dumpGraphicsButton.setIcon(new ImageIcon(this.getClass().getResource("/pi.png")));
        this.dumpGraphicsButton.setToolTipText("Dump graphics");
        this.dumpGraphicsButton.setFocusable(false);
        this.dumpGraphicsButton.setHorizontalTextPosition(0);
        this.dumpGraphicsButton.setVerticalTextPosition(3);
        this.dumpGraphicsButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.dumpGraphicsButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.dumpGraphicsButton);
        this.stopDigButton.setIcon(new ImageIcon(this.getClass().getResource("/stop.png")));
        this.stopDigButton.setToolTipText("Stop digging");
        this.stopDigButton.setFocusable(false);
        this.stopDigButton.setHorizontalTextPosition(0);
        this.stopDigButton.setVerticalTextPosition(3);
        this.stopDigButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.stopDigButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.stopDigButton);
        this.jToolBar1.add(this.jSeparator10);
        this.colorChooserButton.setIcon(new ImageIcon(this.getClass().getResource("/colors.png")));
        this.colorChooserButton.setToolTipText("Background colour");
        this.colorChooserButton.setFocusable(false);
        this.colorChooserButton.setHorizontalTextPosition(0);
        this.colorChooserButton.setVerticalTextPosition(3);
        this.colorChooserButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.colorChooserButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.colorChooserButton);
        this.jToolBar1.add(this.jSeparator11);
        this.onlineHelpButton.setIcon(new ImageIcon(this.getClass().getResource("/help.png")));
        this.onlineHelpButton.setToolTipText("Online help");
        this.onlineHelpButton.setFocusable(false);
        this.onlineHelpButton.setHorizontalTextPosition(0);
        this.onlineHelpButton.setVerticalTextPosition(3);
        this.onlineHelpButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.onlineHelpButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.onlineHelpButton);
        this.aboutButton.setIcon(new ImageIcon(this.getClass().getResource("/icon.png")));
        this.aboutButton.setToolTipText("About");
        this.aboutButton.setFocusable(false);
        this.aboutButton.setHorizontalTextPosition(0);
        this.aboutButton.setVerticalTextPosition(3);
        this.aboutButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.aboutButtonMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.aboutButton);
        this.gLJPanel1.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                MainWindow.this.gLJPanel1MouseWheelMoved(evt);
            }
        });
        this.gLJPanel1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.gLJPanel1MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                MainWindow.this.gLJPanel1MouseReleased(evt);
            }
        });
        this.gLJPanel1.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                MainWindow.this.gLJPanel1MouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                MainWindow.this.gLJPanel1MouseMoved(evt);
            }
        });
        this.uniLogoLabel.setIcon(new ImageIcon(this.getClass().getResource("/uob-logo-black-transparent.png")));
        this.uniLogoLabel.setToolTipText("University of Bath");
        this.uniLogoLabel.setCursor(new Cursor(12));
        this.uniLogoLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.uniLogoLabelMousePressed(evt);
            }
        });
        this.macroTitleTextField.setEditable(false);
        this.macroTitleTextField.setText("University of Bath - Constraint Modeller");
        this.macroTitleTextField.setBorder(null);
        this.macroTitleTextField.setOpaque(false);
        this.mainMenuBar.setAutoscrolls(true);
        this.mainMenuBar.setMaximumSize(new Dimension(100, 100));
        this.mainMenuBar.setPreferredSize(new Dimension(50, 23));
        this.fileMenu.setText("File");
        this.readMacro.setIcon(new ImageIcon(this.getClass().getResource("/run.png")));
        this.readMacro.setText("Run Macro");
        this.readMacro.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.readMacroMousePressed(evt);
            }
        });
        this.fileMenu.add(this.readMacro);
        this.fileMenu.add(this.jSeparator1);
        this.editMacroMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/edit.PNG")));
        this.editMacroMenuItem.setText("Edit Main Macro");
        this.editMacroMenuItem.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.editMacroMenuItemMousePressed(evt);
            }
        });
        this.fileMenu.add(this.editMacroMenuItem);
        this.fileMenu.add(this.jSeparator13);
        this.screenShotItem.setIcon(new ImageIcon(this.getClass().getResource("/camera.png")));
        this.screenShotItem.setText("Screen Shot");
        this.screenShotItem.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.screenShotItemMousePressed(evt);
            }
        });
        this.fileMenu.add(this.screenShotItem);
        this.fileMenu.add(this.jSeparator12);
        this.reinitialise.setIcon(new ImageIcon(this.getClass().getResource("/init.png")));
        this.reinitialise.setText("Reinitialise..");
        this.reinitialise.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.reinitialiseMousePressed(evt);
            }
        });
        this.fileMenu.add(this.reinitialise);
        this.fileMenu.add(this.jSeparator9);
        this.exit.setIcon(new ImageIcon(this.getClass().getResource("/exit.png")));
        this.exit.setText("Exit");
        this.exit.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainWindow.this.exitMousePressed(evt);
            }
        });
        this.fileMenu.add(this.exit);
        this.mainMenuBar.add(this.fileMenu);
        this.setJMenuBar(this.mainMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, GroupLayout.Alignment.TRAILING, -1, 837, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 817, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.commandBox, -1, 669, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.submitButton))).addContainerGap()).addComponent(this.jSeparator2, GroupLayout.Alignment.TRAILING, -1, 837, Short.MAX_VALUE).addComponent(this.jSeparator3, -1, 837, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.gLJPanel1, -1, 817, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.macroTitleTextField, -1, 690, Short.MAX_VALUE).addGap(46, 46, 46).addComponent(this.uniLogoLabel).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.commandBox, -2, -1, -2).addComponent(this.submitButton).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.gLJPanel1, -1, 474, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.uniLogoLabel).addComponent(this.macroTitleTextField, -2, -1, -2)).addContainerGap()));
        this.bindingGroup.bind();
        this.pack();
    }

    private GLCapabilities createGLCapabilites() {
        GLCapabilities capabilities = new GLCapabilities();
        capabilities.setHardwareAccelerated(true);
        capabilities.setDoubleBuffered(true);
        return capabilities;
    }

    private void windowClosing(WindowEvent evt) {
        this.shutDownInterface();
    }

    private void submitButtonMousePressed(MouseEvent evt) {
        this.executeCommand();
    }

    private void commandBoxKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.executeCommand();
        }
    }

    private void repaintButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("repaint");
    }

    private void zoomAllButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("zoom");
    }

    private void zoomInButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("zoom_up");
    }

    private void zoomOutButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("zoom_down");
    }

    private void topViewButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("view_top");
    }

    private void bottomViewButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("view_bottom");
    }

    private void frontViewButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("view_front");
    }

    private void backViewButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("view_back");
    }

    private void leftViewButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("view_left");
    }

    private void rightViewButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("view_right");
    }

    private void isomViewButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("view_isom");
    }

    private void rotateUpButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("rotate_up");
    }

    private void rotateDownButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("rotate_down");
    }

    private void rotateLeftButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("rotate_left");
    }

    private void rotateRightButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("rotate_right");
    }

    private void dumpGraphicsButtonMousePressed(MouseEvent evt) {
        this.runCMCommand("dump_graphics");
    }

    private void reinitialiseMousePressed(MouseEvent evt) {
        this.reInitialiseSwords();
    }

    private void readMacroMousePressed(MouseEvent evt) {
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            String filePath = file.getAbsolutePath();
            this.reInitialiseSwords();
            this.runCMCommand("graphics");
            String pathfile = "rootpathfile(\"" + file.getParent() + "\\\")";
            this.runCMCommand(pathfile);
            String changePath = "pathfilepos(\"\\\",0)";
            this.runCMCommand(changePath);
            this.mainMacroPath = filePath.toString();
            String command = "read(\"" + filePath + "\")";
            this.runCMCommand(command);
        }
    }

    private void zoomWinButtonMousePressed(MouseEvent evt) {
        if (this.rubberBand == null) {
            this.rubberBand = new RectangleBorder(Color.orange);
        }
        this.rubberBandFlag = true;
        this.runCMCommand("zoom_window");
    }

    private void panButtonMousePressed(MouseEvent evt) {
        this.gLJPanel1.setCursor(new Cursor(13));
        this.runCMCommand("pan");
    }

    private void stopDigButtonMousePressed(MouseEvent evt) {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        this.runCMCommand("stop_digging");
    }

    private void exitMousePressed(MouseEvent evt) {
        this.shutDownInterface();
        this.dispose();
    }

    private void aboutButtonMousePressed(MouseEvent evt) {
        try {
            AboutFrame aboutDialog = new AboutFrame(this.applicationVer);
            aboutDialog.setVisible(true);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void colorChooserButtonMousePressed(MouseEvent evt) {
        Color backgroundColor = JColorChooser.showDialog(this, "Choose Background Color", Color.black);
        if (backgroundColor != null) {
            float r = (float)backgroundColor.getRed() / 255.0f;
            float g = (float)backgroundColor.getGreen() / 255.0f;
            float b = (float)backgroundColor.getBlue() / 255.0f;
            String colorCommand = "background(" + r + "," + g + "," + b + ")";
            this.runCMCommand("graphics");
            this.runCMCommand(colorCommand);
            this.runCMCommand("repaint");
        }
    }

    private void onlineHelpButtonMousePressed(MouseEvent evt) {
        try {
            URI uri = new URI("http://www.bath.ac.uk/mech-eng/constraintmodelling/help/index.html");
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(uri);
                }
                catch (IOException e) {}
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void screenShotItemMousePressed(MouseEvent evt) {
        this.runCMCommand("graphics");
        AccessoryForm acc = new AccessoryForm();
        acc.setWidthField(this.gLJPanel1.getWidth());
        acc.setHEightField(this.gLJPanel1.getHeight());
        this.fs.setAccessory(acc);
        int returnVal = this.fs.showSaveDialog(this);
        if (returnVal != 0) return;
        File imageCapture = this.fs.getSelectedFile();
        String path = imageCapture.getAbsolutePath();
        String extension = null;
        if (this.fs.getFileFilter().getDescription().startsWith("PNG")) {
            extension = "png";
        }
        if (this.fs.getFileFilter().getDescription().startsWith("JPG")) {
            extension = "jpg";
        }
        if (this.fs.getFileFilter().getDescription().startsWith("BMP")) {
            extension = "bmp";
        }
        if (this.fs.getFileFilter().getDescription().startsWith("GIF")) {
            extension = "gif";
        }
        if (this.fs.getFileFilter().getDescription().startsWith("All")) {
            extension = "png";
        }
        if (!path.endsWith(extension)) {
            imageCapture = new File(path + "." + extension);
        }
        if (imageCapture.exists()) {
            int overwrite = JOptionPane.showConfirmDialog(this, imageCapture.getName() + " : this file aldready exists.\n" + "Do you want to overwrite it ?", "Warning", 2);
            if (overwrite != 0) return;
            BufferedImage img = Screenshot.readToBufferedImage((int)acc.getWidthField(), (int)acc.getHeightField());
            try {
                ImageIO.write((RenderedImage)img, extension, imageCapture);
                return;
            }
            catch (IOException ex) {
                Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
            }
            return;
        }
        BufferedImage img = Screenshot.readToBufferedImage((int)acc.getWidthField(), (int)acc.getHeightField());
        try {
            ImageIO.write((RenderedImage)img, extension, imageCapture);
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void gLJPanel1MousePressed(MouseEvent evt) {
        this.startX = evt.getX();
        this.startY = evt.getY();
        if (evt.getButton() == 3) {
            ClassLoader cl = this.getClass().getClassLoader();
            ImageIcon panIcon = new ImageIcon(cl.getResource("pan_small.png"));
            ImageIcon zoomIcon = new ImageIcon(cl.getResource("zoom_all_small.png"));
            ImageIcon zoomWinIcon = new ImageIcon(cl.getResource("zoom_window_small.png"));
            ImageIcon repaintIcon = new ImageIcon(cl.getResource("repaint_small.png"));
            JPopupMenu rightClickMenu = new JPopupMenu();
            rightClickMenu.setLightWeightPopupEnabled(false);
            JMenuItem panMenuItem = new JMenuItem();
            panMenuItem.setText("Pan");
            panMenuItem.setIcon(panIcon);
            JMenuItem zoomMenuItem = new JMenuItem();
            zoomMenuItem.setText("Zoom All");
            zoomMenuItem.setIcon(zoomIcon);
            JMenuItem zoomWinMenuItem = new JMenuItem();
            zoomWinMenuItem.setText("Zoom Window");
            zoomWinMenuItem.setIcon(zoomWinIcon);
            JMenuItem repaintMenuItem = new JMenuItem();
            repaintMenuItem.setText("Repaint");
            repaintMenuItem.setIcon(repaintIcon);
            panMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainWindow.this.runCMCommand("pan");
                    MainWindow.this.gLJPanel1.setCursor(new Cursor(13));
                }
            });
            zoomMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainWindow.this.runCMCommand("zoom");
                }
            });
            zoomWinMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (MainWindow.this.rubberBand == null) {
                        MainWindow.this.rubberBand = new RectangleBorder(Color.orange);
                    }
                    MainWindow.this.rubberBandFlag = true;
                    MainWindow.this.runCMCommand("zoom_window");
                }
            });
            repaintMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainWindow.this.runCMCommand("repaint");
                }
            });
            rightClickMenu.add(panMenuItem);
            rightClickMenu.add(zoomMenuItem);
            rightClickMenu.add(repaintMenuItem);
            rightClickMenu.add(zoomWinMenuItem);
            rightClickMenu.show((Component)this.gLJPanel1, evt.getX(), evt.getY());
        }
        if (evt.getButton() == 2) {
            this.gLJPanel1.setCursor(new Cursor(13));
            this.javaMousePressed(evt.getX(), evt.getY(), evt.getButton());
        } else {
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            this.javaMousePressed(evt.getX(), evt.getY(), evt.getButton());
        }
    }

    private void gLJPanel1MouseReleased(MouseEvent evt) {
        this.gLJPanel1.setCursor(new Cursor(0));
        this.javaMouseReleased(evt.getButton());
        this.gLJPanel1.display();
        if (this.rubberBand != null) {
            this.rubberBand.paintBorder((Component)this.gLJPanel1, this.gLJPanel1.getGraphics(), 0, 0, 0, 0);
        }
        this.rubberBandFlag = false;
    }

    private void gLJPanel1MouseDragged(MouseEvent evt) {
        this.gLJPanel1.display();
        if (this.rubberBandFlag.booleanValue() && this.rubberBand != null) {
            int width = evt.getX() - this.startX;
            int height = evt.getY() - this.startY;
            this.rubberBand.paintBorder((Component)this.gLJPanel1, this.gLJPanel1.getGraphics(), this.startX, this.startY, width, height);
        }
        this.javaMouseMoved(evt.getX(), evt.getY(), evt.getButton());
    }

    private void gLJPanel1MouseMoved(MouseEvent evt) {
    }

    private void gLJPanel1MouseWheelMoved(MouseWheelEvent evt) {
        int wheelRotationDirection = evt.getWheelRotation();
        this.javaWheelMoved(wheelRotationDirection);
    }

    private void uniLogoLabelMousePressed(MouseEvent evt) {
        try {
            URI uri = new URI("http://www.bath.ac.uk/");
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(uri);
                }
                catch (IOException e) {}
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void editMacroMenuItemMousePressed(MouseEvent evt) {
        this.openMainMacro();
    }

    private void editMacroButtonMousePressed(MouseEvent evt) {
        this.openMainMacro();
    }

    public void processEvent() throws InterruptedException {
        this.dialog = new JDialog();
        this.dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.dialog.setUndecorated(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
        this.dialog.setSize(400, 400);
    }

    private void executeCommand() {
        String command = this.commandBox.getText();
        this.listModel.add(0, command);
        this.commandBox.setText(null);
        if (!command.isEmpty()) {
            if (command.equals("init")) {
                this.reInitialiseSwords();
            }
            if (command.startsWith("read") && command.endsWith(".mac")) {
                String temp = command;
                String[] tempString = temp.split("\"");
                String filePath = tempString[1];
                if (new File(filePath).exists()) {
                    this.reInitialiseSwords();
                    File tempFile = new File(filePath);
                    String pathfile = "rootpathfile(\"" + tempFile.getParent() + "\")";
                    this.runCMCommand(pathfile);
                    String changePath = "pathfile(\"\\\")";
                    this.runCMCommand(changePath);
                }
                this.mainMacroPath = tempString[1].toString();
            }
            try {
                String commandStatusCM = this.handleCommandCM(command);
            }
            catch (Exception e) {
                this.listModel.add(0, e.getMessage());
            }
        }
    }

    public void removeJavaUserMenu() {
        Component[] components;
        for (Component c : components = this.mainMenuBar.getComponents()) {
            if (!c.equals(this.fileMenu)) {
                this.mainMenuBar.remove(c);
            }
            this.mainMenuBar.updateUI();
        }
    }

    public void createMenu(String title) {
        JMenu menu = new JMenu(title);
        menu.setToolTipText(title);
        this.mainMenuBar.add(menu);
        this.Current = menu;
    }

    public void createSubMenu(String title) {
        JMenu subMenu = new JMenu(title);
        this.Current.add(subMenu);
        this.Current = subMenu;
    }

    public void createLastSubMenuItem(String title, final int action) {
        JMenuItem menuItem = new JMenuItem(title);
        this.Current.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.runUserMenuAction(action);
            }
        });
        int fontSize = 13;
        if (this.mainMenuBar.getComponentCount() > 15) {
            fontSize = 10;
            if (this.mainMenuBar.getComponentCount() > 20) {
                fontSize = 8;
            }
            if (this.mainMenuBar.getComponentCount() > 30) {
                fontSize = 6;
            }
        }
        for (Component component : this.mainMenuBar.getComponents()) {
            Font f = new Font("Tahoma", 0, fontSize);
            component.setFont(f);
        }
    }

    public void createButton(String title, int id) {
        final int action = id;
        JMenu button = new JMenu(title);
        button.setToolTipText(title);
        this.mainMenuBar.add(button);
        int fontSize = 13;
        if (this.mainMenuBar.getComponentCount() > 20) {
            fontSize = 10;
            if (this.mainMenuBar.getComponentCount() > 25) {
                fontSize = 8;
            }
            if (this.mainMenuBar.getComponentCount() > 30) {
                fontSize = 6;
            }
        }
        for (Component component : this.mainMenuBar.getComponents()) {
            Font f = new Font("Tahoma", 0, fontSize);
            component.setFont(f);
        }
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainWindow.this.runUserMenuAction(action);
            }
        });
    }

    public void buildRecursiveMenu(Component button, Boolean flag) {
    }

    public void makeCurrent() {
        try {
            this.gLJPanel1.getContext().makeCurrent();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String createInputBox(String promptString, String initialString) {
        String response;
        if (promptString.isEmpty()) {
            promptString = "Please provide data";
        }
        if ((response = (String)JOptionPane.showInputDialog(this, null, promptString, -1, null, null, initialString)) != null) {
            return response;
        }
        return initialString;
    }

    public void reInitialiseSwords() {
        this.graphId = -1;
        this.listModel.clear();
        this.macroTitleTextField.setText("University of Bath - Constraint Modeller");
        this.mainMacroPath = null;
        if (!this.graphWindowList.isEmpty()) {
            Enumeration e = this.graphWindowList.keys();
            while (e.hasMoreElements()) {
                GraphWindow tempGraph = (GraphWindow)this.graphWindowList.get(e.nextElement());
                tempGraph.dispose();
            }
            this.graphWindowList.clear();
        }
        this.runCMCommand("init");
        this.runCMCommand("graphics");
        this.removeJavaUserMenu();
        for (Component component : this.mainMenuBar.getComponents()) {
            Font f = new Font("Tahoma", 0, 13);
            component.setFont(f);
        }
    }

    public void destroyGraphs() {
        if (!this.graphWindowList.isEmpty()) {
            Enumeration e = this.graphWindowList.keys();
            while (e.hasMoreElements()) {
                GraphWindow tempGraph = (GraphWindow)this.graphWindowList.get(e.nextElement());
                tempGraph.dispose();
            }
            this.graphWindowList.clear();
            for (Component component : this.mainMenuBar.getComponents()) {
                Font f = new Font("Tahoma", 0, 13);
                component.setFont(f);
            }
        }
    }

    public void swapBuffers() {
        this.gLJPanel1.swapBuffers();
    }

    public int getGLPanelWidth() {
        return this.gLJPanel1.getWidth();
    }

    public int getGLPanelHeight() {
        return this.gLJPanel1.getHeight();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainWindow().setVisible(true);
            }
        });
    }

    public void printOnConsole(String mes) {
        if (this.listModel.getSize() >= 20) {
            this.listModel.removeRange(this.listModel.size() - 6, this.listModel.size() - 1);
        }
        try {
            this.listModel.add(0, mes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printOnConsole(Integer mes) {
        try {
            this.listModel.add(0, mes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void enableGraphicsWindow() {
    }

    public String returnStartupFilesDir() {
        return this.startUpFilesDir;
    }

    public int createGraphWindow() {
        ++this.graphId;
        this.graph = new GraphWindow(this, this.graphId);
        try {
            this.graphWindowList.put(this.graphId, this.graph);
        }
        catch (Exception e) {
            String string = e.getMessage();
        }
        this.graph.setVisible(true);
        return this.graphId;
    }

    public void swapGraphBuffer(int id) {
        try {
            this.graph = (GraphWindow)this.graphWindowList.get(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.graph.swapBuffers();
    }

    public void makeGraphCurrent(int id) {
        try {
            this.graph = (GraphWindow)this.graphWindowList.get(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.graph.makeCurrent();
    }

    public int getGraphGLPanelWidth(int id) {
        try {
            this.graph = (GraphWindow)this.graphWindowList.get(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.graph.getGraphPanelWidth();
    }

    public int getGraphGLPanelHeight(int id) {
        try {
            this.graph = (GraphWindow)this.graphWindowList.get(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.graph.getGraphPanelHeight();
    }

    public String getVersionInfo() {
        return "Version: " + this.applicationVer;
    }

    public String getBuildDateInfo() {
        return this.applicationBuildDate;
    }

    public void changeMacroTitle(String title) {
        if (title.isEmpty()) {
            // empty if block
        }
        this.macroTitleTextField.setText(title);
    }

    private void openMainMacro() {
        block6: {
            File tempFile;
            if (this.mainMacroPath != null && (tempFile = new File(this.mainMacroPath)).exists()) {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        if (desktop.isSupported(Desktop.Action.OPEN)) {
                            desktop.open(tempFile);
                            break block6;
                        }
                        JOptionPane.showMessageDialog(null, "File editing could not be perfomed on this machine!!", "Not supported!!", 0);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(null, e.getMessage(), "Exception occured!!", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "File editing could not be perfomed on this machine!!", "Not supported!!", 0);
                }
            }
        }
    }

    public native void startCM(String var1);

    public native void javaMousePressed(int var1, int var2, int var3);

    public native void javaMouseMoved(int var1, int var2, int var3);

    public native void javaMouseReleased(int var1);

    public native void javaWheelMoved(int var1);

    public native void runCMCommand(String var1) throws IllegalArgumentException;

    public native void runUserMenuAction(int var1);

    public native String handleCommandCM(String var1) throws IllegalArgumentException;

    public native void shutDownInterface();

    public native void SetSwordsPathFileFlag(int var1);

    public native void setupViewportForGLCanvas();

    public native void setupGraphViewport(int var1);

    static {
        System.loadLibrary("libCMDLL");
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }
}

