/*
 * Decompiled with CFR 0.152.
 */
package javafrontend;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javafrontend.GLRenderer;
import javafrontend.MainWindow;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLJPanel;
import javax.swing.GroupLayout;
import javax.swing.JFrame;

public class GraphWindow
extends JFrame {
    private GLJPanel gLGraphJPanel;
    private int Id;
    private MainWindow parent;
    private GLRenderer myRenderer;

    public GraphWindow() {
        this.initComponents();
    }

    public GraphWindow(MainWindow parentIn, int id) {
        this.parent = parentIn;
        this.Id = id;
        this.initComponents();
        Toolkit toolkit = this.getToolkit();
        ClassLoader cl = this.getClass().getClassLoader();
        Image icon = toolkit.createImage(cl.getResource("icon.png"));
        this.setIconImage(icon);
        this.gLGraphJPanel.setAutoSwapBufferMode(true);
        this.gLGraphJPanel.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent evt) {
                GraphWindow.this.parent.setupGraphViewport(GraphWindow.this.Id);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private void initComponents() {
        this.gLGraphJPanel = new GLJPanel(this.createGLCapabilites());
        this.setDefaultCloseOperation(2);
        this.setTitle("Graph window");
        this.setMinimumSize(new Dimension(435, 436));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GraphWindow.this.formWindowClosing(evt);
            }
        });
        this.gLGraphJPanel.setMinimumSize(new Dimension(425, 425));
        this.gLGraphJPanel.setPreferredSize(new Dimension(425, 425));
        this.gLGraphJPanel.setRealized(true);
        GroupLayout gLGraphJPanelLayout = new GroupLayout((Container)this.gLGraphJPanel);
        this.gLGraphJPanel.setLayout((LayoutManager)gLGraphJPanelLayout);
        gLGraphJPanelLayout.setHorizontalGroup(gLGraphJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 425, Short.MAX_VALUE));
        gLGraphJPanelLayout.setVerticalGroup(gLGraphJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 425, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.gLGraphJPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.gLGraphJPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.reportGraphClosure(this.Id);
        this.parent.graphWindowList.remove(this.Id);
    }

    private GLCapabilities createGLCapabilites() {
        GLCapabilities capabilities = new GLCapabilities();
        capabilities.setHardwareAccelerated(true);
        return capabilities;
    }

    public void makeCurrent() {
        try {
            this.gLGraphJPanel.getContext().makeCurrent();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void swapBuffers() {
        this.gLGraphJPanel.display();
    }

    public int getGraphPanelWidth() {
        return this.gLGraphJPanel.getWidth();
    }

    public int getGraphPanelHeight() {
        return this.gLGraphJPanel.getHeight();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new GraphWindow().setVisible(true);
            }
        });
    }

    private native void reportGraphClosure(int var1);
}

