/*
 * Decompiled with CFR 0.152.
 */
package javafrontend;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class AboutFrame
extends JFrame {
    private JLabel cmLabel;
    private JLabel splashLabel;
    private JLabel versionLabel;
    private JLabel websiteLabel;

    public AboutFrame(String versionNumber) throws URISyntaxException {
        this.initComponents();
        Toolkit toolkit = this.getToolkit();
        ClassLoader cl = this.getClass().getClassLoader();
        Image icon = toolkit.createImage(cl.getResource("icon.png"));
        this.setIconImage(icon);
        this.versionLabel.setText("Version: " + versionNumber);
        final URI uri = new URI("http://www.constraintmodelling.com/");
        this.websiteLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AboutFrame.open(uri);
            }
        });
    }

    private static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.splashLabel = new JLabel();
        this.websiteLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.cmLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Constraint Modeller Web Interface");
        this.setResizable(false);
        this.splashLabel.setIcon(new ImageIcon(this.getClass().getResource("/splash.PNG")));
        this.websiteLabel.setFont(new Font("Tahoma", 0, 12));
        this.websiteLabel.setForeground(new Color(0, 51, 255));
        this.websiteLabel.setText("<HTML><U>http://www.constraintmodelling.com/</U></HTML>");
        this.websiteLabel.setCursor(new Cursor(12));
        this.versionLabel.setFont(new Font("Tahoma", 0, 18));
        this.versionLabel.setText("Version: 1.0");
        this.cmLabel.setFont(new Font("Tahoma", 0, 18));
        this.cmLabel.setText("Constraint Modeller Web Interface -");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splashLabel, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.websiteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 501, -2)).addGroup(layout.createSequentialGroup().addComponent(this.cmLabel).addGap(18, 18, 18).addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 324, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmLabel).addComponent(this.versionLabel)).addGap(18, 18, 18).addComponent(this.websiteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.splashLabel, -2, 412, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    new AboutFrame("1.0").setVisible(true);
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(AboutFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }
}

