/*
 * Decompiled with CFR 0.152.
 */
package javafrontend;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class RectangleBorder
extends AbstractBorder {
    protected Insets thickness;
    protected Color lineColor;
    protected Insets gap;

    public RectangleBorder(Color color) {
        this(color, new Insets(1, 1, 1, 1));
    }

    public RectangleBorder(Color color, Insets thickness) {
        this(color, thickness, thickness);
    }

    public RectangleBorder(Color color, Insets thickness, Insets gap) {
        this.lineColor = color;
        this.thickness = thickness;
        this.gap = gap;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int i;
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        for (i = 0; i < this.thickness.top; ++i) {
            g.drawLine(x, y + i, x + width, y + i);
        }
        for (i = 0; i < this.thickness.bottom; ++i) {
            g.drawLine(x, y + height - i - 1, x + width, y + height - i - 1);
        }
        for (i = 0; i < this.thickness.right; ++i) {
            g.drawLine(x + width - i - 1, y, x + width - i - 1, y + height);
        }
        for (i = 0; i < this.thickness.left; ++i) {
            g.drawLine(x + i, y, x + i, y + height);
        }
        g.setColor(oldColor);
    }

    public Insets getBorderInsets(Component c) {
        return this.gap;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = this.gap.left;
        insets.top = this.gap.top;
        insets.right = this.gap.right;
        insets.bottom = this.gap.bottom;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Insets getThickness() {
        return this.thickness;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public Insets getGap() {
        return this.gap;
    }
}

