/*
 * Decompiled with CFR 0.152.
 */
package javafrontend;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WriteFiles {
    public static void writeToFile(String fileName, InputStream iStream) throws IOException {
        WriteFiles.writeToFile(fileName, iStream, false);
    }

    public static void writeToFile(String fileName, InputStream iStream, boolean createDir) throws IOException {
        String me = "FileUtils.WriteToFile";
        if (fileName == null) {
            throw new IOException(me + ": filename is null");
        }
        if (iStream == null) {
            throw new IOException(me + ": InputStream is null");
        }
        File theFile = new File(fileName);
        if (theFile.exists()) {
            String msg;
            String string = theFile.isDirectory() ? "directory" : (msg = !theFile.canWrite() ? "not writable" : null);
            if (msg != null) {
                throw new IOException(me + ": file '" + fileName + "' is " + msg);
            }
        }
        if (createDir && theFile.getParentFile() != null) {
            theFile.getParentFile().mkdirs();
        }
        BufferedOutputStream fOut = null;
        try {
            fOut = new BufferedOutputStream(new FileOutputStream(theFile));
            byte[] buffer = new byte[32768];
            int bytesRead = 0;
            while ((bytesRead = iStream.read(buffer)) != -1) {
                fOut.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            try {
                throw new IOException(me + " failed, got: " + e.toString());
            }
            catch (Throwable throwable) {
                WriteFiles.close(iStream, fOut);
                throw throwable;
            }
        }
        WriteFiles.close(iStream, fOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void close(InputStream iStream, OutputStream oStream) throws IOException {
        try {
            if (iStream != null) {
                iStream.close();
            }
        }
        finally {
            if (oStream != null) {
                oStream.close();
            }
        }
    }
}

