/***************************************************************************
 * The Robust Colour Morphological Gradient (RCMG) for edge detection      *
 * in multichannel images                                                  *
 *                                                                         *
 * Adrian N. Evans                                                         *
 * University of Bath                                                      *
 * July 2007                                                               *
 * Copyright 2005-2007.  All rights reserved.                              *
 *                                                                         *
 * The RCMG find the median centered difference for a given window size    *
 * by rejecting the s pairs of pixels that are furthest apart. For full    *
 * details of its operation see A.N. Evans and X.U. Liu, A Morphological   *
 * Gradient Approach to Color Edge Detection, IEEE Transactions on Image   *
 * Processing, 15(6), pp. 1454-1463, June 2006.                            *
 *																		   *
 * This implementation uses the L2 norm                                    *
 *																		   *
 ***************************************************************************/

void rcmg(double *img, int rows, int cols, int channels, int mask, int s, bool direction, double *out_m, double *out_dir);
void l2norms(double **window, double **dists, double *max_dists, int *locations, int m2, int chans);
void updatel2norms(double **window, double **dists, double *max_dists, int *locations, int m2, int mask, int chans);
double find_dir(int v1, int v2, int mask);