#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "arraytrace.h"
#include "kerr.h"
#include "nrutil.h"
#include "raytrace.h"
#include "an_math.h"

int main(int argc, char *argv[])
{
  int res, Mres;
  double ipmax, a, mu_o;
  double ***x, ***k;
  int **hit;
  int **hit2;
  double **g, **emcos, **M;
  int i, j, l;
  
  res = 20; 
  Mres = res-2;
  ipmax = 10.0;
  a = 0.998;
  mu_o = 0.7;
  
  x = malloc(sizeof(double**)*(res));
  k = malloc(sizeof(double**)*(res));
  hit = malloc(sizeof(int*)*(res));
  for(i=0; i< res; i++)
  {
     x[i] = malloc(sizeof(double*)*(res));
     k[i] = malloc(sizeof(double*)*(res));
     hit[i] = malloc(sizeof(int)*(res));
     for(j=0; j< res; j++)
     {
        x[i][j] = init_4v();
        k[i][j] = init_4v();
      }
  }
  
  
  g = malloc(sizeof(double*)*(res-2));
  emcos = malloc(sizeof(double*)*(res-2));
  M = malloc(sizeof(double*)*(res-2));
  for(i=0; i < Mres; i++)
  {
     g[i] = malloc(sizeof(double)*(res-2));
     emcos[i] = malloc(sizeof(double)*(res-2));
     M[i] = malloc(sizeof(double)*(res-2));
  }
  
  
  Calc_rtr(ipmax, res, a, mu_o, x, k, hit);
  Calc_ImageArrays(res, a, mu_o, x, k, hit, g, emcos, M);

  fprintf(stdout, "res = %d, Mres = %d, ipmax = %g, a = %g, mu_o = %g\n", res, Mres, ipmax, a, mu_o);

  for(i=0; i<res;i++)
     for(j=0; j<res; j++)
     {
        fprintf(stdout, "x[%d][%d] = ", i, j);
        for(l=0; l<4; l++)
	   fprintf(stdout, "%g ", x[i][j][l]);
 
        fprintf(stdout, "\n");
        fprintf(stdout, "k[%d][%d] = ", i, j);
        for(l=0; l<4; l++)
	   fprintf(stdout, "%g ", k[i][j][l]);
        fprintf(stdout, "\n");
     }
    
  for(i=0; i<Mres; i++)
  {
     fprintf(stdout, "g[%d] = ", i);
     for(j=0; j<Mres; j++)
        fprintf(stdout, "%g ", g[i][j]);
     fprintf(stdout, "\n");
     fprintf(stdout, "emcos[%d] = ", i);
     for(j=0; j<Mres; j++)
        fprintf(stdout, "%g ", emcos[i][j]);
     fprintf(stdout, "\n");
     fprintf(stdout, "M[%d] = ", i);
     for(j=0; j<Mres; j++)
        fprintf(stdout, "%g ", M[i][j]);
     fprintf(stdout, "\n");
  }

  for(i=0;i<res;i++)
  {
     for(j=0; j<res;j++)
     {
        free(x[i][j]);
        free(k[i][j]);
     }
     free(x[i]);
     free(k[i]);
  }
  
  for(i=0; i<res-2; i++)
  {
     free(g[i]);
     free(emcos[i]);
     free(M[i]);
  }
  free(x);
  free(k);
  free(g);
  free(emcos);
  free(M);

  return 0;
}
