#include <stdlib.h>
#include <stdio.h>
#include "nrutil.h"
#include "discread.h"
#include "nrinterp.h"
#include <string.h>

int main(int argc, char *argv[])
{
  int kount, i, count;
  double m, p, cs2, omega_r, omega_i;
  double *xp, *dhr, *dhi, *idur, *idui;

  char infilename[100];
  char outfilename[100];

  FILE *outfile;

  if (argc<3)
  {
     fprintf(stdout, "usage: %s, <infilename.perturb> <outfilename.dat> \n\
     Outputs outfilename.dat files\n", argv[0]);
     return 1;
  }
  
  strcpy(infilename, argv[1]);
  strcpy(outfilename, argv[2]);

  outfile = fopen(outfilename, "w");


  count = Input_perturb(infilename, &m, &p, &cs2, &omega_r, &omega_i, &kount, 
                        &xp, &dhr, &dhi, &idur, &idui);

  fprintf(stdout, "Read %d bytes from %s\n", count, infilename);

  fprintf(stdout, "m = %g, p = %g, cs2 = %g, omega_r = %g, omega_i = %g, \
          kount= %d\n", m, p, cs2, omega_r, omega_i, kount);

  for(i=1; i<kount; i++)
     fprintf(outfile, "%20.20E %20.20E %20.20E %20.20E %20.20E\n", 
             xp[i], dhr[i], dhi[i], idur[i], idui[i]);

  fclose(outfile);

  fprintf(stdout, "wrote %s\n", outfilename);

  return 0;
}
