import math
import numpy as np
from mpl_toolkits.mplot3d import Axes3D
from matplotlib import pylab as plt
import gen_rtr
import raytrace



def one_ray(alpha, beta):
   ipmax = 30;
   a = .01
   mu_o = .5
   res = 20
   xtemp = raytrace.init_4v()
   ktemp = raytrace.init_4v()

   ll = gen_rtr.llambda(alpha, beta, a, mu_o)
   q2 = gen_rtr.qsquared(alpha, beta, a, mu_o)

   hit = raytrace.raytrace(ll, q2, a, mu_o, alpha, beta, 0.0, xtemp, ktemp)
   return [raytrace.getx(xtemp, 0),1/raytrace.getx(xtemp, 1),raytrace.getx(xtemp, 2),\
        raytrace.getx(xtemp, 3)]
   


f = open("geokerr_code/abgrid.out", "r")
out = open("outputs/rtphidiff.out", "w")
first = f.readline()

lines = []
for line in f:
   lines.append(line.split())


index = np.arange(0, len(lines), 2)

alphas = [lines[0][0]]
betas = [lines[0][1]]

for m in index:
   if lines[m][0] not in alphas:
      alphas.append(lines[m][0])
   if lines[m][1] not in betas:  
      betas.append(lines[m][1])

rdiff = np.ndarray(shape = (150,150), dtype=float)
phidiff = []
dtdiff = []
t1 = float(lines[1][2])
t2 = one_ray(float(lines[0][0]), -float(lines[0][1]))[0]
err = []
j = 0
ii=0
for i in index:
   alpha = float(lines[i][0])
   beta = float(lines[i][1])
   #alphas[] = alpha
   #betas[] = beta
   r1 =float(lines[i+1][0])
   dt1 =float(lines[i+1][2])-t1
   phi1 =float(lines[i+1][3])
   x = one_ray(alpha,beta)
   r2 =(x[1])
   dt2 =(x[0])-t2
   phi2 =(x[3])
   temp = phi1- phi2
   rdiff[ii][j] = math.log(math.fabs(r1-r2))
   dtdiff.append(dt1-dt2)
   phidiff.append(phi1-phi2)
   j += 1
   if j == 150:
      j = 0;
      ii += 1;
   #if i%100 == 0:
   	#out.write("%f %f %f %f %f\n" %(alpha, beta, r1-r2, dt1-dt2, phi1-phi2))

out.close()
f.close()
x = np.array(betas)
y = np.array(alphas)

#plot = plt.imshow(rdiff)
#X,Y = np.meshgrid(x,y)
#cbar = plt.colorbar(plot)
#fig = plt.figure()
#ax = Axes3D(fig)
#ax.plot_surface(X, Y, rdiff)

plt.hist(dtdiff)
plt.show()

