import numpy as np 
import math
from scipy import integrate

# Defining the Parameters
a = 0.01  # black hole spin
h = 0.01  # relative scale height h = H/r is constant
Gamma = 5.0/3.0 # Adiabatic index for gas pressure dominated, 4/3 for radiation
                # pressure dominated
Vo = 1 # we scale the solution by this value
m = 1  # the azimuthal wave number
j = 1  # the vertical wave number (# of nodes inthe vertical direction)
theta_i = math.pi/2.0 -0.00001 # paramerized initial condition at r = risco
n = 0 # number of radal nodes


def V_y(y):
   ######### need to change constant later
   constant = 1
   return constant*y

def Omega(r, a):
   return 1.0/(r**(1.5) + a)

def Omega_perp(r, a):
   temp = (1 - 4.0*a/(r**1.5) + 3.0*a**2.0/(r**2))**.5
   return Omega(r,a) * temp

def kappa(r, a):
   temp = (1 - 6.0/r + 8.0*a/(r**1.5) -3.0*a**2/(r**2))**.5
   return Omega(r,a) * temp

def ksquared(r,a):
   return Omega(r,a)*(1 - 6.0/r + 8.0*a/(r**1.5) -3.0*a**2/(r**2))

def omega_til(w, m, r, a):
   return w - m*Omega(r,a)

def Beta(r, a):
   num = r**1.5 + a
   denom = r**.75*(r**1.5 - 3.0*r**.5+2.0*a)**.5
   return num/denom

def grr(r, a):
   return r**2/(r**2 -2.0*r+a**2)

def c_s(r, a, Gamma, h):
   return Gamma**.5*h*r*Beta(r,a)*Omega_perp(r,a)

def dtao(r, a, w, m):
   return omega_til(w, m, r, a)**2 - ksquared(r, a)

def dPhi(r, a, w, m):
   return Q_func(r,a)**.5 * dtao(r, a, w, m)

def Phi(risco, r_c, a, w, m):
   return integrate.quad(dPhi, risco, r_c, (a, w, m)) 

def xi_l(gamma):
   return 3*gamma -1

def epsilon(r, a, w, m):
   num = w - m*(Omega(r,a) - Omega_perp(r,a))
   denom = m*Omega*perp
   return num/denom

def alpha_squared(beta, g_rr, c_s):
   return beta * g_rr / c_s**2
##### Not finished
def Q_func(r, a, w, m, gamma):#, xi, eps, alpha, w, kappa):
   xi = xi_l(gamma)
   eps = epsilon(r, a, w, m)
   num = xi*eps*alpha**2
   denom = w**2 - kappa**2
   return num / denom

def Phi(tao, xi, eps, alpha, w, kappa):
   result = integrate.quad(Q_func**(0.5), 0, tao, (xi, eps, alpha, w, kappa)) 
   return result[0]


def interpolate(point, x, y):
   
   if point < min(x) or point > max(x):
      return 0

   for i in range(len(x)):
      if x[i] == point:
         return y[i]
      if x[i] > point:
         next_x = x[i]
         next_y = y[i]
         interp = (point - last_x)*((next_y - last_y)/(next_x-last_x)) + last_y

         return interp
      last_x = x[i]
      last_y = y[i]
      
vrp_infile = open('VrPrime_cmode0.01_h0.01_n0_thetai1.57079.dat', 'r')
vr_infile = open('Vr_cmode0.01_h0.01_n0_thetai1.57079.dat', 'r')
r = []
vr = []
vrp = []

for line in vr_infile:
   r.append(float(line.split()[0]))
   vr.append(float(line.split()[1]))
for line in vrp_infile:
   vrp.append(float(line.split()[1]))

np.array(r)
np.array(vr)
np.array(vrp)





