import numpy as np
import math
import gen_rtr as gen
import cPickle as pickle
import colorsys
import pylab as plt

plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['font.family'] = "serif"
plt.rcParams['font.serif'] = "times"
plt.rcParams['axes.unicode_minus'] = False
plt.rcParams['font.size'] = 8

plt.rcParams['xtick.major.size'] = 2
plt.rcParams['ytick.major.size'] = 2


def get_params(filename):
   infile = open(filename, 'r')
   lines = []
   for line in infile:
      lines.append(line.split())
   risco = float(lines[0][2])
   rivr = float(lines[1][2])
   rilr = float(lines[2][2])
   omega = float(lines[3][2])
   return risco, rivr, rilr, omega

def get_raytrace(filename):
      
   # Retreiving data from cPickle file
   infile = open(filename, 'r')

   res = pickle.load(infile) 
   ipmax = pickle.load(infile)
   a = pickle.load(infile)
   mu_o = pickle.load(infile)
   x = pickle.load(infile)
   kvec = pickle.load(infile)
   hit = pickle.load(infile) 
   g = pickle.load(infile)
   emcos = pickle.load(infile)

   infile.close()  

   return res, ipmax, a, mu_o, x, kvec, hit, g, emcos

def get_xi(xi_file, xip_file, x):
   xip_infile = open(xip_file, 'r')
   xi_infile = open(xi_file, 'r')
   r_z = []
   xi_z = []
   xi_zp = []

   for line in xi_infile:
      r_z.append(float(line.split()[0]))
      xi_z.append(float(line.split()[1]))
   for line in xip_infile:
      xi_zp.append(float(line.split()[1]))

   np.array(r_z)
   np.array(xi_z)
   np.array(xi_zp)

   xiz_interp = np.ndarray(shape = (res,res), dtype = float)
   xizp_interp = np.ndarray(shape = (res,res), dtype = float)
   for i in range(res):
      for j in range(res):
         xiz_interp[i][j] = interpolate(x[i][j][1], r_z, xi_z)
         xizp_interp[i][j] = interpolate(x[i][j][1], r_z, xi_zp)
   return xiz_interp, xizp_interp, r_z[-1], xi_z[-1], xi_zp[-1]


def interpolate(point, x, y):
   
   if point < min(x) or point > max(x):
      return 0

   for i in range(len(x)):
      if x[i] == point:
         return y[i]
      if x[i] > point:
         next_x = x[i]
         next_y = y[i]
         interp = (point - last_x)*((next_y - last_y)/(next_x-last_x)) + last_y

         return interp
      last_x = x[i]
      last_y = y[i]

def n_t(xi_z, x, m, w, ksi_o, delt):
   t = x[0]
   r = x[1]
   phi = x[3]
   return -w* ksi_o * xi_z * math.sin(m*phi - w*t + delt)

def n_r(xi_zp, x, m, w, ksi_o, delt): 
   t = x[0]
   r = x[1]
   phi = x[3]
   return xi_zp * ksi_o *math.cos(m*phi - w*t + delt)

def n_theta(x):
   # returns -r
   return -x[1]

def n_phi(xi_z,x, m, w, ksi_o, delt):
   t = x[0]
   r = x[1]
   phi = x[3]
   return m * xi_z *ksi_o * math.sin(m*phi - w*t + delt)

def nvec_tilt(xi_z, xi_zp, u, a, x, m, w, ksi_o, delt):
   t = x[0]
   r = x[1]
   phi = x[3]
   n0 = ksi_o * w * r * math.sin(m*phi - w *t + delt)
   n1 = ksi_o * math.cos(m*phi - w*t + delt)
   n2 = -r
   n3 = -ksi_o * m *r * math.cos(m*phi - w *t + delt)
   n = np.array([n0, n1, n2, n3], np.float32)
   temp1 = np.dot(u, n)
   gdown = gen.g_down(x, a)
   temp2 = gen.matdot(gdown, u)
   return n + np.dot(temp2, temp1)

def nvec(xi_z, xi_zp, u, a, x, m, w, ksi_o, delt):
   n0 = n_t(xi_z, x, m, w, ksi_o, delt)
   n1 = n_r(xi_zp,x, m, w, ksi_o,delt)
   n2 = n_theta(x)
   n3 = n_phi(xi_z, x, m, w, ksi_o, delt)
   n = np.array([n0, n1, n2, n3], np.float32)
   temp1 = np.dot(u, n)
   gdown = gen.g_down(x, a)
   temp2 = gen.matdot(gdown, u)
   return n + np.dot(temp2, temp1)

def g_up(x, a):
   g = np.array([[0,0,0,0],[0,0,0,0],[0,0,0,0],[0,0,0,0]], np.float32)
   
   r = x[1]
   mu = math.cos(x[2])
   mu2 = mu**2
   Sigma = gen.kerr_Sigma(r, mu, a)
   Delta = gen.kerr_Delta(r, a)
   A = gen.kerr_A(r, mu, a)

   g[0][0] = -A/(Sigma*Delta)
   g[1][1] = Delta/Sigma
   g[2][2] = 1.0/Sigma
   g[3][3] = Sigma/(A*(1.0-mu2))
   g[3][3] -= (4.0*r*r*a*a)/(A*Sigma*Delta)
   g[0][3] = -2.0*r*a/(Sigma*Delta)
   g[3][0] = g[0][3]

   return g

def norm_n(nvec, x, a):
   g = g_up(x, a)

   temp1 = gen.matdot(g, nvec)
   temp2 = np.dot(temp1, nvec)
   return nvec / math.sqrt(temp2)
 
def Calc_mu_em(n, kvec, u_em):
   num = np.dot(kvec, n)
   denom = np.dot(kvec, u_em)
   return num/ denom  

def f(mu_em):
   # limb darkening
   return 1 + 2.06*mu_em
 
def f2(mu_em): 
   # limb brightening
   if mu_em < 0:
     return 0
   return math.log(1 + 1/mu_em)

def simple_I(ptype, a, x, kvec, g, hit, p, ksi_o):
   I = np.ndarray(shape=(res,res), dtype = float)
   for i in range(res):
      for j in range(res):
         r = x[i][j][1]
         if r > risco and r < rout and hit[i][j] == 1:
            # if r > perturbation limit, smoothes out the transition into decay
            u_em = gen.Kepler4v(a, x[i][j])
            nvect = np.array([0, 0, -r, 0])
            n = norm_n(nvect, x[i][j], a)
            mu_em = Calc_mu_em(n, kvec[i][j], u_em)
            if ptype == 1:
               I[i][j] = ksi_o*g[i][j]**3 *r**(-p)*f(mu_em)
            elif ptype == 2:
               I[i][j] = ksi_o*g[i][j]**3 *r**(-p)*f2(mu_em)            
         else:
            I[i][j] = 0 
   return I
   
def Calc_I(ptype,xi_z, xi_zp, a, x, kvec, g, hit, p, m, w, ksi_o,delt, tilt):
   ''' Generates the intensity matrix without any perturbations '''
   # initializing array
   I = np.ndarray(shape=(res,res), dtype=float)
   # creating matrix of radii
   for i in range(res):
      for j in range(res):
         r = x[i][j][1]
         if r > risco and r < rout and hit[i][j] == 1:
            # if r > perturbation limit, smoothes out the transition into decay
            if r > dout:
               xiz_new = xiz_dout*math.exp((xizp_dout/xiz_dout)*(r - dout))
               xizp_new = xizp_dout*math.exp((xizp_dout/xiz_dout)*(r-dout))
            u_em = gen.Kepler4v(a, x[i][j])
            if tilt:
            	nvect = nvec_tilt(xi_z[i][j], xi_zp[i][j], u_em, a, x[i][j], m, w, .01, delt)
            else:
                nvect = nvec(xi_z[i][j], xi_zp[i][j], u_em, a, x[i][j], m, w, ksi_o, delt)
            n = norm_n(nvect, x[i][j], a)
            mu_em = Calc_mu_em(n, kvec[i][j], u_em)
            if ptype == 1:
               I[i][j] = g[i][j]**3 *r**(-p)*f(mu_em)
            elif ptype == 2:
               I[i][j] = g[i][j]**3 *r**(-p)*f2(mu_em)            
         else:
            I[i][j] = 0 
   return I

def scale_g(mat):
   '''Scales the matrix such that the range becomes 1'''
   mat_range = mat.max() - mat.min()
   return (1.0 / mat_range) * mat


def scale_I(mat):
   # initializing array 
   height = len(mat)
   width = len(mat[0])
   scaled_I = np.ndarray(shape=(height, width), dtype = float)

   # want to scale
   maximum = mat.max()
   scale = .95/maximum
   for i in range(height):
      for j in range(width):
         # return zero if inside the event horizon or outside the disk edge
         if mat[i][j] == 0:
            scaled_I[i][j] = 0
         else:
            scaled_I[i][j] = mat[i][j]*scale + 0.05

   return scaled_I


def bin_I(g, h, I, nbins):

   step = (g.max()-g.min())/nbins
   g_range = np.arange(g.min(), g.max(), step)
   # initializes the final array. 1-D, with length of len(g_range)
   spect = np.array(len(g_range)*[0], np.float32)

   for x in range(len(g_range) -1): 
      temp = 0
      for i in range(res):
         for j in range(res):
            if g[i][j] >= g_range[x] and g[i][j] < g_range[x+1]: 
               if h[i][j] == 1:
                  temp += I[i][j]
      spect[x] = temp
   return spect

def gen_simple_I(ptype, a, x, kvec, g, hit, p, ksi_o, nbins, outfile):
   I = simple_I(ptype, a, x, kvec, g, hit, p, ksi_o)
   spect = bin_I(g, hit, I, nbins)
   x_range = np.arange(g.min(), g.max(), (g.max()-g.min())/nbins)
   out = open(outfile, "wb")
   pickle.dump(spect, out)
   pickle.dump(g.max(), out)
   pickle.dump(x_range, out)
   out.close()
   
def plot_simple_I(in_file, outfile):
   infile = open(in_file, 'r')
   spect = pickle.load(infile)  
   gmax = 1.22
   x = pickle.load(infile)
   infile.close() 
    
   I = np.multiply(spect, 1.0/max(spect))
   plt.axes().set_aspect(.6)
   plt.plot(x, I)
   plt.xlabel("Redshift")
   plt.ylabel("Intensity")
   plt.xlim([0, 11.0*gmax/10.0])
   plt.ylim([0.0, I.max() + .1])
   plt.show()


def plot_I(g, h, I, nbins, outfile):
   spect = bin_I(g, h, I, nbins)
   x = np.arange(g.min(), g.max(), (g.max()-g.min())/nbins)

   plt.plot(x, spect)
   plt.xlim([0.0, 1.4])
  # plt.ylim([0.0, spect.max() + 2])
   plt.xlabel("Redshift")
   plt.ylabel("Intensity")
   plt.savefig(outfile, format='pdf')
     

def plot_image(x, g, I, p, outfile):   
   rgb = np.ndarray(shape=(res,res, 3), dtype=float)

   g_scaled = scale_g(g)
   I_scaled = scale_I(I)

   for i in range(res):
      for j in range(res):
         # -.6 + 1.3
         # -.65 + 2.3
         rgb[i][j] = colorsys.hls_to_rgb(-.6+1.3*g_scaled[i][j], \
                     I_scaled[i][j], 1)

   plt.xlabel("Beta")
   plt.ylabel("Alpha")
   plot = plt.imshow(rgb, extent=[-ipmax,ipmax,-ipmax,ipmax])

   # adding and modifying color bar on the side
   cbar = plt.colorbar(plot,ticks=[0, .5, 1])
   cbar.ax.set_yticklabels([g.min(), 0.61, 1.22])
   cbar.set_label(r'redshift')
   plt.savefig(outfile, format='pdf')

def gen_int(ptype, xi_z, xi_zp, a, x, kvec, g, hit, p, m, w, ksi_o, nbins, num, int_diff_file, tilt):
   phase = np.arange(0, 2.2, 2.0/num)
   intensity = []#np.array(len(phase)*[0.0], np.float32)
   n = 0 
   ave = np.array(50*[0.0], np.float32)
   np.array(ave)
     
   for i in range(len(phase)):
      I = Calc_I(ptype, xi_z, xi_zp, a, x, kvec, g, hit, p, m, w, ksi_o, phase[i]*2*math.pi, tilt)
      spect = bin_I(g, hit, I, nbins)
      ave += spect
      intensity.append(spect)
      print n
      n += 1
   intensity = np.array(intensity)
   for i in range(len(intensity)):
      intensity[i] -= ave/len(phase)
   pos_max = intensity.max()
   neg_max = math.fabs(intensity.min())
   if neg_max > pos_max:
      scale = 1.0/(neg_max)
   else:
      scale = 1.0/pos_max
   intensity = np.multiply(intensity, scale)

   outfile = open(int_diff_file, "wb")
   pickle.dump(intensity, outfile)
   pickle.dump(g.max(), outfile)
   outfile.close()


def plot_int(int_diff_file, output, colorbar):
   infile = open(int_diff_file, 'r')
   intensity = pickle.load(infile)  
   gmax =  round(1.11601912975, 2) #pickle.load(infile)
   infile.close()  
   spect = []
   xmax = 6.0 * gmax / 5.0
   for i in range(len(intensity)-1, -1,-1):
      spect.append(np.append(intensity[i],5*[0]))

   fig = plt.figure()
   ax1 = fig.add_subplot(1,1,1)
   plot = plt.imshow(spect, vmin = -1, vmax = 1)
   #plt.gray()
   #plt.xlabel('Redshift')
   plt.ylabel('Phase')
   ax1.set_xticks([0,.2*50/gmax, .4*50/gmax, .6*50/gmax,.8*50/gmax, \
                  50.0/gmax, 1.2*50/gmax])# 1.4*50/gmax])
   ax1.set_xticklabels([])
   ax1.set_yticks([0, 5, 10, 15, 20])
   xlabels = np.arange(0, 1.4, .2)
   #ax.set_xticklabels(xlabels)
   ax1.set_yticklabels([2.0, 1.5, 1.0, 0.5, 0.0])
   if colorbar == "cbar":
      cbar = plt.colorbar(plot, orientation = 'horizontal')
      cbar.set_label(r'Intensity (arbitrary scale)')  
   plt.savefig(output)
   plt.clf()
   #plt.show()
  
def plot_column(a, mu, ptype):
   tilted = []
   n0 = []
   n1 = []
   n2 = []  
 
   file1 = open('perturb/data/spect_a'+a+'_mu'+mu+'_'+ptype+'.dat', 'r')
   spec = pickle.load(file1)  
   gmax = pickle.load(file1)
   x = pickle.load(file1)
   file1.close()  

   file2 = open('perturb/data/tilt_a'+a+'_mu'+mu+'_'+ptype+'.dat', 'r')
   tilted_temp = pickle.load(file2)
   file2.close()

   file3 = open('perturb/data/int_diff_a'+a+'_mu'+mu+'_n0_h.01_'+ptype+'.dat', 'r')
   n0_temp = pickle.load(file3)
   file3.close()
  
   file4 = open('perturb/data/int_diff_a'+a+'_mu'+mu+'_n1_h.01_'+ptype+'.dat', 'r')
   n1_temp = pickle.load(file4)
   file4.close()

   file5 = open('perturb/data/int_diff_a'+a+'_mu'+mu+'_n2_h.01_'+ptype+'.dat', 'r')
   n2_temp = pickle.load(file5)
   file5.close()

   for i in range(len(tilted_temp)-1, -1,-1):
      tilted.append(np.append(tilted_temp[i],5*[0]))
      n0.append(np.append(n0_temp[i], 5*[0]))
      n1.append(np.append(n1_temp[i], 5*[0]))
      n2.append(np.append(n2_temp[i], 5*[0]))
  
   
   ax1 = plt.subplot(611)
   ax2 = plt.subplot(612)
   ax3 = plt.subplot(613)
   ax4 = plt.subplot(614)
   ax5 = plt.subplot(615)
   

   I = np.multiply(spec, 1.0/max(spec))
   if gmax > 1.3:
      xticks = [0,.2*50/gmax, .4*50/gmax, .6*50/gmax,.8*50/gmax, 50.0/gmax, \
                1.2*50/gmax, 1.4*50/gmax]
      xlabels = np.arange(0, 1.6, .2)
   else:
      xticks = [0,.2*50/gmax, .4*50/gmax, .6*50/gmax,.8*50/gmax, 50.0/gmax, 
                1.2*50/gmax]
      xlabels = np.arange(0, 1.4, .2)   
   if mu == '.1':
      ax1.set_aspect(.505)
   elif mu == '.5':
      ax1.set_aspect(.44)
   else:
      ax1.set_aspect(.40)
   plt1 = ax1.plot(x, I, color = 'black')
   ax1.set_ylabel("Intensity")
   ax1.set_xticklabels([])
   ax1.set_xlim([0, 13.0*gmax/12.0])
   ax1.set_ylim([0.0, I.max() + .1])

   ax2.imshow(tilted, vmin = -1, vmax = 1)
   ax2.set_ylabel('Phase')
   ax2.set_xticks(xticks)
   ax2.set_xticklabels([])
   ax2.set_yticks([0, 5, 10, 15, 20])
   ax2.set_yticklabels([2.0, 1.5, 1.0, 0.5, 0.0])

   plot3 = ax3.imshow(n0, vmin = -1, vmax = 1)
   ax3.set_ylabel('Phase')
   ax3.set_xticks(xticks)
   ax3.set_xticklabels([])
   ax3.set_yticks([0, 5, 10, 15, 20])
   ax3.set_yticklabels([2.0, 1.5, 1.0, 0.5, 0.0])

   ax4.imshow(n1, vmin = -1, vmax = 1)
   ax4.set_ylabel('Phase')
   ax4.set_xticks(xticks)
   ax4.set_xticklabels([])
   ax4.set_yticks([0, 5, 10, 15, 20])
   ax4.set_yticklabels([2.0, 1.5, 1.0, 0.5, 0.0])

   plot5 = ax5.imshow(n2, vmin = -1, vmax = 1)
   ax5.set_ylabel('Phase')
   ax5.set_xlabel('Redshift')
   ax5.set_xticks(xticks)
   ax5.set_xticklabels([])
   ax5.set_yticks([0, 5, 10, 15, 20])
   ax5.set_xticklabels(xlabels)
   ax5.set_yticklabels([2.0, 1.5, 1.0, 0.5, 0.0])

   #cbar = plt.colorbar(plot3, orientation = 'horizontal')
   #cbar.set_label(r'Intensity (arbitrary scale)')  
   outfile = 'perturb/stack_a'+a+'_mu'+mu+'_'+ptype+'.pdf'
   #plt.show()
   plt.savefig(outfile)
  

def gen_movie(ptype, xi_z, xi_zp, a, x, kvec, g, hit, nbins,p, m, w, ksi_o, num_pic):

   delt = np.arange(0, 2*math.pi, 2*math.pi/num_pic)
   n = 0
   for d in delt:
      outfile = "perturb/im"+str(ptype)+str(n)
      outfile2 = "perturb/int"+str(n)
      I = Calc_I(ptype, xi_z, xi_zp, a, x, kvec, g, hit, p, m, w, ksi_o, d)
      plot_image(x, g, I, p, outfile)
      plt.clf()
      #plot_I(g, hit, I, nbins, outfile2)
      #plt.clf()
      n += 1
      print n

p = 3
rout = 20
m = 1
ksi_o = .0005
nbins = 50
tilt = False

a = ".001"
n = 2

xip_file = 'Xiz_cmode0'+a+'_h0.01_n'+str(n)+'_thetai1.57079.dat'
xi_file = 'Xizprime_cmode0'+a+'_h0.01_n'+str(n)+'_thetai1.57079.dat'
param_file = 'parameters_cmode0'+a+'_h0.01_n'+str(n)+'_thetai1.57079.dat'

read_in_file1 = 'outputs/perturb_a0'+a+'_mu0.1.dat'
read_in_file5 = 'outputs/perturb_a0'+a+'_mu0.5ipm20.dat'
read_in_file7 = 'outputs/perturb_a0'+a+'_mu0.7.dat'
  
file11 = 'perturb/data/int_diff_a0'+a+'_mu0.1_n'+str(n)+'_h0.01_1.dat'
file12 = 'perturb/data/int_diff_a0'+a+'_mu0.1_n'+str(n)+'_h0.01_2.dat'
file51 = 'perturb/data/int_diff_a0'+a+'_mu0.5_n'+str(n)+'_h0.01_1.dat'
file52 = 'perturb/data/int_diff_a0'+a+'_mu0.5_n'+str(n)+'_h0.01_2.dat'
file71 = 'perturb/data/int_diff_a0'+a+'_mu0.7_n'+str(n)+'_h0.01_1.dat'
file72 = 'perturb/data/int_diff_a0'+a+'_mu0.7_n'+str(n)+'_h0.01_2.dat'

specfile11 = 'perturb/data/spect_a'+a+'_mu.1_1.dat'
specfile12 = 'perturb/data/spect_a'+a+'_mu.1_2.dat'
specfile51 = 'perturb/data/spect_a'+a+'_mu.5_1.dat'
specfile52 = 'perturb/data/spect_a'+a+'_mu.5_2.dat'
specfile71 = 'perturb/data/spect_a'+a+'_mu.7_1.dat'
specfile72 = 'perturb/data/spect_a'+a+'_mu.7_2.dat'

out11 = 'perturb/int_diff_a0'+a+'_mu0.1_n'+str(n)+'_h.01_1.pdf'
out12 = 'perturb/int_diff_a0'+a+'_mu0.1_n'+str(n)+'_h.01_2.pdf'
out51 = 'perturb/int_diff_a0'+a+'_mu0.5_n'+str(n)+'_h.01_1.pdf'
out52 = 'perturb/int_diff_a0'+a+'_mu0.5_n'+str(n)+'_h.01_2.pdf'
out71 = 'perturb/int_diff_a0'+a+'_mu0.7_n'+str(n)+'_h.01_1.pdf'
out72 = 'perturb/int_diff_a0'+a+'_mu0.7_n'+str(n)+'_h.01_2.pdf'

risco, rivr, rilr, w = get_params(param_file)
#w = 1.278192977167278 * 10**(-6)
#res, ipmax, a1, mu_o1, x1, kvec1, hit1, g1, emcos1 = get_raytrace(read_in_file1)
res, ipmax, a5, mu_o5, x5, kvec5, hit5, g5, emcos5 = get_raytrace(read_in_file5)
#res, ipmax, a7, mu_o7, x7, kvec7, hit7, g7, emcos7 = get_raytrace(read_in_file7)


#xiz_interp1, xizp_interp1, dout, xiz_dout, xizp_dout = get_xi(xi_file, xip_file, x1)
xiz_interp5, xizp_interp5, dout, xiz_dout, xizp_dout = get_xi(xi_file, xip_file, x5)
#xiz_interp7, xizp_interp7, dout, xiz_dout, xizp_dout = get_xi(xi_file, xip_file, x7)

#gen_simple_I(1, a1, x1, kvec1, g1, hit1, p, ksi_o, nbins, specfile11)
#gen_simple_I(2, a1, x1, kvec1, g1, hit1, p, ksi_o, nbins, specfile12)
#gen_simple_I(1, a5, x5, kvec5, g5, hit5, p, ksi_o, nbins, specfile51)
#gen_simple_I(2, a5, x5, kvec5, g5, hit5, p, ksi_o, nbins, specfile52)
#gen_simple_I(1, a7, x7, kvec7, g7, hit7, p, ksi_o, nbins, specfile71)
#gen_simple_I(2, a7, x7, kvec7, g7, hit7, p, ksi_o, nbins, specfile72)

#gen_int(1, xiz_interp1, xizp_interp1, a1, x1, kvec1, g1, hit1, p, m, w, ksi_o, nbins, 20, file11, tilt)
#gen_int(2, xiz_interp1, xizp_interp1, a1, x1, kvec1, g1, hit1, p, m, w, .001, nbins, 20, file12, tilt)

#gen_int(1, xiz_interp5, xizp_interp5, a5, x5, kvec5, g5, hit5, p, m, w, ksi_o, nbins, 20, file51, tilt)
#gen_int(2, xiz_interp5, xizp_interp5, a5, x5, kvec5, g5, hit5, p, m, w, .003, nbins, 20, file52, tilt)

#gen_int(1, xiz_interp7, xizp_interp7, a7, x7, kvec7, g7, hit7, p, m, w, ksi_o, nbins, 20, file71, tilt)
#gen_int(2, xiz_interp7, xizp_interp7, a7, x7, kvec7, g7, hit7, p, m, w, .003, nbins, 20, file72, tilt)

a = ['.001', '.01']
mu = ['.1', '.5', '.7']
ptype = ['1', '2']

#for aa in a:
 # for muu in mu:
  #   for p in ptype:
   #     plot_column(aa, muu, p)
	#plt.clf() 

#plot_column('.001', '.7', '1')
#plot_int(file11, out11, "none")
#plot_int(file12, out12, "none")
#plot_int(file51, out51, "none")
#plot_int(file52, out52, "none")
#plot_int(file71, out71, "cbar")
#plot_int(file72, out72, "cbar")

gen_movie(1, xiz_interp5, xizp_interp5, a5, x5, kvec5, g5, hit5, nbins,p, m, w, ksi_o, 4)

#plot_int("temp.dat", "perturb/temp.pdf")

#I = Calc_I(2, xiz_interp1, xizp_interp1, a1, x1, kvec1, g1, hit1, p, m, w, ksi_o, 0)
#I = Calc_I(1, xiz_interp5, xizp_interp5, a5, x5, kvec5, g5, hit5, p, m, w, ksi_o, 0)
#I = Calc_I(2, xiz_interp7, xizp_interp7, a7, x7, kvec7, g7, hit7, p, m, w, ksi_o, 0)

#I = simple_I(1, a5, x5, kvec5, g5, hit5, p, ksi_o)

#plot_image(x1, g1, I, p, "temp1")
#plot_image(x5, g5, I, p, "temp5")
#plot_image(x7, g7, I, p, "temp7")
#plt.clf()
#plot_I(g5, hit5, I, nbins, "temp2")
#plot_simple_I(specfile52, 'perturb/temp.pdf')


################
# Temp Note
# data run for a = 0.001 doesn't have gmax in pickle file
# gmax values: a      mu_o      gmax
#             .001     .1      1.403892636
#             .001     .5      1.224152565   
#             .001     .7      1.11601912975
###########
