#include <math.h>
#define NRANSI
#include "nrutil.h"

void locate(double xx[], unsigned long n, float x, unsigned long *j)
{
  unsigned long ju,jm,jl;
  int ascnd;

  jl=0;
  ju=n+1;
  ascnd=(xx[n] >= xx[1]);
  while (ju-jl > 1) 
  {
     jm=(ju+jl) >> 1;
     if (x >= xx[jm] == ascnd)
        jl=jm;
     else
        ju=jm;
  }
  if (x == xx[1]) *j=1;
  else if(x == xx[n]) *j=n-1;
  else *j=jl;
}


void polint2(double xa[], double ya[], int n, double x, double *y, double *dy)
{
  int i,m,ns=1;
  double den,dif,dift,ho,hp,w;
  double *c,*d;

  dif=fabs(x-xa[1]);
  c=vector(1,n);
  d=vector(1,n);
  for (i=1;i<=n;i++) 
  {
     if ((dift=fabs(x-xa[i])) < dif) 
     {
        ns=i;
        dif=dift;
     }
     c[i]=ya[i];
     d[i]=ya[i];
  }
  *y=ya[ns--];
  for (m=1;m<n;m++) 
  {
     for (i=1;i<=n-m;i++) 
     {
        ho=xa[i]-x;
        hp=xa[i+m]-x;
        w=c[i+1]-d[i];
         if ( (den=ho-hp) == 0.0) 
            nrerror("Error in routine polint");
         den=w/den;
         d[i]=hp*den;
         c[i]=ho*den;
     }
     *y += (*dy=(2*ns < (n-m) ? c[ns+1] : d[ns--]));
  }
  free_vector(d,1,n);
  free_vector(c,1,n);
}


#undef NRANSI
