/*
 * kerr   - dtsang@physics.cornell.edu                 14/06/04
 * Routines to calculate useful quantities in the kerr metric.
 * Assuming Boyer-Linquist coords
 *
 * To add: Christoffel symbols, Riemann tensor, covariant deriv..
 *         not necessary yet.
 */

/* 
 * double **g_init()
 * double g_down(double *x, double a, double **g)
 * double g_up(double *x, double a, double **g)
 *
 * Computes the metric (down) and inverse metric (up) as a function of 
 * the position 4-vector x^mu and the BH paramter a. 
 *
 * Outputs to the (assumed) pre-initialized g array (use g_init()). 
 * Boyer-Linquist coords 
 */
extern double **g_init();
extern void g_free(double** g);
extern void g_down(double *x, double a, double **g);
extern void g_up(double*x, double a, double **g);


/* double *init_4v()
 * 
 * Initializes a four-vector.
 */
extern double *init_4v(void);
 
/* 
 * double kerr_Sigma(double r, double mu, double a)
 * double kerr_Delta(double r, double mu, double a)
 * double kerr_A(double r, double mu, double a)
 *
 * Useful functions for calculating metric etc.
 */

extern double kerr_Sigma(double r, double mu, double a);
extern double kerr_Delta(double r, double mu, double a);
extern double kerr_A(double r, double mu, double a);
extern double Calc_risco(double a);
extern double kerr_ds(double *dx, double *x, double a);
extern void levi_civita(double *x, double a, double e[4][4][4][4]);
