#include <stdlib.h>
#include <stdio.h>
#include "nrutil.h"
#include "discread.h"
#include "nrinterp.h"
#include <string.h>

int main(int argc, char *argv[])
{
  int kount, i, count;
  double m, p, cs2, omega_r, omega_i;
  double *xp, *dhr, *dhi, *idur, *idui;
  double rval;
  double r[1000], y1[1000], y2[1000];
  double dy1[1000], dy2[1000];

  int k, j, polym;

  char infilename[100];
  char outfilename[100];

  FILE *outfile;

  polym = 4;

  if (argc<3)
  {
     fprintf(stdout, "usage: %s, <infilename.perturb> <outfilename.dat> \n\
             Outputs outfilename.dat files\n", argv[0]);
     return 1;
  }
  
  strcpy(infilename, argv[1]);
  strcpy(outfilename, argv[2]);

  outfile = fopen(outfilename, "w");


  count = Input_perturb(infilename, &m, &p, &cs2, &omega_r, &omega_i, &kount, 
                        &xp, &dhr, &dhi, &idur, &idui);

  fprintf(stdout, "Read %d bytes from %s\n", count, infilename);

  fprintf(stdout, "m = %g, p = %g, cs2 = %g, omega_r = %g, omega_i = %g, \
          kount= %d\n", m, p, cs2, omega_r, omega_i, kount);

  i = 0;
  for(rval = 6.001; rval < 30.0; rval += (30.0-6.0)/1000.0)
  {
     locate(xp, kount, rval, &j);
     r[i++] = rval;
     k = IMIN(IMAX(j-(polym-1)/2,1), kount+1-polym);
     polint2(&xp[k-1], &dhr[k-1], polym, rval, &y1[i], &dy1[i]);
  }

  i = 0;
  for(rval = 6.001; rval < 30.0; rval += (30.0-6.0)/1000.0)
  {
     locate(xp, kount, rval, &j);
     r[i++] = rval;
     k = IMIN(IMAX(j-(polym-1)/2,1), kount+1-polym);
     polint2(&xp[k-1], &dhi[k-1], polym, rval, &y2[i], &dy2[i]);
  }

  for(i = 0; i < 900; i++)
    fprintf(outfile, "%20.20E %20.20E %20.20E\n", r[i], y1[i], y2[i]);

  fprintf(stdout, "wrote %s\n", outfilename);
  fclose(outfile);

  return 0;
}
