#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "rtr.h"
#include "kerr.h"
#include "arraytrace.h"
#include "discread.h"
#include <string.h>
#include <complex.h>

int main(int argc, char *argv[])
{
  int res, Mres;
  double ipmax, a, mu_o;
  double ***x, ***k;
  int **hit;
  double **g, **emcos, **M;
  int i, j;
  int count;
  _Complex double Em;
  double dhr;
  double dhi;
  double idur;
  double idui;
  int hitval;
  
  double m, p, cs2, omega_r, omega_i;

  char outfilenameg[100];
  char outfilenamem[100];
  char outfilenamedh[100];
  char infilenamertr[100];
  char infilenamepert[100];
  char outfilenamehit[100];

  FILE *gfile, *Mfile, *dhfile, *hitfile;

  if(argc<7)
  {
     fprintf(stdout, "usage: %s <infilename> <infilename.perturb> \
     <outfilenameg> <outfilenamemag> <outputfilenamedh> <outputfilenamehit>\n\
     Outputs:<outfilenameg>.dat <outfilenamemag>.dat <outfilenamedh>.dat \
     <outputfilenamehit> files\n", argv[0]);
     return 1;
  }
  strcpy(infilenamertr, argv[1]);
  strcpy(infilenamepert, argv[2]);
  strcpy(outfilenameg, argv[3]);
  strcpy(outfilenamem, argv[4]);
  strcpy(outfilenamedh, argv[5]);
  strcpy(outfilenamehit, argv[6]);

  count = Input_rtr(infilenamertr, &res, &Mres, &ipmax, &a, &mu_o, &x, &k, &hit, &g, &emcos, &M);

  get_perturb_vals(&m, &p, &cs2, &omega_r, &omega_i);
  fprintf(stderr, "read %d bytes from %s\n", count, infilenamertr);
   
   
  read_disc(infilenamepert);
  
  gfile = fopen(outfilenameg, "w");
  Mfile = fopen(outfilenamem, "w");
  dhfile = fopen(outfilenamedh, "w");
  hitfile = fopen(outfilenamehit, "w");
   
  for(i=0;i<Mres;i++)
  {
     for(j=0;j<Mres;j++)
     {
        fprintf(stderr, "%d,%d, phi = %g\n", i, j, x[i][j][3]);
        fprintf(gfile, "%E ", g[i][j]);
        fprintf(Mfile, "%E ", M[i][j]);
        interp_perturb(x[i][j][1], &dhr, &dhi, &idur, &idui);
        Em = (dhr + 1.0i*dhi)*pow(x[i][j][1], (-13.0/8.0)-(15.0*p/4.0))*
             (cos(omega_r*x[i][j][0]) + 1.0i*sin(omega_r*x[i][j][0]))*
             (cos(m*x[i][j][3]) + 1.0i*sin(m*x[i][j][3]));
        if (x[i][j][1] > 6.0) 
        {
	   hitval = 1;
        } 
        else 
        {
	   hitval = 0;
        }
       
        fprintf(dhfile, "%E+I*%E ", __real__ Em, __imag__ Em);
        fprintf(hitfile, "%d ", hitval);
     }

     fprintf(gfile, "\n");
     fprintf(Mfile, "\n");
     fprintf(dhfile, "\n");
     fprintf(hitfile, "\n");
  }

  fclose(gfile);
  fclose(Mfile);
  fclose(dhfile);
  fclose(hitfile);
  return 0;
}
