/*
 *Handles reading the stored disc perturbations .perturb files
 *
 *
 */


#include<stdlib.h>
#include<stdio.h>
#include <string.h>
#include "nrutil.h"
#include "nrinterp.h"

double mm;
double pp;
double ccs2;
double oomega_r;
double oomega_i;
int kkount = 0;
double *xxp;
double *ddhr;
double *ddhi;
double *iidur;
double *iidui;


//Reads .perturbfiles. Initializes arrays as well.
int Input_perturb(const char * filename,
		  double *m,
		  double *p,
		  double *cs2,
		  double *omega_r,
		  double *omega_i,
		  int *kount,
		  double **xp,
		  double **dhr,
		  double **dhi,
		  double **idur,
		  double **idui)
{
  FILE *infile;
  int iCount;
  iCount = 0;

  infile = fopen(filename, "rb");
  iCount += fread(m, sizeof(double), 1, infile);
  iCount += fread(p, sizeof(double), 1, infile);
  iCount += fread(cs2, sizeof(double), 1, infile);
  iCount += fread(omega_r, sizeof(double), 1, infile);
  iCount += fread(omega_i, sizeof(double), 1, infile);
  iCount += fread(kount, sizeof(int), 1, infile);

  //  Initialize arrays
  *xp = malloc(sizeof(double)*(*kount));
  *dhr = malloc(sizeof(double)*(*kount));
  *dhi = malloc(sizeof(double)*(*kount));
  *idur = malloc(sizeof(double)*(*kount));
  *idui = malloc(sizeof(double)*(*kount));

  //populate arrays
  iCount += fread((*xp), sizeof(double), (*kount), infile);
  iCount += fread((*dhr), sizeof(double), (*kount), infile);
  iCount += fread((*dhi), sizeof(double), (*kount), infile);
  iCount += fread((*idur), sizeof(double), (*kount), infile);
  iCount += fread((*idui), sizeof(double), (*kount), infile);
  
  fclose(infile);
  return iCount;

}


int read_disc(const char * filename)
{
  int count;
  //reads the perturb file and sets up arrays for interpolation
  count = Input_perturb(filename, &mm, &pp, &ccs2, &oomega_r, &oomega_i, 
			&kkount, &xxp, &ddhr, &ddhi, &iidur, &iidui);

  fprintf(stdout, "Read %d bytes from %s\n", count, filename);
    
  return count;
}


int interp_perturb(double r, double *dhr, double *dhi, 
		   double *idur, double *idui)
{
  unsigned long j;
  double polym;
  int k;
  double error[5];

  polym = 5;

  //performs interpolation using arrays loaded by read_disc, returns error if
  //array is not yet loaded.
  if (kkount == 0){ 
    fprintf(stderr, ".perturb array not yet loaded, and read_disc not called\n");
    return -1;
  }
  
  if (r < xxp[kkount-1] || r > xxp[1]){
    *dhr = 0.0;
    *dhi = 0.0;
    *idur = 0.0;
    *idui = 0.0;
    return 1;
  }

  locate(xxp, kkount, r, &j);
  k = IMIN(IMAX(j-(polym-1)/2,1), kkount+1-polym);
  polint2(&xxp[k-1], &ddhr[k-1], polym, r, dhr, &error[1]);
  polint2(&xxp[k-1], &ddhi[k-1], polym, r, dhi, &error[2]);
  polint2(&xxp[k-1], &iidur[k-1], polym, r, idur, &error[3]);
  polint2(&xxp[k-1], &iidui[k-1], polym, r, idui, &error[4]);
  
  return 0;

}

int get_perturb_vals(double *m, double *p, double *cs2, 
		     double *omega_r, double *omega_i)
{
  if (kkount == 0)
  { 
    fprintf(stderr,".perturb array not yet loaded, and read_disc not called\n");
    return -1;
  }
  *m = mm;
  *p = pp;
  *cs2 = ccs2;
  *omega_r = oomega_r;
  *omega_i = oomega_i;
  return 0;
}
