from gen_perturb import *
import numpy as np
import math
import gen_rtr as gen
import cPickle as pickle
import colorsys
import matplotlib.cm as cm
import pylab as plt

plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['font.family'] = "serif"
plt.rcParams['font.serif'] = "times"
plt.rcParams['axes.unicode_minus'] = False
plt.rcParams['font.size'] = 8
plt.rcParams['text.usetex'] = 'True'
plt.rcParams['xtick.major.size'] = 2
plt.rcParams['ytick.major.size'] = 2
 
   
def plot_simple_I(ptype, a, mu):
   in_file = read_in_file = 'perturb/data/spec_a'+str(a)+'_mu'+str(mu)+'_'+str(ptype)+'.dat'
   infile = open(in_file, 'r')
   spect = pickle.load(infile)  
   gmax = pickle.load(infile)
   x = pickle.load(infile)
   infile.close() 
   print gmax

   I = np.multiply(spect, 1.0/max(spect))
   plt.axes().set_aspect(.6)
   plt.plot(x, I)
   plt.xlabel("Redshift")
   plt.ylabel("Intensity")
   plt.xlim([0, 11.0*gmax/10.0])
   plt.ylim([0.0, I.max() + .1])
   plt.show()


def plot_I(g, h, I, nbins, outfile):
   spect = bin_I(g, h, I, nbins)
   x = np.arange(g.min(), g.max(), (g.max()-g.min())/nbins)

   plt.plot(x, spect)
   plt.xlim([0.0, 1.4])
  # plt.ylim([0.0, spect.max() + 2])
   plt.xlabel("Redshift")
   plt.ylabel("Intensity")
   plt.savefig(outfile, format='pdf')
     

def plot_image(ptype, a, mu, n, tilt, outfile): 
   if tilt: 
      f = 'perturb/data/im_tilt_a_'+str(a)+'_mu'+str(mu)+'_n'+str(n)+'_h0.01_'+str(ptype)+'.dat'
   else:
      f = 'perturb/data/test3_im_a_'+str(a)+'_mu'+str(mu)+'_n'+str(n)+'_h0.01_'+str(ptype)+'.dat'
   infile = open(f, 'r')
   rgb = pickle.load(infile)
   g = pickle.load(infile)
   res = pickle.load(infile)
   ipmax = pickle.load(infile)
   infile.close()

   plt.xlabel("$\hat{\\alpha}$")
   plt.ylabel("$\hat{\\beta}$")
   plot = plt.imshow(rgb, extent=[-ipmax,ipmax,-ipmax,ipmax])

   # adding and modifying color bar on the side
   cbar = plt.colorbar(plot,ticks=[0, .5, 1])
   cbar.ax.set_yticklabels([round(g.max(),2), round(g.max()/2, 2), g.min()])
   cbar.set_label(r'Redshift')
   if outfile == 'show':
      plt.show()
   else:
      plt.savefig(outfile, format='pdf')

def plot_int(ptype, a, mu, n, tilt, output):
   if tilt:
      f = '../../Desktop/tilt_a'+str(a)+'_mu'+str(mu)+'_'+str(ptype)+'.dat'
   else:
      f = 'perturb/data/int_diff_a'+str(a)+'_mu'+str(mu)+'_n'+str(n)+'_h0.01_'+str(ptype)+'.dat'
   infile = open(f,'r')
   intensity = pickle.load(infile)
   gmax = pickle.load(infile)
   infile.close()
   spect = []
   xmax = gmax 
   print gmax
   for i in range(len(intensity)-1, -1,-1):
      #spect.append(np.append(intensity[i],5*[0]))
      spect.append(intensity[i])

   fig = plt.figure()
   ax1 = fig.add_subplot(1,1,1)
   plot = plt.imshow(spect, vmin = -1, vmax = 1)
   plt.ylabel('Phase')
   if gmax < 1.1:
      ax1.set_xticks([0,.2*50/gmax, .4*50/gmax, .6*50/gmax,.8*50/gmax, \
                      50.0/gmax])
      xlabels = np.arange(0, 1.2, .2) 
   elif gmax > 1.3:
      ax1.set_xticks([0,.2*50/gmax, .4*50/gmax, .6*50/gmax,.8*50/gmax, \
                      50.0/gmax, 1.2*50/gmax, 1.4*50/gmax]) 
      xlabels = np.arange(0, 1.6, .2)
   else:
      ax1.set_xticks([0,.2*50/gmax, .4*50/gmax, .6*50/gmax,.8*50/gmax, \
                      50.0/gmax, 1.2*50/gmax])
      xlabels = np.arange(0, 1.4, .2)
   ax1.set_yticks([0, 5, 10, 15, 20])
   ax1.set_xticklabels(xlabels)
   ax1.set_yticklabels([2.0, 1.5, 1.0, 0.5, 0.0])
   if output == 'show':
      plt.show()
   else:
      plt.savefig(output)
      plt.clf()
  
def set_labels(gmax, nbins):
   if gmax > 1.3:
      xticks = [0,.2*nbins/gmax, .4*nbins/gmax, .6*nbins/gmax,.8*nbins/gmax, \
                nbins/gmax, 1.2*nbins/gmax, 1.4*nbins/gmax]
      xlabels = np.arange(0, 1.6, .2)
   elif gmax < 1.1:      
      xticks = [0,.2*nbins/gmax, .4*nbins/gmax, .6*nbins/gmax,.8*nbins/gmax, \
                nbins/gmax]
      xlabels = np.arange(0, 1.2, .2)
   else:
      xticks = [0,.2*nbins/gmax, .4*nbins/gmax, .6*nbins/gmax,.8*nbins/gmax, \
                nbins/gmax, 1.2*nbins/gmax]
      xlabels = np.arange(0, 1.4, .2) 
   return xticks, xlabels
  
def plot_stack(ptype, a):
   tilted1 = []
   n10 = []
   n11 = []
   n12 = []  
   tilted5 = []
   n50 = []
   n51 = []
   n52 = []  
   tilted7 = []
   n70 = []
   n71 = []
   n72 = []  

   file1 = open('perturb/data/spec_a'+str(a)+'_mu0.1_'+str(ptype)+'.dat', 'r')
   spec1 = pickle.load(file1)  
   gmax1 = pickle.load(file1)
   x1 = pickle.load(file1)
   file1.close()
     

   file2 = open('perturb/data/tilt_a'+str(a)+'_mu0.1_'+str(ptype)+'.dat', 'r')
   tilted_temp1 = pickle.load(file2)
   gmax2 = pickle.load(file2)
   file2.close()

   file3 = open('perturb/data/int_diff_a'+str(a)+'_mu0.1_n0_h0.01_'+str(ptype)+'.dat', 'r')
   n0_temp1 = pickle.load(file3)
   gmax10 = pickle.load(file3)
   file3.close()

   file4 = open('perturb/data/int_diff_a'+str(a)+'_mu0.1_n1_h0.01_'+str(ptype)+'.dat', 'r')
   n1_temp1 = pickle.load(file4)
  # temp12 = pickle.load(file4)
   file4.close()

   file5 = open('perturb/data/int_diff_a'+str(a)+'_mu0.1_n2_h0.01_'+str(ptype)+'.dat', 'r')
   n2_temp1 = pickle.load(file5)
  # temp13 = pickle.load(file5)
   file5.close()

   file6 = open('perturb/data/spec_a'+str(a)+'_mu0.5_'+str(ptype)+'.dat', 'r')
   spec5 = pickle.load(file6) 
   gmax5 = pickle.load(file6)
   x5 = pickle.load(file6) 
   file6.close()  

   file7 = open('perturb/data/tilt_a'+str(a)+'_mu0.5_'+str(ptype)+'.dat', 'r')
   tilted_temp5 = pickle.load(file7)
   gmax6 = pickle.load(file7)
   file7.close()
   print gmax6

   file8 = open('perturb/data/int_diff_a'+str(a)+'_mu0.5_n0_h0.01_'+str(ptype)+'.dat', 'r')
   n0_temp5 = pickle.load(file8)
   gmax50 = pickle.load(file8)
   file8.close()
   print gmax50
  
   file9 = open('perturb/data/int_diff_a'+str(a)+'_mu0.5_n1_h0.01_'+str(ptype)+'.dat', 'r')
   n1_temp5 = pickle.load(file9)
   file9.close()

   file10 = open('perturb/data/int_diff_a'+str(a)+'_mu0.5_n2_h0.01_'+str(ptype)+'.dat', 'r')
   n2_temp5 = pickle.load(file10)
   file10.close()


   file11 = open('perturb/data/spec_a'+str(a)+'_mu0.7_'+str(ptype)+'.dat', 'r')
   spec7 = pickle.load(file11)
   gmax7 = pickle.load(file11)
   x7 = pickle.load(file11)
   file11.close()  

   file12 = open('perturb/data/tilt_a'+str(a)+'_mu0.7_'+str(ptype)+'.dat', 'r')
   tilted_temp7 = pickle.load(file12)
   gmax8 = pickle.load(file12)
   file12.close()

   file13 = open('perturb/data/int_diff_a'+str(a)+'_mu0.7_n0_h0.01_'+str(ptype)+'.dat', 'r')
   n0_temp7 = pickle.load(file13)
   file13.close()

  
   file14 = open('perturb/data/int_diff_a'+str(a)+'_mu0.7_n1_h0.01_'+str(ptype)+'.dat', 'r')
   n1_temp7 = pickle.load(file14)
   file14.close()

   file15 = open('perturb/data/int_diff_a'+str(a)+'_mu0.7_n2_h0.01_'+str(ptype)+'.dat', 'r')
   n2_temp7 = pickle.load(file15)
   gmax12 = pickle.load(file15)
   file15.close()
   
   print gmax50
   buff = 10
   scale = 6.0/5.0

   for i in range(len(tilted_temp1)-1, -1,-1):
      tilted1.append(np.append(tilted_temp1[i],5*[0]))
      n10.append(np.append(n0_temp1[i], buff*[0]))
      n11.append(np.append(n1_temp1[i], buff*[0]))
      n12.append(np.append(n2_temp1[i], buff*[0]))
      tilted5.append(np.append(tilted_temp5[i],buff*[0]))
      n50.append(np.append(n0_temp5[i], buff*[0]))
      n51.append(np.append(n1_temp5[i], buff*[0]))
      n52.append(np.append(n2_temp5[i], buff*[0]))
      tilted7.append(np.append(tilted_temp7[i],buff*[0]))
      n70.append(np.append(n0_temp7[i], buff*[0]))
      n71.append(np.append(n1_temp7[i], buff*[0]))
      n72.append(np.append(n2_temp7[i], buff*[0]))
  
   print len(tilted1[0])
   print len(tilted5[0])
   ax1 = plt.subplot(531)
   ax2 = plt.subplot(534)
   ax3 = plt.subplot(537)
   ax4 = plt.subplot(5,3,10)
   ax5 = plt.subplot(5,3,13)
   ax6 = plt.subplot(532)
   ax7 = plt.subplot(535)
   ax8 = plt.subplot(538)
   ax9 = plt.subplot(5,3,11)
   ax10 = plt.subplot(5,3,14)
   ax11 = plt.subplot(5,3,3)
   ax12 = plt.subplot(5,3,6)
   ax13 = plt.subplot(5,3,9)
   ax14 = plt.subplot(5,3,12)
   ax15 = plt.subplot(5,3,15)
  
   
   I1 = np.multiply(spec1, 1.0/max(spec1))
   I5 = np.multiply(spec5, 1.0/max(spec5))
   I7 = np.multiply(spec7, 1.0/max(spec7))
   
   nbins1 = len(n10[0])-buff
   nbins5 = len(n50[0])-buff
   nbins7 = len(n70[0])-buff
 
   xticks1, xlabels1 = set_labels(gmax10, nbins1)
   xticks5, xlabels5 = set_labels(gmax50, nbins5)
   xticks7, xlabels7 = set_labels(gmax12, nbins7)

   ratio_factor = .3607

   ax1.set_aspect(gmax2*ratio_factor)#.505)
   ax6.set_aspect(gmax6*ratio_factor)#.44)
   ax11.set_aspect(gmax12*ratio_factor)#.4)

 
   ax1.plot(x1, I1, color = 'black')
   ax1.set_ylabel("Intensity")
   #ax1.set_xticklabels([])
   ax1.set_xlim([0, (11.0/10.0)* gmax2])
   ax1.set_ylim([0.0, I1.max() + .1])

   ax2.imshow(tilted1, vmin = -1, vmax = 1)
   ax2.set_ylabel('Phase')
   ax2.set_xticks(xticks1)
   #ax2.set_xticklabels([])
   ax2.set_yticks([0, 5, 10, 15, 20])
   ax2.set_yticklabels([2.0, 1.5, 1.0, 0.5, 0.0])

   ax3.imshow(n10, vmin = -1, vmax = 1, extent = [0, 55,20,0])
   ax3.set_ylabel('Phase')
   ax3.set_xticks(xticks1)
   ax3.set_xticklabels([])
   ax3.set_yticks([0, 5, 10, 15, 20])
   ax3.set_yticklabels([2.0, 1.5, 1.0, 0.5, 0.0])

   ax4.imshow(n11, vmin = -1, vmax = 1, extent = [0, 55,20,0])
   ax4.set_ylabel('Phase')
   ax4.set_xticks(xticks1)
   ax4.set_xticklabels([])
   ax4.set_yticks([0, 5, 10, 15, 20])
   ax4.set_yticklabels([2.0, 1.5, 1.0, 0.5, 0.0])

   ax5.imshow(n12, vmin = -1, vmax = 1, extent = [0, 55,20,0])
   ax5.set_ylabel('Phase')
   ax5.set_xlabel('g')
   ax5.set_xticks(xticks1)
   ax5.set_xticklabels([])
   ax5.set_yticks([0, 5, 10, 15, 20])
   ax5.set_xticklabels(xlabels1)
   ax5.set_yticklabels([2.0, 1.5, 1.0, 0.5, 0.0])

   ax6.plot(x5, I5, color = 'black')
   #ax6.set_xticklabels([])
   ax6.set_yticklabels([])
   ax6.set_xlim([0, scale*gmax6])
   ax6.set_ylim([0.0, I5.max() + .1])

   ax7.imshow(tilted5, vmin = -1, vmax = 1)
   ax7.set_xticks(xticks5)
   #ax7.set_xticklabels([])
   ax7.set_yticks([0, 5, 10, 15, 20])
   ax7.set_yticklabels([])

   ax8.imshow(n50, vmin = -1, vmax = 1)
   ax8.set_xticks(xticks5)
   ax8.set_xticklabels([])
   ax8.set_yticks([0, 5, 10, 15, 20])
   ax8.set_yticklabels([])

   ax9.imshow(n51, vmin = -1, vmax = 1)
   ax9.set_xticks(xticks5)
   ax9.set_xticklabels([])
   ax9.set_yticks([0, 5, 10, 15, 20])
   ax9.set_yticklabels([])

   ax10.imshow(n52, vmin = -1, vmax = 1)
   ax10.set_xlabel('g')
   ax10.set_xticks(xticks5)
   ax10.set_xticklabels([])
   ax10.set_yticks([0, 5, 10, 15, 20])
   ax10.set_xticklabels(xlabels5)
   ax10.set_yticklabels([])

   ax11.plot(x7, I7, color = 'black')
   #ax11.set_xticklabels([])
   ax11.set_yticklabels([])
   ax11.set_xlim([0, (6.5/5.0)*gmax12])
   ax11.set_ylim([0.0, I7.max() + .1])

   ax12.imshow(tilted7, vmin = -1, vmax = 1)
   ax12.set_xticks(xticks7)
   ax12.set_xticklabels([])
   ax12.set_yticks([0, 5, 10, 15, 20])
   ax12.set_yticklabels([])

   ax13.imshow(n70, vmin = -1, vmax = 1)
   ax13.set_xticks(xticks7)
   ax13.set_xticklabels([])
   ax13.set_yticks([0, 5, 10, 15, 20])
   ax13.set_yticklabels([])

   ax14.imshow(n71, vmin = -1, vmax = 1)
   ax14.set_xticks(xticks7)
   ax14.set_xticklabels([])
   ax14.set_yticks([0, 5, 10, 15, 20])
   ax14.set_yticklabels([])

   ax15.imshow(n72, vmin = -1, vmax = 1)
   ax15.set_xlabel('g')
   ax15.set_xticks(xticks7)
   ax15.set_xticklabels([])
   ax15.set_yticks([0, 5, 10, 15, 20])
   ax15.set_xticklabels(xlabels7)
   ax15.set_yticklabels([])


   plt.text(-146,-65,"tilted", verticalalignment="center", rotation = 90)
   plt.text(-146,-40.25,"n = 0", verticalalignment="center", rotation = 90)
   plt.text(-146,-15.55,"n = 1", verticalalignment="center", rotation = 90)
   plt.text(-146,9.25,"n = 2", verticalalignment="center", rotation = 90)

   plt.text(-105,-104,"$\mu_o = 0.1$", verticalalignment="center", rotation = 0)
   plt.text(-40,-104,"$\mu_o = 0.5$", verticalalignment="center", rotation = 0)
   plt.text(23,-104,"$\mu_o = 0.7$", verticalalignment="center", rotation = 0)

   if ptype == 1:
      plt.text(-75,-110,"a = " +str(a)+", Limb Darkening", fontsize = 15,\
               verticalalignment="center", rotation = 0)

   if ptype == 2:
      plt.text(-75,-110,"a = "+str(a)+", Limb Brightening", fontsize = 15,\
               verticalalignment="center", rotation = 0)


   plt.subplots_adjust(right = .9, top = .825, bottom =.175, wspace = .1)
   outfile = 'perturb/stack_a'+str(a)+'_'+str(ptype)+'.pdf'
   plt.show()
   plt.savefig(outfile)
   plt.clf()


p = 3
m = 1

nbins = 50

ptype = 1
tilt = False
delta = 0

ipm = 0
a = 0.001
#plot_contour(a, .1, ipm)
#plot_contour(a, .5, ipm)
#plot_contour(a, .7, ipm)

#temp()

#plot_image(2, a, mu, n, tilt,'show')
#plot_image(2, .9, .1, 0, tilt, 'show')
plot_stack(1, .9)
#plot_stack(2, .9)
#gen_movie(ptype, a, mu, n, ipm, ksi_o, tilt, num_pic)
#gen_movie(1, .001, .5, 2, 20, .009, False, 4)
#gen_movie(2, .001, .5, 2, 20, .007, False, 4)
#ipm = 5
#plot_int(1, .9, .1, 2, tilt, 'show')
#plot_simple_I(1, .9, .7)



