#include <stdlib.h>
#include <stdio.h>
#include "nrutil.h"
#include "discread.h"
#include "nrinterp.h"
#include <string.h>

int main(int argc, char *argv[])
{
  int kount, i, count;
  double m, p, cs2, omega_r, omega_i;
  double rval;
  double r[1000], y1[1000], y2[1000], y3[1000], y4[1000];

  int j, polym;

  char infilename[100];
  char outfilename[100];

  FILE *outfile;

  polym = 4;

  if (argc<3)
  {
     fprintf(stdout, "usage: %s, <infilename.perturb> <outfilename.dat> \n\
     Outputs outfilename.dat files\n", argv[0]);
    return 1;
  }
  
  strcpy(infilename, argv[1]);
  strcpy(outfilename, argv[2]);

  outfile = fopen(outfilename, "w");

  count = read_disc(infilename);

  fprintf(stdout, "Read %d bytes from %s\n", count, infilename);

  get_perturb_vals(&m, &p, &cs2, &omega_r, &omega_i);

  fprintf(stdout, "m = %g, p = %g, cs2 = %g, omega_r = %g, omega_i = %g,\
  kount= %d\n", m, p, cs2, omega_r, omega_i, kount);

  i = 0;
  for(rval = 6.03; rval < 30.0; rval += (30.0-6.0)/1000.0)
  {
     r[i++] = rval;
     interp_perturb(rval, &y1[i], &y2[i], &y3[i], &y4[i]);
  }

  for(j = 0; j < i; j++)
     fprintf(outfile, "%20.20E %20.20E\n", r[j], y1[j]);
  fprintf(stdout, "wrote %s \n", outfilename);
  fclose(outfile);

  return 0;
}
