#include <stdlib.h>
#include <stdio.h>
#include "rtr.h"
#include "kerr.h"


int main(int argc, char *argv[])
{
  int res, Mres;
  double ipmax, a, mu_o;
  double ***x, ***k, ***x2, ***k2;
  int **hit;
  int **hit2;
  double **g, **emcos, **M;
  double **g2, **emcos2, **M2;
  int i, j, l;
  int count;

  res = 20;
  Mres = 18;

  ipmax = 10.0;
  a = 0.5;
  mu_o = 0.1;

  x = malloc(sizeof(double**)*(res));
  k = malloc(sizeof(double**)*(res));
  hit = malloc(sizeof(int*)*(res));
  for(i=0; i< res; i++)
  {
     x[i] = malloc(sizeof(double*)*(res));
     k[i] = malloc(sizeof(double*)*(res));
     hit[i] = malloc(sizeof(int)*(res));
     for(j=0; j< res; j++)
     {
        x[i][j] = init_4v();
        k[i][j] = init_4v();
        hit[i][j] = 1;
        for(l=0; l<4; l++)
        {
	   x[i][j][l] = i+j+l;
	   k[i][j][l] = i+j+l+0.1;
        }
     }
  }
  
  g = malloc(sizeof(double*)*(Mres));
  emcos = malloc(sizeof(double*)*(Mres));
  M = malloc(sizeof(double*)*(Mres));
  for(i=0; i < Mres; i++)
  {
     g[i] = malloc(sizeof(double)*(Mres));
     emcos[i] = malloc(sizeof(double)*(Mres));
     M[i] = malloc(sizeof(double)*(Mres));
    
     for(j=0; j< Mres; j++)
     {
        g[i][j] = i+j;
        emcos[i][j] = 0.1+i+j;
        M[i][j] = 0.2 + i+j;
     }
  }
  
  count = Output_rtr("testfile.rtr", res, Mres, ipmax, a, mu_o, x, k, hit, 
                                     g, emcos, M);
  
  fprintf(stderr, "count = %d\n", count);
  
  for(i=0; i< res; i++)
  {
     for(j=0; j< res; j++)
     {
        free(x[i][j]);
        free(k[i][j]);
     }
     free(x[i]);
     free(k[i]);
     free(hit[i]);
  }

  for(i=0; i< Mres; i++)
  {
     free(g[i]);
     free(emcos[i]);
     free(M[i]);
  }



  free(x);
  free(k);
  free(hit);
  free(g);
  free(M);
  free(emcos); 

  res = 0;
  Mres = 0;

  ipmax = 0.0;
  a = 0.;
  mu_o = 0.;
  
  count = Input_rtr("testfile.rtr", &res, &Mres, &ipmax, &a, &mu_o, &x2, &k2, 
                                    &hit2, &g2, &emcos2, &M2);

  fprintf(stdout, "readcount = %d\n", count);
  fprintf(stdout, "res = %d, Mres = %d, ipmax = %g, a = %g, mu_o = %g\n", 
                   res, Mres, ipmax, a, mu_o);

  for(i=0; i<res;i++)
     for(j=0; j<res; j++)
     {
        fprintf(stdout, "x[%d][%d] = ", i, j);
        for(l=0; l<4; l++)
	   fprintf(stdout, "%g ", x2[i][j][l]);
 
        fprintf(stdout, "\n");
        fprintf(stdout, "k[%d][%d] = ", i, j);
        for(l=0; l<4; l++)
	   fprintf(stdout, "%g ", k2[i][j][l]);
        fprintf(stdout, "\n");
     }
    
  for(i=0; i<Mres; i++)
  {
     fprintf(stdout, "g[%d] = ", i);
     for(j=0; j<Mres; j++)
        fprintf(stdout, "%g ", g2[i][j]);
     fprintf(stdout, "\n");
     fprintf(stdout, "emcos[%d] = ", i);
     for(j=0; j<Mres; j++)
        fprintf(stdout, "%g ", emcos2[i][j]);
     fprintf(stdout, "\n");
     fprintf(stdout, "M[%d] = ", i);
     for(j=0; j<Mres; j++)
        fprintf(stdout, "%g ", M2[i][j]);
     fprintf(stdout, "\n");
  }
  return 0;
}
