/*
 * Handles storing and retrieving rtr files
 * .rtr files are both rtr and Image arrays (without obsI)
 * int res
 * int Mres
 * double ipmax
 * double a
 * double mu_o
 * double x[res][res][4]
 * double k[res][res][4]
 * int hit[res][res]
 * double g[Mres][Mres]
 * double emcos[Mres][Mres]
 * double M[Mres][Mres]
 */


#include<stdlib.h>
#include<stdio.h>
#include "raytrace.h"
#include <string.h>
#include "kerr.h"

int Output_rtr(const char * filename,
	       int res,
	       int Mres,
	       double ipmax, 
	       double a, 
	       double mu_o,
	       double ***x,
	       double ***k,
	       int **hit,
	       double **g,
	       double **emcos,
	       double **M)
{
  FILE *outfile;
  int iCount=0;
  int i,j;
  
  outfile = fopen(filename, "wb");
  //system/trace parameters
  iCount += fwrite(&res, sizeof(int), 1, outfile);
  iCount += fwrite(&Mres, sizeof(int), 1, outfile);
  iCount += fwrite(&ipmax, sizeof(double), 1, outfile);
  iCount += fwrite(&a, sizeof(double), 1, outfile);
  iCount += fwrite(&mu_o, sizeof(double), 1, outfile);

  //rtr arrays
  for(i=0; i<res; i++)
     for(j=0; j<res; j++)
        iCount += fwrite(x[i][j], sizeof(double), 4, outfile);
  for(i=0; i<res; i++)
     for(j=0; j<res; j++)
        iCount += fwrite(k[i][j], sizeof(double), 4, outfile);
  for(i=0; i<res; i++)
     iCount += fwrite(hit[i], sizeof(int), res, outfile);

  //Image arrays
  for(i=0; i<Mres; i++)
     iCount += fwrite(g[i], sizeof(double), Mres, outfile);
  for(i=0; i<Mres; i++)
     iCount += fwrite(emcos[i], sizeof(double), Mres, outfile);
  for(i=0; i<Mres; i++)
     iCount += fwrite(M[i], sizeof(double), Mres, outfile);


  fclose(outfile);
  return iCount;
}



//Reads rtr files. Initializes the arrays involved as well.
int Input_rtr(const char * filename,
	      int *res,
	      int *Mres,
	      double *ipmax, 
	      double *a, 
	      double *mu_o,
	      double ****x,
	      double ****k,
	      int ***hit,
	      double ***g,
	      double ***emcos,
	      double ***M)
{ 
  FILE *infile;
  int iCount;
  int i, j;

  iCount = 0;

  infile = fopen(filename, "rb");
  iCount += fread(res, sizeof(int), 1, infile);
  iCount += fread(Mres, sizeof(int), 1, infile);
  iCount += fread(ipmax, sizeof(double), 1, infile);
  iCount += fread(a, sizeof(double), 1, infile);
  iCount += fread(mu_o, sizeof(double), 1, infile);

  //Initialize arrays
  *x = malloc(sizeof(double**)*(*res));
  *k = malloc(sizeof(double**)*(*res));
  *hit = malloc(sizeof(int*)*(*res));
  for(i=0; i< *res; i++)
  {
     (*x)[i] = malloc(sizeof(double*)*(*res));
     (*k)[i] = malloc(sizeof(double*)*(*res));
     (*hit)[i] = malloc(sizeof(int)*(*res));
     for(j=0; j< *res; j++)
     {
        (*x)[i][j] = init_4v();
        (*k)[i][j] = init_4v();
     }
  }

  *g = malloc(sizeof(double*)*(*Mres));
  *emcos = malloc(sizeof(double*)*(*Mres));
  *M = malloc(sizeof(double*)*(*Mres));
  for(i=0; i < *Mres; i++)
  {
     (*g)[i] = malloc(sizeof(double)*(*Mres));
     (*emcos)[i] = malloc(sizeof(double)*(*Mres));
     (*M)[i] = malloc(sizeof(double)*(*Mres)); 
  }

  //populate rtr arrays
  for(i=0; i<*res; i++)
     for(j=0; j<*res; j++)
     {
       iCount += fread((*x)[i][j], sizeof(double), 4, infile);
     }
  for(i=0; i<*res; i++)
     for(j=0; j<*res; j++)
     {
        iCount += fread((*k)[i][j], sizeof(double), 4, infile);
     }
  for(i=0; i<*res; i++)
     iCount += fread((*hit)[i], sizeof(int), *res, infile);

  //populate Image arrays
  for(i=0; i<*Mres; i++)
     iCount += fread((*g)[i], sizeof(double), *Mres, infile);
  for(i=0; i<*Mres; i++)
     iCount += fread((*emcos)[i], sizeof(double), *Mres, infile);
  for(i=0; i<*Mres; i++)
     iCount += fread((*M)[i], sizeof(double), *Mres, infile);

  fclose(infile);
  return iCount;

}

