from gen_perturb import *
import numpy as np
import math
import gen_rtr as gen
import cPickle as pickle
import colorsys
import matplotlib.cm as cm
import pylab as plt

plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['font.family'] = "serif"
plt.rcParams['font.serif'] = "times"
plt.rcParams['axes.unicode_minus'] = False
plt.rcParams['font.size'] = 8
plt.rcParams['text.usetex'] = 'True'
plt.rcParams['xtick.major.size'] = 2
plt.rcParams['ytick.major.size'] = 2
 

def plot_g_stack(ptype, mu):

   file10 = open('ref/intensity0.001_mu'+str(mu)+'_n0_'+str(ptype)+'.dat', 'r')
   spec10 = pickle.load(file10)  
   x = pickle.load(file10)
   file11 = open('ref/intensity0.001_mu'+str(mu)+'_n1_'+str(ptype)+'.dat', 'r')
   spec11 = pickle.load(file11)  
   file12 = open('ref/intensity0.001_mu'+str(mu)+'_n2_'+str(ptype)+'.dat', 'r')
   spec12 = pickle.load(file12)  
   
   file20 = open('ref/intensity0.01_mu'+str(mu)+'_n0_'+str(ptype)+'.dat', 'r')
   spec20 = pickle.load(file20)  
   file21 = open('ref/intensity0.01_mu'+str(mu)+'_n1_'+str(ptype)+'.dat', 'r')
   spec21 = pickle.load(file21)  
   file22 = open('ref/intensity0.01_mu'+str(mu)+'_n2_'+str(ptype)+'.dat', 'r')
   spec22 = pickle.load(file22)  

   file30 = open('ref/intensity0.1_mu'+str(mu)+'_n0_'+str(ptype)+'.dat', 'r')
   spec30 = pickle.load(file30)  
   file31 = open('ref/intensity0.1_mu'+str(mu)+'_n1_'+str(ptype)+'.dat', 'r')
   spec31 = pickle.load(file31)  
   file32 = open('ref/intensity0.1_mu'+str(mu)+'_n2_'+str(ptype)+'.dat', 'r')
   spec32 = pickle.load(file32)  

   file40 = open('ref/intensity0.5_mu'+str(mu)+'_n0_'+str(ptype)+'.dat', 'r')
   spec40 = pickle.load(file40)  
   file41 = open('ref/intensity0.5_mu'+str(mu)+'_n1_'+str(ptype)+'.dat', 'r')
   spec41 = pickle.load(file41)  
   file42 = open('ref/intensity0.5_mu'+str(mu)+'_n2_'+str(ptype)+'.dat', 'r')
   spec42 = pickle.load(file42)  

   file50 = open('ref/intensity0.9_mu'+str(mu)+'_n0_'+str(ptype)+'.dat', 'r')
   spec50 = pickle.load(file50)  
   file51 = open('ref/intensity0.9_mu'+str(mu)+'_n1_'+str(ptype)+'.dat', 'r')
   spec51 = pickle.load(file51)  
   file52 = open('ref/intensity0.9_mu'+str(mu)+'_n2_'+str(ptype)+'.dat', 'r')
   spec52 = pickle.load(file52)  


   
   ax1 = plt.subplot(531)
   ax2 = plt.subplot(534)
   ax3 = plt.subplot(537)
   ax4 = plt.subplot(5,3,10)
   ax5 = plt.subplot(5,3,13)
   ax6 = plt.subplot(532)
   ax7 = plt.subplot(535)
   ax8 = plt.subplot(538)
   ax9 = plt.subplot(5,3,11)
   ax10 = plt.subplot(5,3,14)
   ax11 = plt.subplot(5,3,3)
   ax12 = plt.subplot(5,3,6)
   ax13 = plt.subplot(5,3,9)
   ax14 = plt.subplot(5,3,12)
   ax15 = plt.subplot(5,3,15)

   wid = 0.01
   xmax = 1.3 #1.41
   ymax = 1.1
   nbins = 100
   xticks = [0, .2, .4, .6, .8, 1.0, 1.2, 1.4]
   cmap = cm.jet_r(x/xmax)

   ax1.bar(x, spec10, width = wid, color= cmap, edgecolor = cmap)
   ax1.set_xticklabels([])
   ax1.set_xlim([0, xmax])
   ax1.set_ylim([0.0, ymax])

   ax2.bar(x, spec20, width = wid, color= cmap, edgecolor = cmap)
   ax2.set_xticklabels([])
   ax2.set_xlim([0, xmax])
   ax2.set_ylim([0.0, ymax])

   ax3.bar(x, spec30, width = wid, color= cmap, edgecolor = cmap)
   ax3.set_xticklabels([])
   ax3.set_xlim([0, xmax])
   ax3.set_ylim([0.0, ymax])

   ax4.bar(x, spec40, width = wid, color= cmap, edgecolor = cmap)
   ax4.set_xticklabels([])
   ax4.set_xlim([0, xmax])
   ax4.set_ylim([0.0, ymax])

   ax5.bar(x, spec50, width = wid, color= cmap, edgecolor = cmap)
   ax5.set_xticklabels(xticks)
   ax5.set_xlim([0, xmax])
   ax5.set_ylim([0.0, ymax])

   ax6.bar(x, spec11, width = wid, color= cmap, edgecolor = cmap)
   ax6.set_xticklabels([])
   ax6.set_xlim([0, xmax])
   ax6.set_ylim([0.0, ymax])

   ax7.bar(x, spec21, width = wid, color= cmap, edgecolor = cmap)
   ax7.set_xticklabels([])
   ax7.set_xlim([0, xmax])
   ax7.set_ylim([0.0, ymax])

   ax8.bar(x, spec31, width = wid, color= cmap, edgecolor = cmap)
   ax8.set_xticklabels([])
   ax8.set_xlim([0, xmax])
   ax8.set_ylim([0.0, ymax])

   ax9.bar(x, spec41, width = wid, color= cmap, edgecolor = cmap)
   ax9.set_xticklabels([])
   ax9.set_xlim([0, xmax])
   ax9.set_ylim([0.0, ymax])

   ax10.bar(x, spec51, width = wid, color= cmap, edgecolor = cmap)
   ax10.set_xticklabels(xticks)
   ax10.set_xlim([0, xmax])
   ax10.set_ylim([0.0, ymax])

   ax11.bar(x, spec12, width = wid, color= cmap, edgecolor = cmap)
   ax11.set_xticklabels([])
   ax11.set_xlim([0, xmax])
   ax11.set_ylim([0.0, ymax])

   ax12.bar(x, spec22, width = wid, color= cmap, edgecolor = cmap)
   ax12.set_xticklabels([])
   ax12.set_xlim([0, xmax])
   ax12.set_ylim([0.0, ymax])

   ax13.bar(x, spec32, width = wid, color= cmap, edgecolor = cmap)
   ax13.set_xticklabels([])
   ax13.set_xlim([0, xmax])
   ax13.set_ylim([0.0, ymax])

   ax14.bar(x, spec42, width = wid, color= cmap, edgecolor = cmap)
   ax14.set_xticklabels([])
   ax14.set_xlim([0, xmax])
   ax14.set_ylim([0.0, ymax])

   ax15.bar(x, spec52, width = wid, color= cmap, edgecolor = cmap)
   ax15.set_xticklabels(xticks)
   ax15.set_xlim([0, xmax])
   ax15.set_ylim([0.0, ymax])


   if mu == 0.1:
      atext = -3.8
      plt.text(atext,5.8,"a = 0.001", verticalalignment="center", rotation = 90)
      plt.text(atext,4.45,"a = 0.01", verticalalignment="center", rotation = 90)
      plt.text(atext,3.15,"a = .1", verticalalignment="center", rotation = 90)
      plt.text(atext,1.85,"a  = .5", verticalalignment="center", rotation = 90)
      plt.text(atext,.55,"a  = .9", verticalalignment="center", rotation = 90)

      ftext = -3.65
      plt.text(ftext,5.8,"$f_{var}$", verticalalignment="center", rotation = 90)
      plt.text(ftext,4.45,"$f_{var}$", verticalalignment="center", rotation = 90)
      plt.text(ftext,3.15,"$f_{var}$", verticalalignment="center", rotation = 90)
      plt.text(ftext,1.85,"$f_{var}$", verticalalignment="center", rotation = 90)
      plt.text(ftext,.55,"$f_{var}$", verticalalignment="center", rotation = 90)


      plt.text(-2.8,6.6,"n = 0", verticalalignment="center", rotation = 0)
      plt.text(-1.15,6.6,"n = 1", verticalalignment="center", rotation = 0)
      plt.text(.65,6.6,"n = 2", verticalalignment="center", rotation = 0)

      plt.text(-2.65,-.34,"g", verticalalignment="center", rotation = 0)
      plt.text(-1,-.34,"g", verticalalignment="center", rotation = 0)
      plt.text(.75,-.34,"g", verticalalignment="center", rotation = 0)

   else:

      atext = -3.5
      plt.text(atext,5.8,"a = 0.001", verticalalignment="center", rotation = 90)
      plt.text(atext,4.48,"a = 0.01", verticalalignment="center", rotation = 90)
      plt.text(atext,3.15,"a = .1", verticalalignment="center", rotation = 90)
      plt.text(atext,1.85,"a  = .5", verticalalignment="center", rotation = 90)
      plt.text(atext,.55,"a  = .9", verticalalignment="center", rotation = 90)

      ftext = -3.35
      plt.text(ftext,5.8,"$f_{var}$", verticalalignment="center", rotation = 90)
      plt.text(ftext,4.45,"$f_{var}$", verticalalignment="center", rotation = 90)
      plt.text(ftext,3.15,"$f_{var}$", verticalalignment="center", rotation = 90)
      plt.text(ftext,1.85,"$f_{var}$", verticalalignment="center", rotation = 90)
      plt.text(ftext,.55,"$f_{var}$", verticalalignment="center", rotation = 90)


      plt.text(-2.6,6.6,"n = 0", verticalalignment="center", rotation = 0)
      plt.text(-1,6.6,"n = 1", verticalalignment="center", rotation = 0)
      plt.text(.55,6.6,"n = 2", verticalalignment="center", rotation = 0)

      plt.text(-2.5,-.33,"g", verticalalignment="center", rotation = 0)
      plt.text(-.9,-.33,"g", verticalalignment="center", rotation = 0)
      plt.text(.65,-.33,"g", verticalalignment="center", rotation = 0)
  
   

   plt.text(-1.25,7.4,"$\mu_0$ = " +str(mu), fontsize = 15,\
               verticalalignment="center", rotation = 0)




   plt.subplots_adjust(right = .9, top = .825, bottom =.175, wspace = .2)
   #outfile = 'perturb/stack_a'+str(a)+'_'+str(ptype)+'temp.pdf'
   plt.show()
   #plt.savefig(outfile)
   #plt.clf()

plot_g_stack(1, .7)

