import numpy as np
import pylab as plt
from scipy import interpolate
import math
import cPickle as pickle

plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['font.family'] = "serif"
plt.rcParams['font.serif'] = "times"
plt.rcParams['axes.unicode_minus'] = False
plt.rcParams['font.size'] = 8
plt.rcParams['text.usetex'] = 'True'
plt.rcParams['xtick.major.size'] = 2
plt.rcParams['ytick.major.size'] = 2

filename = "outputs/dexter33.txt"
infile = open(filename, 'r')

res = pickle.load(infile) 
ipmax = pickle.load(infile)
a = pickle.load(infile)
mu_o = pickle.load(infile)
old_coord = pickle.load(infile)
k = pickle.load(infile)
hit = pickle.load(infile)
g = pickle.load(infile)
emcos = pickle.load(infile)

temp1 = 1.0 + math.pow(1.0 - a**2, 1.0/3.0)*(math.pow(1.0+a, 1.0/3.0)\
           + math.pow(1.0-a, 1.0/3.0))
temp2 = math.sqrt(3.0*a**2 + temp1**2)
   
risco = 3.0 + temp2 - math.sqrt((3.0-temp1)*(3.0+temp1 + 2.0*temp2))

alpha_old = np.arange(res)
beta_old = np.arange(res)

x_coord = np.ndarray(shape=(res,res), dtype=float)
y_coord = np.ndarray(shape=(res,res), dtype=float)

r = old_coord[:,:,1]
phi = old_coord[:,:,3]

# Creating a matrix of (x,y) values given r and phi
for i in range(res):
   for j in range(res):
      x_coord[i][j] = r[i][j]*math.cos(phi[i][j])
      y_coord[i][j] = r[i][j]*math.sin(phi[i][j])


x2 = np.ndarray(shape=(res/2,res/2),dtype = float)
y2 = np.ndarray(shape=(res/2,res/2),dtype = float)
x3 = np.ndarray(shape=(res/2,res/2),dtype = float)
y3 = np.ndarray(shape=(res/2,res/2),dtype = float)
x4 = np.ndarray(shape=(res/2,res/2),dtype = float)
y4 = np.ndarray(shape=(res/2,res/2),dtype = float)

r2 = np.ndarray(shape=(res/2,res/2),dtype = float)
r3 = np.ndarray(shape=(res/2,res/2),dtype = float)
r4 = np.ndarray(shape=(res/2,res/2),dtype = float)

x1 = x_coord[:res/2][:res/2]
y1 = y_coord[:res/2][:res/2]
r1 = r[:res/2][:res/2]
for i in range(res/2):
   for j in range(res/2):
      x2[i][j] = x_coord[i][j+res/2]
      x3[i][j] = x_coord[i+res/2][j]
      x4[i][j] = x_coord[i+res/2][j+res/2]
      y2[i][j] = y_coord[i][j+res/2]
      y3[i][j] = y_coord[i+res/2][j]
      y4[i][j] = y_coord[i+res/2][j+res/2]
      r2[i][j] = r[i][j+res/2]
      r3[i][j] = r[i+res/2][j]
      r4[i][j] = r[i+res/2][j+res/2]

spacing = 7  # lower spacing = higher resolution
temp = np.arange(0, res/2, spacing)


#x = np.ndarray(shape=(size,size), dtype=float)
#y =np.ndarray(shape=(size,size), dtype=float)
#xx =np.ndarray(shape=(size,size), dtype=float) 
#yy = np.ndarray(shape=(size,size), dtype=float)


for i in range(len(temp)):
   x = []
   y = []
   xx = []
   yy = []
   x_4 = []
   y_4 = []
   xx_4 = []
   yy_4 = []
   x_2 = []
   y_2 = []
   xx_2 = []
   yy_2 = []
   x_3 = []
   y_3 = []
   xx_3 = []
   yy_3 = []
   
   for j in range(len(temp)):
      if r1[temp[i],temp[j]] > risco:
        # quadrant 1
	 x.append(-x1[temp[i],temp[j]])
         y.append(y1[temp[i],temp[j]])
      if r1[temp[j],temp[i]] > risco:
         xx.append(-x1[temp[j],temp[i]])
         yy.append(y1[temp[j],temp[i]])

      # quadrant 2
      if r2[temp[i],temp[j]] > risco:
         x_2.append(-x2[temp[i],temp[j]])
         y_2.append(y2[temp[i],temp[j]])
      if r2[temp[j],temp[i]] > risco:    
         xx_2.append(-x2[temp[j],temp[i]])
         yy_2.append(y2[temp[j],temp[i]])
   
        # quadrant 3
      if r3[temp[i],temp[j]] > risco:
         x_3.append(-x3[temp[i],temp[j]])
         y_3.append(y3[temp[i],temp[j]])
      if r3[temp[j],temp[i]] > risco:
         xx_3.append(-x3[temp[j],temp[i]])
         yy_3.append(y3[temp[j],temp[i]])

        # quadrant 4
      if r4[temp[i],temp[j]] > risco:
         x_4.append(-x4[temp[i],temp[j]])
         y_4.append(y4[temp[i],temp[j]])
      if r4[temp[j],temp[i]] > risco:
         xx_4.append(-x4[temp[j],temp[i]])
         yy_4.append(y4[temp[j],temp[i]])

   plt.plot(y, x, linewidth = 0.5, color = 'black') 
   plt.plot(yy, xx, linewidth = 0.5, color = 'black')
   plt.plot(y_2, x_2, linewidth = 0.5, color = 'black')
   plt.plot(yy_2, xx_2, linewidth = 0.5, color = 'black')
   plt.plot(y_3, x_3, linewidth = 0.5, color = 'black')
   plt.plot(yy_3, xx_3, linewidth = 0.5, color = 'black')
   plt.plot(y_4, x_4, linewidth = 0.5, color = 'black')
   plt.plot(yy_4, xx_4, linewidth = 0.5, color = 'black')   

s = 20
plt.axis([-s,s,-s,s])
plt.axes().set_aspect('equal')
plt.xlabel('$\\alpha$')
plt.ylabel('$\\beta$')
plt.show()
      

#lev = np.arange(-40, 40, 2)
#plt.contour(-alpha, -beta,-x_coord, levels = lev)
#plt.contour(-alpha, -beta, -y, levels = lev)
#plt.contour(a, levels=lev)
#plt.contour(b, levels=lev)
#plt.show()
   

