#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "rtr.h"
#include "kerr.h"
#include "arraytrace.h"
#include <string.h>

int main(int argc, char *argv[])
{
  int res, Mres;
  double ipmax, a, mu_o;
  double ***x, ***k;
  int **hit;
  double **g, **emcos, **M;
  int i, j;
  int count;

  char outfilenameg[100];
  char outfilenamei[100];
  char infilename[100];

  FILE *gfile, *ifile;

  if(argc<4)
  {
     fprintf(stdout, "usage: %s <infilename> <outfilename.g> <outfilename.i> \n\
     Outputs:<outfilename>.g <outfilename>.i files\n", argv[0]);
     return 1;
  }
  strcpy(infilename, argv[1]);
  strcpy(outfilenameg, argv[2]);
  strcpy(outfilenamei, argv[3]);

  count = Input_rtr(infilename, &res, &Mres, &ipmax, &a, &mu_o, &x, &k, 
                    &hit, &g, &emcos, &M);
  fprintf(stderr, "read %d bytes from %s\n", count, infilename);
   
   
  gfile = fopen(outfilenameg, "w");
  ifile = fopen(outfilenamei, "w");

  for(i=0;i<Mres;i++)
  {
     for(j=0;j<Mres;j++)
     {
        fprintf(stderr, "%d,%d\n", i, j);
        fprintf(gfile, "%E ", g[i][j]);
        fprintf(ifile, "%E ", M[i][j]*pow(g[i][j], 4.0)*pow(x[i][j][1], -2.0));
     }
     fprintf(gfile, "\n");
     fprintf(ifile, "\n");
  }

  fclose(gfile);
  fclose(ifile);
  return 0;
}
