#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "arraytrace.h"
#include "kerr.h"
#include "nrutil.h"
#include "raytrace.h"
#include "an_math.h"
#include "rtr.h"
#include <string.h>

int main(int argc, char *argv[])
{
  int res, Mres;
  double ipmax, a, mu_o;
  double ***x, ***k;
  int **hit;
  double **g, **emcos, **M;
  int i, j, l;
  int count;
  
  char filename[100];
  
  if(argc < 6)
  {
     fprintf(stdout, "usage: %s <res> <ipmax> <a> <mu_o> <rtr filename>\nWrites\
                     parameters, x, k, g, emcos, and M to a file\n", argv[0]);
     return 1;
  }

  res = atoi(argv[1]);
  ipmax = atof(argv[2]);
  a = atof(argv[3]);
  mu_o = atof(argv[4]);
  strcpy(filename, argv[5]);
  
  Mres = res-2;
  
  x = malloc(sizeof(double**)*(res));
  k = malloc(sizeof(double**)*(res));
  hit = malloc(sizeof(int*)*(res));
  for(i=0; i< res; i++)
  {
     x[i] = malloc(sizeof(double*)*(res));
     k[i] = malloc(sizeof(double*)*(res));
     hit[i] = malloc(sizeof(int)*(res));
     for(j=0; j< res; j++)
     {
        x[i][j] = init_4v();
        k[i][j] = init_4v();
     }
  }
  
  
  g = malloc(sizeof(double*)*(res-2));
  emcos = malloc(sizeof(double*)*(res-2));
  M = malloc(sizeof(double*)*(res-2));
  for(i=0; i < Mres; i++)
  {
     g[i] = malloc(sizeof(double)*(res-2));
     emcos[i] = malloc(sizeof(double)*(res-2));
     M[i] = malloc(sizeof(double)*(res-2));
  }
  
  
  Calc_rtr(ipmax, res, a, mu_o, x, k, hit);
  fprintf(stderr, "Calc_rtr done\n");
  
  Calc_ImageArrays(res, a, mu_o, x, k, hit, g, emcos, M);
  fprintf(stderr, "Calc_ImageArrays done\n");

  count = Output_rtr(filename, res, Mres, ipmax, a, mu_o, x, k, hit, g, emcos, M);
  fprintf(stdout, "wrote %d bytes to %s\n", count, filename);


  for(i=0;i<res;i++)
  {
     for(j=0; j<res;j++)
     {
        free(x[i][j]);
        free(k[i][j]);
     }
     free(x[i]);
     free(k[i]);
  }
  
  for(i=0; i<res-2; i++)
  {
     free(g[i]);
     free(emcos[i]);
     free(M[i]);
  }
  free(x);
  free(k);
  free(g);
  free(emcos);
  free(M);

  return 0;
}
