
//calculate impact parameters from other parameters
extern double ip_alpha(double ll, double q2, double a, double mu_o);
extern double ip_beta(double ll, double q2, double a, double mu_o);

//calculate lambda from impact parameters
extern double llambda(double alpha, double beta, double a, double mu_o);

//calculate carter constant from impact parameters
extern double qsquared(double alpha, double beta, double a, double mu_o);

//kepler 4-velocity of the disk at position x
extern double *Kepler4v(double a, double* x);

//normal vector to the disk at position x
extern double *discNormal(double a, double *x);

//Calculate the redshift factor at position x_em -> position xobs
extern double Calc_g(double a, double* x_em, double* k_em, double* u_em);

//Calculate the emission angle cosine at position x_em
extern double Calc_emcos(double a, double *x_em, 
		  double *k_em, double *u_em, double *norm);


/*int Calc_rtr(double ipmax, int res, double a, double mu_o, 
 *  double ***x, double ***k, int **hit)
 *
 * Input: ipmax maxiumum impaxt parameter
 *        res resolution
 *        a black hole spin in units of M
 *        mu_o cosine of the inclination angle
 * 
 * Output: x[res][res] is an array of 4-vectors positions at emission
 *         k[res][res] is an array of 4-vectors wavevectors at emission
 *         hit[res][res] is an array of integers, indicating a disc 
 *                       interesection
 *   assume the output vectors are initialized before calling this
 */

extern int Calc_rtr(double ipmax, int res, double a, 
	     double mu_o, double ***x, double ***k, int **hit);

/*
 * int Calc_ImageArrays(int res, double a, double mu_o, 
 *                        double ***x, double ***k, int **hit, 
 *                        double ***g, double ***emcos, double ***M)
 *
 * Inputs: res resolution of the alpha/beta arrays
 *          a  black hole spin parameter in units of M
 *         mu_0  cosine of the inclination angle
 *          x   2-d array of position 4-vectors at emission
 *          k   2-d array of wave-4vectrs at the emission
 *         hit  2-d array of integers indicating intersection with the disc
 * 
 * Ouputs: g  2-d array of doubles, for the redshift (res-2,res-2)
 *         emcos 2-d array of doubles, for the cosine of the emission angle
 *          M 2-d array of doubles for the magnification/lensing of each pixel
 */

extern int Calc_ImageArrays(int res, double a, double mu_o, double ***x, double ***k, int **hit, double **g, double **emcos, double **M);

