#ifndef AN_MATH_H
#define AN_MATH_H

extern double rf(double x, double y, double z);
extern double ellf(double phi, double ak);
extern double elle(double phi, double ak);
extern double ellpi(double phi, double en ,double ak);

extern _Complex double rfa(double x, _Complex double y, double z);
extern double cuberoot(double x);
extern void sncndn(double uu, double emmc, double *sn, double *cn, double *dn);
extern double c_abs(_Complex double z);
extern double c_abs2 (_Complex double z);
extern _Complex double cinv (_Complex double a);
extern _Complex double csqrt (_Complex double a);
extern _Complex double casin_real (double a);
extern _Complex double casin (_Complex double a);
extern _Complex double csin(_Complex double a);
extern void csncndn(_Complex double zz, _Complex double emmc,
                    _Complex double *sn, _Complex double *cn, 
                    _Complex double *dn);
extern  _Complex double cellf(_Complex double sinphi, _Complex double m);
extern  _Complex double celle(_Complex double sinphi, _Complex double m);

extern _Complex double crf(_Complex double x, _Complex double y, _Complex double z);
extern _Complex double crc(_Complex double x, _Complex double y);
extern _Complex double crj(_Complex double x, _Complex double y, _Complex double z, _Complex double p);
extern _Complex double cellpi(_Complex double sinphi, _Complex double k, _Complex double n);

#define CONJ(a) (__real__ (a) - 1.0i*(__imag__ (a)))

static _Complex double csqrarg;
#define CSQR(a) (c_abs(csqrarg=(a)) == 0.0 ? 0.0 : csqrarg*csqrarg)


#define CSIGN(a,b) ((b) >= 0.0 ? (a) : -(a))
#endif

