Program calc_excess_isotherms
!
! Main program for calculating the excess amount adsorbed using the Peng Robinson
! EOS. Full details of the method can be found in T.Duren et al, Langmuir,
! 20, 2683 (2004). The input for this program is a music post file. Although the 
! Peng Robinson EOS is written for binary mixtures as well as pure components, it 
! is better to use a different version of this program for mixtures. That program
! uses a music logfile as input and allows better error estimation for the individual
! components. Currently, the output is the excess amount adsorbed in molecules / uc,
! mol / g and cm3 / cm3. Changing this main program slightly, you can calculate the
! excess amount adsorbed in whatever unit you need by converting it from molecules / uc. 
!
Use adsorbent
Use molecules_prop
Use fuga_mod


IMPLICIT NONE

Character(len = 120)                             :: file_press, file_post
Character(len = 120)                             :: file_output, file_xmgrace
Character(len = 25), Dimension(:), Allocatable   :: music_name
Character(len = 25)                              :: name_adsorbent, name
Character(len = 7)                               :: name1
Character(len = 4)                               :: name2
Integer                                          :: i, j, no_points
Integer                                          :: ierror
Real(kind = realkind), Dimension(:), Allocatable :: pressure, fuga
Real(kind = realkind), Dimension(:,:), Allocatable :: rho_bulkfluid
Real(kind = realkind), Dimension(:,:), Allocatable :: abs_average, error
Real(kind = realkind), Dimension(:,:), Allocatable :: excess_av
Real(kind = realkind)                            :: dummy, x1


name2 = '.dat'
Read(*,'(/,a)') file_press
Read(*,'(/,a)') file_post
Read(*,'(/,a)') file_output

Open(40, file = file_press, Status = 'OLD', IOSTAT=ierror)
If(ierror /= 0) THEN
  Write(*,*) file_press, ' does not exist'
  STOP
END IF
Open(20, file = file_post, Status = 'OLD', IOSTAT=ierror)
If(ierror /= 0) THEN
  Write(*,*) file_post, ' does not exist'
  STOP
END IF
Open(80, file = file_output)

Write(80,*) 'input: ',file_post
Write(*,*) 'post file to be analysed: ',file_post
Read(*,'(/,I3)') no_species

If(no_species > 1) Then
   write(*,*) 'This version uses a post file as input'
   write(*,*) 'Although in general, it can be used for binary mixtures, it is recommended'
   write(*,*) 'that you use a different variant of this program that uses a logfile as'
   write(*,*) 'input. This allows a better error calculation for the individual components'
   write(*,*) 'of the mixture. Before you continue using this program for binary mixtures'
   write(*,*) 'you have to adapt the calculation of the excess amount adsorbed and the output'
   STOP
END IF

Allocate(name_spec(no_species), music_name(no_species)) 
Allocate(fugacity(no_species))

Do i = 1,no_species
   Read(*,'(/,a)') name_spec(i)
   Write(80,*) 'name: ',name_spec(i)
End Do

Read(*,'(/,F8.2)') temp
Read(*,'(/,a)') name_adsorbent
Write(80,*) 'adsorbent: ', NAME_ADSORBENT

name = TRIM(name_adsorbent)

CALL adsorbent_properties(name)
Call fluid_properties

If(P_0(1,1) /= 0.0 .And. temp - p_0(2,1) > 1.) THEN
   Write(*,*) 'wrong saturation pressure for given temperature'
   Write(*,*) 'change value in fluid_properties'
   STOP
END IF

Write(80,*) 'temperature in K: ', temp
Write(80,*) 'saturation pressure, P0, in kPa: ', P_0(1,1)/1.E3
Write(80,*)  

Read(40,*) music_name
Read(40,*) no_points
Allocate(y_gas(2,no_points),press(no_points), fuga(no_points))
Allocate(abs_average(no_species,no_points), error(no_species,no_points))
Allocate(excess_av(no_species,no_points), rho_bulkfluid(no_species,no_points))

Read(40,*) press
press = press * 1000.

If(no_species == 2) THEN
     Read(40,*) y_gas(1,:)
     y_gas(2,:) = 1. - y_gas(1,:)
Else
   y_gas(1,:) = 1.0
   y_gas(2,:) = 0.0
End If

Do j = 1, no_species
 Do i = 1, no_points
    Call calc_fugacity_1(i, j, rho_bf)
    fuga(i) = fugacity(j)
    rho_bulkfluid(j,i) = rho_bf
 End Do
END DO

Call adsorption_isotherm(abs_average, error, no_species,no_points, music_name)

excess_av = abs_average - rho_bulkfluid * vol_bf

press = press / 1000.
fuga = fuga / 1000.

If(no_species == 1) THEN

   Write(80,*) 'pressure  fugacity   N_abs      error     N_ex        N_ex      N_ex'
   Write(80,*) '  kPa        kPa    molec/uc  molec/uc  molec/uc     mmol/g   cm3(STP)/cm3'
   write(*,*)
   Write(*,*) 'pressure  fugacity   N_abs      error     N_ex        N_ex      N_ex'
   Write(*,*) '  kPa        kPa    molec/uc  molec/uc  molec/uc     mmol/g   cm3(STP)/cm3'

END IF

! 
! Adapt the following lines if you would like the output in different units. excess_av
! is the excess amount adsorbed in molecules / uc.


Do i = 1, no_points

   Write(80,'(2(ES10.3),5(F10.3))') press(i), fuga(i), abs_average(1,i), error(1,i),  excess_av(1,i), &
                      excess_av(1,i)/mass_uc,excess_av(1,i) * 22.4E3/mass_uc/1000. * chrys_dens
   Write(*,'(2(ES10.3),5(F10.3))') press(i), fuga(i), abs_average(1,i), error(1,i),  excess_av(1,i), &
                      excess_av(1,i)/mass_uc,excess_av(1,i) * 22.4E3/mass_uc/1000. * chrys_dens

End do

END Program






