MODULE fuga_mod
!
! Contains data for calculating the fugacity for different pressures
!
! Acc_factor		real    accentric factor
! k			real 	binary parameter in fugacity calculation
! T_crit		real    critical temperature
! Temp			real    temperature
! beta			real    1 / (k_b Temp)
! P_crit		real    critical pressure
! Press(i)              real    Pressure 
! Presspoint            integer number of pressure points to calculate the
!				adsorption isotherm
! P_0                   real    saturation pressure
! fugacity              real    fugacity
! activ_vol		real	activity * volume of pore
! vol_sim_cell          real    volume of simulation cell
! vol_bulk_fluid        real    volume in simulation cell that the bulk
!                               fluid would occupy
! rho_bulk_fluid	real    density of bulk fluid
! rho_excess            real    excess density 

 Use diverses
 IMPLICIT NONE
 SAVE
!
 REAL(kind = realkind)                             :: Temp, beta
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: Acc_factor
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: P_crit, T_crit
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: fugacity, activ_vol
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: Press
 REAL(kind = realkind), DIMENSION(:,:), ALLOCATABLE:: k
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: no_excess,no_bulk_fluid
 REAL(kind = realkind)                             :: vol_sim_cell
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: vol_bulk_fluid
 Real(kind = realkind), Dimension(:,:), Allocatable:: p_0
 INTEGER                                           :: Presspoint
!
 END MODULE fuga_mod
	
