SUBROUTINE fluid_properties
!
! This subroutine contains a database of the critical data of fluid
! molecules.
!
! data for CH4 and CF4: Prausnitz et al 'Molecular Thermodynamics
! of fluidf-phase equilibria', Prentice-Hall 1986
! data for He: Reid, Prausnitz, Poling 'The properties of gases and
! liquids', Mc Graw-Hill, 1987
!
USE diverses
USE fuga_mod
USE molecules_prop
!
IMPLICIT NONE
!
INTEGER     :: i
!
! Stored / defined  in module fuga_mod
!
! Acc_factor            real    accentric factor
! T_crit                real    critical temperature in K
! P_crit                real    critical pressure in Pa
! k(i,j)		real 	binary coefficient in Peng-Robinson EOS
! P_0(2,i)              real    saturation pressure in Pa (P_0(1,i)) and
!                               corresponding temperature in K (P_0(2,i))
!
 ALLOCATE(acc_factor(no_species), P_crit(no_species), T_crit(no_species))
 ALLOCATE(k(no_species,no_species))
 Allocate(P_0(2, no_species))

 P_0 = 0.0
!

DO i = 1, no_species
!
   SELECT CASE(name_spec(i))
    CASE('CH4') 
          Acc_factor(i) = 0.008
          T_crit(i) = 190.5
          P_crit(i) = 4.61e6
    CASE('C2H6')   
          Acc_factor(i) = 0.099 
          T_crit(i) = 305.4
          P_crit(i) = 4.88e6
    CASE('C3H8')   
          Acc_factor(i) = 0.153 
          T_crit(i) = 369.8
          P_crit(i) = 4.25e6
   CASE('C4H10')   
          Acc_factor(i) = 0.199 
          T_crit(i) = 425.2
          P_crit(i) = 3.80e6
    CASE('C5H12')   
          Acc_factor(i) = 0.251
          T_crit(i) = 469.7
          P_crit(i) = 3.37e6
    CASE('C6H14')   
          Acc_factor(i) = 0.299 
          T_crit(i) = 507.5
          P_crit(i) = 3.01e6
    CASE('C7H16')   
          Acc_factor(i) = 0.349 
          T_crit(i) = 540.3
          P_crit(i) = 2.74e6
    CASE('C6H12')
          Acc_factor(i) = 0.212 
          T_crit(i) = 553.5
          P_crit(i) = 4.07e6
    CASE('CH2Cl2')
          acc_factor(i) = 0.199
          T_crit(i) = 510.
          P_crit(i) = 6.3e6
    CASE('CHCl3')
          acc_factor(i) = 0.191
          T_crit(i) = 536.4
          P_crit(i) = 5.37e6
    CASE('CCl4')
          acc_factor(i) = 0.193
          T_crit(i) = 556.4
          P_crit(i) = 4.56e6
    CASE('CF4')
          acc_factor(i) = 0.191
          T_crit(i) = 227.6
          P_crit(i) = 3.74e6
    CASE('He')
          acc_factor(i) = -0.387
          T_crit(i) = 5.19
          P_crit(i) = 2.27e5
    CASE('Xe')
          acc_factor(i) = 0.002
          T_crit(i) = 289.7
          P_crit(i) = 5.84e6
    CASE('SF6')
          acc_factor(i) = 0.257 
          T_crit(i) = 318.71
          P_crit(i) = 3.76e6
    CASE('N2')
          acc_factor(i) = 0.039
          T_crit(i) = 126.2
          P_crit(i) = 3.39e6
          P_0(1,i) = 96606.9
          P_0(2,i) = 77.0  
    CASE('Ar')
          acc_factor(i) = 0.001
          T_crit(i) = 150.8
          P_crit(i) = 4.87e6
    CASE('H2')
          acc_factor(i) = -0.216
          T_crit(i) = 33.0
          P_crit(i) = 1.29e6
    CASE default
         write(*,*) 'Fluid molecule ', name_spec(i), ' not in database'
         write(*,*) 'Add in subroutine fluid_properties.f90'
   END SELECT
END DO
!
 k = 0.0
! methane / ethane Prausnitz page 471
IF(no_species == 2) THEN
   If(name_spec(1) == 'CH4' .And. name_spec(2) == 'C2H6') Then
      k(1,2) = 0.0021 
      k(2,1) = 0.0021
   END IF
END IF
!
!  
END SUBROUTINE fluid_properties 
