Subroutine adsorption_isotherm(average, error, no_species,no_points, music_name)
!
! This subroutine reads the data from a music post file. Please note that the 
! number of blocks should be 20. It then calculates the average of the absolute
! amount adsorbed and the corresponding error using the Student t-distribution
! with 20 blocks.
!
USE diverses

IMPLICIT NONE

Integer                                    :: i, i_energy, block
Integer                                    :: no_points,no_species
Real(kind = realkind), Dimension(no_species) :: standard_dev
Real(kind = realkind)                      :: dummy
Real(kind = realkind), Dimension(no_species,20) :: av_block
Real(kind = realkind), Dimension(no_species,no_points):: error, average
Character(len = 20)                         :: cummy1, cummy2, name
Character(len = 20), Dimension(no_species)  :: music_name

average = 0.0
IF(no_species == 1) THEN
Do i = 1, no_points
   Do i_energy = 1, 36
      Read(20,*) 
   End do
   Read(20,*) cummy1, cummy2, name
   IF(name .EQ. music_name(1)) THEN
     Do block = 1, 20
        Read(20,*) dummy, dummy, av_block(1,Block), dummy
        average(1,i) = average(1,i) + av_block(1,Block)
     End Do
     Do i_energy = 1, 6
        Read(20,*)
     END DO
   ELSE
     Do i_energy = 1, 2
      Read(20,*) 
     End do
     Read(20,*) cummy1, cummy2, name
     IF(name .EQ. music_name(1)) THEN

        Do block = 1, 20
           Read(20,*) dummy, dummy, av_block(1,Block), dummy
           average(1,i) = average(1,i) + av_block(1,Block)
        End Do
        Do i_energy = 1, 6
           Read(20,*)
        END DO
     ELSE
        Do i_energy = 1, 6
          Read(20,*)
        END DO
        Do block = 1, 20
          Read(20,*) dummy, dummy, av_block(1,Block), dummy
          average(1,i) = average(1,i) + av_block(1,Block)
        End Do
     END IF
   END IF
   standard_dev = 0.0
   average(1,i) = average(1,i) / 20.
   Do Block = 1, 20
      standard_dev = standard_dev + (av_block(1,Block) - average(1,i))**2
   End Do
   standard_dev = Sqrt(standard_dev)/19.
   error(1,i) = 0.4673 * standard_dev(1)
END DO
ELSE
Do i = 1, no_points
   Do i_energy = 1, 44
      Read(20,*) 
   End do
   Read(20,*) cummy1, cummy2, name
   If(name /= music_name(1)) THEN
     Do i_energy = 1,2
        Read(20,*)
     END DO
   Read(20,*) cummy1, cummy2, name
   END IF
Write(*,*) cummy1, cummy2, name
   IF(name .EQ. music_name(1)) THEN
     Do block = 1, 20
        Read(20,*) dummy, dummy, av_block(1,Block), dummy
        average(1,i) = average(1,i) + av_block(1,Block)
     End Do
     Do i_energy = 1,4
        Read(20,*) 
     END DO
     Do block = 1, 20
        Read(20,*) dummy, dummy, av_block(2,Block), dummy
        average(2,i) = average(2,i) + av_block(2,Block)
     End Do
     Do i_energy = 1, 6
        Read(20,*)
     END DO
   ELSe
     write(*,*) 'check adsorption_isotherm.f90, reading of data'
     stop
   END IF
   standard_dev = 0.0
   average(:,i) = average(:,i) / 20.
   Do Block = 1, 20
      standard_dev = standard_dev + (av_block(:,Block) - average(:,i))**2
   End Do
   standard_dev = Sqrt(standard_dev)/19.
   error(:,i) = 0.4673 * standard_dev     
   write(*,*) i, average(:,i)
END DO
END IF
!
END SUBROUTINE




