Subroutine adsorbent_properties(name)
!
! This subroutines defines the properties of the adsorbent. The crystal 
! density and the mass of the unit cell are used to convert the amount
! adsorbed in molecules / unit cell to other units to allow comparison
! with experimental data. 
!
! The excess amount adsorbed, N_ex, is defined as
! 
! N_ex = N_absolute - rho * vol_bf
!
! where rho is the density of the bulk gas phase and vol_bf is the pore
! volume. We normally calculate the pore volume from the second virial 
! coefficient but there are other ways of doing this. Please note, that
! this value will depend on how you calculate it. In our case, the value
! depends on the force field as the second virial coefficient is calculated
! from the interaction of a single helium molecule with the framework. This
! is why this subroutine is caleed _UFF. See the tutorial for more information.
!
! To use this subroutine for adsorbents other than IRMOF1, just add another
! CASE statement, copying the structure of the one for IRMOF1.
!
! Variables used:
!
! name              character                   name of the adsorbent
! chrys_dens        double precision            crystal density of framework
!                                               in g / cm3
! mass_uc           double precision            molecular weight of framework
!                                               in g / mol
! vol_bf            double precision            pore volume in A3
!


Use adsorbent
Use molecules_prop

IMPLICIT NONE

Character(len = 20) :: name

!
SELECT CASE(name)
  CASE('IRMOF1')
    mass_uc = 6155.8
    vol_bf = 13916.
    chrys_dens = 0.59
  CASE('Cd_MOF_121')
    mass_uc = 3316.8
    vol_bf = 1484.7
    chrys_dens = 1.5
  CASE default
    Write(*,*) 'Adsorbent: ',name , 'not in database'
    write(*,*) 'add in adsorbent_properties_UFF.f90'
    STOP
END SELECT

mass_uc = mass_uc / 1000.   ! convert to kg / mole

END SUBROUTINE adsorbent_properties
