adsorbent_mod.f90                                                                                   0000644 0565266 0565266 00000000247 11100642674 013650  0                                                                                                    ustar   tduren                          tduren                                                                                                                                                                                                                 MODULE adsorbent
!
USE diverses
!
IMPLICIT NONE
SAVE

Real(kind = realkind) :: mass_uc, vol
Real(kind = realkind) :: rho_bf, vol_bf, chrys_dens


END MODULE adsorbent
                                                                                                                                                                                                                                                                                                                                                         adsorbent_properties_UFF.f90                                                                        0000644 0565266 0565266 00000003653 11100650503 015757  0                                                                                                    ustar   tduren                          tduren                                                                                                                                                                                                                 Subroutine adsorbent_properties(name)
!
! This subroutines defines the properties of the adsorbent. The crystal 
! density and the mass of the unit cell are used to convert the amount
! adsorbed in molecules / unit cell to other units to allow comparison
! with experimental data. 
!
! The excess amount adsorbed, N_ex, is defined as
! 
! N_ex = N_absolute - rho * vol_bf
!
! where rho is the density of the bulk gas phase and vol_bf is the pore
! volume. We normally calculate the pore volume from the second virial 
! coefficient but there are other ways of doing this. Please note, that
! this value will depend on how you calculate it. In our case, the value
! depends on the force field as the second virial coefficient is calculated
! from the interaction of a single helium molecule with the framework. This
! is why this subroutine is caleed _UFF. See the tutorial for more information.
!
! To use this subroutine for adsorbents other than IRMOF1, just add another
! CASE statement, copying the structure of the one for IRMOF1.
!
! Variables used:
!
! name              character                   name of the adsorbent
! chrys_dens        double precision            crystal density of framework
!                                               in g / cm3
! mass_uc           double precision            molecular weight of framework
!                                               in g / mol
! vol_bf            double precision            pore volume in A3
!


Use adsorbent
Use molecules_prop

IMPLICIT NONE

Character(len = 20) :: name

!
SELECT CASE(name)
  CASE('IRMOF1')
    mass_uc = 6155.8
    vol_bf = 13916.
    chrys_dens = 0.59
  CASE('Cd_MOF_121')
    mass_uc = 3316.8
    vol_bf = 1484.7
    chrys_dens = 1.5
  CASE default
    Write(*,*) 'Adsorbent: ',name , 'not in database'
    write(*,*) 'add in adsorbent_properties_UFF.f90'
    STOP
END SELECT

mass_uc = mass_uc / 1000.   ! convert to kg / mole

END SUBROUTINE adsorbent_properties
                                                                                     adsorption_isotherm.f90                                                                             0000644 0565266 0565266 00000006260 11100655533 015123  0                                                                                                    ustar   tduren                          tduren                                                                                                                                                                                                                 Subroutine adsorption_isotherm(average, error, no_species,no_points, music_name)
!
! This subroutine reads the data from a music post file. Please note that the 
! number of blocks should be 20. It then calculates the average of the absolute
! amount adsorbed and the corresponding error using the Student t-distribution
! with 20 blocks.
!
USE diverses

IMPLICIT NONE

Integer                                    :: i, i_energy, block
Integer                                    :: no_points,no_species
Real(kind = realkind), Dimension(no_species) :: standard_dev
Real(kind = realkind)                      :: dummy
Real(kind = realkind), Dimension(no_species,20) :: av_block
Real(kind = realkind), Dimension(no_species,no_points):: error, average
Character(len = 20)                         :: cummy1, cummy2, name
Character(len = 20), Dimension(no_species)  :: music_name

average = 0.0
IF(no_species == 1) THEN
Do i = 1, no_points
   Do i_energy = 1, 36
      Read(20,*) 
   End do
   Read(20,*) cummy1, cummy2, name
   IF(name .EQ. music_name(1)) THEN
     Do block = 1, 20
        Read(20,*) dummy, dummy, av_block(1,Block), dummy
        average(1,i) = average(1,i) + av_block(1,Block)
     End Do
     Do i_energy = 1, 6
        Read(20,*)
     END DO
   ELSE
     Do i_energy = 1, 2
      Read(20,*) 
     End do
     Read(20,*) cummy1, cummy2, name
     IF(name .EQ. music_name(1)) THEN

        Do block = 1, 20
           Read(20,*) dummy, dummy, av_block(1,Block), dummy
           average(1,i) = average(1,i) + av_block(1,Block)
        End Do
        Do i_energy = 1, 6
           Read(20,*)
        END DO
     ELSE
        Do i_energy = 1, 6
          Read(20,*)
        END DO
        Do block = 1, 20
          Read(20,*) dummy, dummy, av_block(1,Block), dummy
          average(1,i) = average(1,i) + av_block(1,Block)
        End Do
     END IF
   END IF
   standard_dev = 0.0
   average(1,i) = average(1,i) / 20.
   Do Block = 1, 20
      standard_dev = standard_dev + (av_block(1,Block) - average(1,i))**2
   End Do
   standard_dev = Sqrt(standard_dev)/19.
   error(1,i) = 0.4673 * standard_dev(1)
END DO
ELSE
Do i = 1, no_points
   Do i_energy = 1, 44
      Read(20,*) 
   End do
   Read(20,*) cummy1, cummy2, name
   If(name /= music_name(1)) THEN
     Do i_energy = 1,2
        Read(20,*)
     END DO
   Read(20,*) cummy1, cummy2, name
   END IF
Write(*,*) cummy1, cummy2, name
   IF(name .EQ. music_name(1)) THEN
     Do block = 1, 20
        Read(20,*) dummy, dummy, av_block(1,Block), dummy
        average(1,i) = average(1,i) + av_block(1,Block)
     End Do
     Do i_energy = 1,4
        Read(20,*) 
     END DO
     Do block = 1, 20
        Read(20,*) dummy, dummy, av_block(2,Block), dummy
        average(2,i) = average(2,i) + av_block(2,Block)
     End Do
     Do i_energy = 1, 6
        Read(20,*)
     END DO
   ELSe
     write(*,*) 'check adsorption_isotherm.f90, reading of data'
     stop
   END IF
   standard_dev = 0.0
   average(:,i) = average(:,i) / 20.
   Do Block = 1, 20
      standard_dev = standard_dev + (av_block(:,Block) - average(:,i))**2
   End Do
   standard_dev = Sqrt(standard_dev)/19.
   error(:,i) = 0.4673 * standard_dev     
   write(*,*) i, average(:,i)
END DO
END IF
!
END SUBROUTINE




                                                                                                                                                                                                                                                                                                                                                calc_fugacity_bin.f90                                                                               0000644 0565266 0565266 00000010156 11100655205 014447  0                                                                                                    ustar   tduren                          tduren                                                                                                                                                                                                                 Subroutine calc_fugacity_1(p,Ads_spec,rho_bulk_fluid)
!
! The subroutine calculates the vapour fugacity using the Peng-Robinson EOS.
! The equations for the pure components  are taken from Sandler "Chemical
! and Engineering Thermodynamics" (1989) page 148, 149, 182, 222, the
! equations for the mixture are taken from Prausnitz et al. "Molecular 
! Thermodynamics of Fluid-Phase Equilibria" (1986). 
! 
!
! fuga_coeff    	real    fugacity coefficient
! Sandler
! kappa         	real    equation 4.7-4
! alphaT        	real    equation 4.7-3
! agreek        	real    equation 4.7-1
! bgreek        	real    equation 4.7-2
! A, B          	real    equation 4.7-5
! alpha, beta, gamma   	real    table 4.4-3
! Prausnitz
! agreek_sys            real 	equation 10.3-14/16
! b_greek_sys		real   	equation 10.3-13/15 (c12 = 0, simple mixture
!				of nonpolar components)
! Conv_Crit     	real	convergence criteria for Newton Rhapson method
! Z0, Z1        	real    approximation of zero, z: compressibility factor
!
! R			real    universial gas constant
! p            input    integer pressure point
! ads_species  input    integer adsorbed species
! 
 USE fuga_mod
 USE molecules_prop
 USE diverses
!
 IMPLICIT NONE
!
 REAL(kind = realkind)                        :: fuga_coeff
 REAL(kind = realkind)                        :: alpha, beta_f, gamma
 REAL(kind = realkind), DIMENSION(no_species) :: kappa, alphaT, agreek, bgreek
 REAL(kind = realkind)                        :: agreek_sys, bgreek_sys
 REAL(kind = realkind)                        :: A, B
 REAL(kind = realkind)                        :: Z0, Z1
 Real(kind = realkind)                        :: sum_za
 Real(kind = realkind), INTENT(OUT)           :: rho_bulk_fluid
 INTEGER                       	              :: i,j, spec
 INTEGER                                      :: p, ads_spec
!
 REAL(kind = realkind), PARAMETER  :: R = 8.314           
 REAL(kind = realkind), PARAMETER  :: Conv_Crit = 1e-5
 Real(kind = realkind), PARAMETER  :: na = 6.022045E23
!
 DO spec = 1, no_species
    kappa(spec) = 0.37464 + 1.54226*acc_factor(spec) - &
                  0.26992*acc_factor(spec)*acc_factor(spec)
    alphaT(spec) = (1 + kappa(spec) * (1 - sqrt(Temp/T_crit(spec))))**2
!
! calculate a (a_greek), b (b_greek) for pure components
!
    agreek(spec) = 0.45724 * (R * T_crit(spec))**2 / P_crit(spec) * alphaT(spec)
    bgreek(spec) = 0.0778 * R * T_crit(spec) / P_crit(spec)
 END DO
!
! calculate the system a and b factors
! 
 agreek_sys = 0.
 bgreek_sys = 0.
 IF (no_species == 1) THEN
   agreek_sys = agreek(1)
   bgreek_sys = bgreek(1)
 ELSE 
   DO i = 1, no_species
     DO j = 1, no_species
       agreek_sys = agreek_sys + &
                    y_gas(i,p)*y_gas(j,p)*Sqrt(agreek(i)*agreek(j))*(1-k(i,j))
     END DO
       bgreek_sys = bgreek_sys + y_gas(i,p)*bgreek(i)
   END DO
 END IF
!
! calculate A and B
!
    A = agreek_sys * Press(p) / (R * Temp)**2
    B = bgreek_sys * Press(p) / R / Temp
!
! calculate alpha, beta, gamma
!
 alpha = B - 1
 beta_f = A - 3*B*B - 2*B
 gamma = -A*B + B*B + B*B*B

!
! Searching for zero using Newton-Rhapson
! Z**3 + alpha*Z**2 + beta_f*Z + gamma = 0
! Z: compressibility facor
!
 Z1 = 1.0
 DO
    Z0 = Z1
    Z1 = Z0 - (Z0**3 + alpha*Z0**2 + beta_f*Z0 + gamma) / (3*Z0**2 + 2*alpha*Z0 &
            +beta_f)
    IF (ABS(Z1 - Z0) < Conv_Crit)  EXIT
 END DO
 IF(Z1 > 1.0) Z1 = 1.0
!
! calculate the sum(aik*zi)
!
 sum_za = 0.0
 DO spec = 1, no_species
    sum_za = sum_za + y_gas(spec,p)*Sqrt(agreek(ads_spec)*agreek(spec))*(1-K(ads_spec,spec))
 END DO
!
! calculate fugacity coefficient
!
 fuga_coeff = EXP(bgreek(ads_spec)/bgreek_sys*(Z1-1) - LOG(Z1 - B) - &
              agreek_sys/(2.*SQRT(2.0)*bgreek_sys*R*temp)* &
              (2*sum_za/agreek_sys-bgreek(ads_spec)/bgreek_sys) &
              * LOG( (Z1+(1+SQRT(2.0))*B)/(Z1+(1-SQRT(2.0))*B)))
!	
 IF(fuga_coeff > 1.) THEN
   write(*,*) ' Something is wrong, the fugacity coefficient is larger than 1.'
   write(*,*) ' Stopped in subrotuine calc_fugacity_bin.f90'
   STOP
 END IF
 fugacity(ads_spec) = fuga_coeff *y_gas(ads_spec,p) * Press(p) 
 rho_bulk_fluid = press(p)/temp/z1/R*na/1.E30*y_gas(ads_spec,p)
!
END SUBROUTINE calc_fugacity_1
                                                                                                                                                                                                                                                                                                                                                                                                                  div_mod.f90                                                                                         0000644 0565266 0565266 00000000262 11100642674 012446  0                                                                                                    ustar   tduren                          tduren                                                                                                                                                                                                                 MODULE diverses
!
! realkind	integer used to define precision of real variables
!
 IMPLICIT NONE
 SAVE
!
 INTEGER, PARAMETER               :: realkind = 8

!
END MODULE diverses
                                                                                                                                                                                                                                                                                                                                              fluid_properties.f90                                                                                0000644 0565266 0565266 00000006535 11763165336 014427  0                                                                                                    ustar   tduren                          tduren                                                                                                                                                                                                                 SUBROUTINE fluid_properties
!
! This subroutine contains a database of the critical data of fluid
! molecules.
!
! data for CH4 and CF4: Prausnitz et al 'Molecular Thermodynamics
! of fluidf-phase equilibria', Prentice-Hall 1986
! data for He: Reid, Prausnitz, Poling 'The properties of gases and
! liquids', Mc Graw-Hill, 1987
!
USE diverses
USE fuga_mod
USE molecules_prop
!
IMPLICIT NONE
!
INTEGER     :: i
!
! Stored / defined  in module fuga_mod
!
! Acc_factor            real    accentric factor
! T_crit                real    critical temperature in K
! P_crit                real    critical pressure in Pa
! k(i,j)		real 	binary coefficient in Peng-Robinson EOS
! P_0(2,i)              real    saturation pressure in Pa (P_0(1,i)) and
!                               corresponding temperature in K (P_0(2,i))
!
 ALLOCATE(acc_factor(no_species), P_crit(no_species), T_crit(no_species))
 ALLOCATE(k(no_species,no_species))
 Allocate(P_0(2, no_species))

 P_0 = 0.0
!

DO i = 1, no_species
!
   SELECT CASE(name_spec(i))
    CASE('CH4') 
          Acc_factor(i) = 0.008
          T_crit(i) = 190.5
          P_crit(i) = 4.61e6
    CASE('C2H6')   
          Acc_factor(i) = 0.099 
          T_crit(i) = 305.4
          P_crit(i) = 4.88e6
    CASE('C3H8')   
          Acc_factor(i) = 0.153 
          T_crit(i) = 369.8
          P_crit(i) = 4.25e6
   CASE('C4H10')   
          Acc_factor(i) = 0.199 
          T_crit(i) = 425.2
          P_crit(i) = 3.80e6
    CASE('C5H12')   
          Acc_factor(i) = 0.251
          T_crit(i) = 469.7
          P_crit(i) = 3.37e6
    CASE('C6H14')   
          Acc_factor(i) = 0.299 
          T_crit(i) = 507.5
          P_crit(i) = 3.01e6
    CASE('C7H16')   
          Acc_factor(i) = 0.349 
          T_crit(i) = 540.3
          P_crit(i) = 2.74e6
    CASE('C6H12')
          Acc_factor(i) = 0.212 
          T_crit(i) = 553.5
          P_crit(i) = 4.07e6
    CASE('CH2Cl2')
          acc_factor(i) = 0.199
          T_crit(i) = 510.
          P_crit(i) = 6.3e6
    CASE('CHCl3')
          acc_factor(i) = 0.191
          T_crit(i) = 536.4
          P_crit(i) = 5.37e6
    CASE('CCl4')
          acc_factor(i) = 0.193
          T_crit(i) = 556.4
          P_crit(i) = 4.56e6
    CASE('CF4')
          acc_factor(i) = 0.191
          T_crit(i) = 227.6
          P_crit(i) = 3.74e6
    CASE('He')
          acc_factor(i) = -0.387
          T_crit(i) = 5.19
          P_crit(i) = 2.27e5
    CASE('Xe')
          acc_factor(i) = 0.002
          T_crit(i) = 289.7
          P_crit(i) = 5.84e6
    CASE('SF6')
          acc_factor(i) = 0.257 
          T_crit(i) = 318.71
          P_crit(i) = 3.76e6
    CASE('N2')
          acc_factor(i) = 0.039
          T_crit(i) = 126.2
          P_crit(i) = 3.39e6
          P_0(1,i) = 96606.9
          P_0(2,i) = 77.0  
    CASE('Ar')
          acc_factor(i) = 0.001
          T_crit(i) = 150.8
          P_crit(i) = 4.87e6
    CASE('H2')
          acc_factor(i) = -0.216
          T_crit(i) = 33.0
          P_crit(i) = 1.29e6
    CASE default
         write(*,*) 'Fluid molecule ', name_spec(i), ' not in database'
         write(*,*) 'Add in subroutine fluid_properties.f90'
   END SELECT
END DO
!
 k = 0.0
! methane / ethane Prausnitz page 471
IF(no_species == 2) THEN
   If(name_spec(1) == 'CH4' .And. name_spec(2) == 'C2H6') Then
      k(1,2) = 0.0021 
      k(2,1) = 0.0021
   END IF
END IF
!
!  
END SUBROUTINE fluid_properties 
                                                                                                                                                                   fuga_mod.f90                                                                                        0000644 0565266 0565266 00000003175 11100642674 012614  0                                                                                                    ustar   tduren                          tduren                                                                                                                                                                                                                 MODULE fuga_mod
!
! Contains data for calculating the fugacity for different pressures
!
! Acc_factor		real    accentric factor
! k			real 	binary parameter in fugacity calculation
! T_crit		real    critical temperature
! Temp			real    temperature
! beta			real    1 / (k_b Temp)
! P_crit		real    critical pressure
! Press(i)              real    Pressure 
! Presspoint            integer number of pressure points to calculate the
!				adsorption isotherm
! P_0                   real    saturation pressure
! fugacity              real    fugacity
! activ_vol		real	activity * volume of pore
! vol_sim_cell          real    volume of simulation cell
! vol_bulk_fluid        real    volume in simulation cell that the bulk
!                               fluid would occupy
! rho_bulk_fluid	real    density of bulk fluid
! rho_excess            real    excess density 

 Use diverses
 IMPLICIT NONE
 SAVE
!
 REAL(kind = realkind)                             :: Temp, beta
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: Acc_factor
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: P_crit, T_crit
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: fugacity, activ_vol
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: Press
 REAL(kind = realkind), DIMENSION(:,:), ALLOCATABLE:: k
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: no_excess,no_bulk_fluid
 REAL(kind = realkind)                             :: vol_sim_cell
 REAL(kind = realkind), DIMENSION(:), ALLOCATABLE  :: vol_bulk_fluid
 Real(kind = realkind), Dimension(:,:), Allocatable:: p_0
 INTEGER                                           :: Presspoint
!
 END MODULE fuga_mod
	
                                                                                                                                                                                                                                                                                                                                                                                                   input.dat                                                                                           0000644 0565266 0565266 00000000734 11100657057 012343  0                                                                                                    ustar   tduren                          tduren                                                                                                                                                                                                                 ! file with pressure data
/home/tduren/tduren/MOF/gcmc/Hydrogen/Bath/music/pressure_low.dat
! music post processing file
/home/tduren/tduren/MOF/gcmc/Hydrogen/Bath/music/Cd_MOF_121.Hydrogen_2CLJ.77K.low.post
! output file
/home/tduren/tduren/MOF/gcmc/Hydrogen/Bath/adsorption_isotherms/adiso.Cd_MOF_121.Hydrogen_2CLJ.77K.low.dat
! number of species
1
! name of species (chemical formula, not music name)
H2
! temperature of gcmc run in K
77.
! name of adsorbent
Cd_MOF_121

 
                                    main_excess.f90                                                                                     0000644 0565266 0565266 00000012120 11100657064 013316  0                                                                                                    ustar   tduren                          tduren                                                                                                                                                                                                                 Program calc_excess_isotherms
!
! Main program for calculating the excess amount adsorbed using the Peng Robinson
! EOS. Full details of the method can be found in T.Duren et al, Langmuir,
! 20, 2683 (2004). The input for this program is a music post file. Although the 
! Peng Robinson EOS is written for binary mixtures as well as pure components, it 
! is better to use a different version of this program for mixtures. That program
! uses a music logfile as input and allows better error estimation for the individual
! components. Currently, the output is the excess amount adsorbed in molecules / uc,
! mol / g and cm3 / cm3. Changing this main program slightly, you can calculate the
! excess amount adsorbed in whatever unit you need by converting it from molecules / uc. 
!
Use adsorbent
Use molecules_prop
Use fuga_mod


IMPLICIT NONE

Character(len = 120)                             :: file_press, file_post
Character(len = 120)                             :: file_output, file_xmgrace
Character(len = 25), Dimension(:), Allocatable   :: music_name
Character(len = 25)                              :: name_adsorbent, name
Character(len = 7)                               :: name1
Character(len = 4)                               :: name2
Integer                                          :: i, j, no_points
Integer                                          :: ierror
Real(kind = realkind), Dimension(:), Allocatable :: pressure, fuga
Real(kind = realkind), Dimension(:,:), Allocatable :: rho_bulkfluid
Real(kind = realkind), Dimension(:,:), Allocatable :: abs_average, error
Real(kind = realkind), Dimension(:,:), Allocatable :: excess_av
Real(kind = realkind)                            :: dummy, x1


name2 = '.dat'
Read(*,'(/,a)') file_press
Read(*,'(/,a)') file_post
Read(*,'(/,a)') file_output

Open(40, file = file_press, Status = 'OLD', IOSTAT=ierror)
If(ierror /= 0) THEN
  Write(*,*) file_press, ' does not exist'
  STOP
END IF
Open(20, file = file_post, Status = 'OLD', IOSTAT=ierror)
If(ierror /= 0) THEN
  Write(*,*) file_post, ' does not exist'
  STOP
END IF
Open(80, file = file_output)

Write(80,*) 'input: ',file_post
Write(*,*) 'post file to be analysed: ',file_post
Read(*,'(/,I3)') no_species

If(no_species > 1) Then
   write(*,*) 'This version uses a post file as input'
   write(*,*) 'Although in general, it can be used for binary mixtures, it is recommended'
   write(*,*) 'that you use a different variant of this program that uses a logfile as'
   write(*,*) 'input. This allows a better error calculation for the individual components'
   write(*,*) 'of the mixture. Before you continue using this program for binary mixtures'
   write(*,*) 'you have to adapt the calculation of the excess amount adsorbed and the output'
   STOP
END IF

Allocate(name_spec(no_species), music_name(no_species)) 
Allocate(fugacity(no_species))

Do i = 1,no_species
   Read(*,'(/,a)') name_spec(i)
   Write(80,*) 'name: ',name_spec(i)
End Do

Read(*,'(/,F8.2)') temp
Read(*,'(/,a)') name_adsorbent
Write(80,*) 'adsorbent: ', NAME_ADSORBENT

name = TRIM(name_adsorbent)

CALL adsorbent_properties(name)
Call fluid_properties

If(P_0(1,1) /= 0.0 .And. temp - p_0(2,1) > 1.) THEN
   Write(*,*) 'wrong saturation pressure for given temperature'
   Write(*,*) 'change value in fluid_properties'
   STOP
END IF

Write(80,*) 'temperature in K: ', temp
Write(80,*) 'saturation pressure, P0, in kPa: ', P_0(1,1)/1.E3
Write(80,*)  

Read(40,*) music_name
Read(40,*) no_points
Allocate(y_gas(2,no_points),press(no_points), fuga(no_points))
Allocate(abs_average(no_species,no_points), error(no_species,no_points))
Allocate(excess_av(no_species,no_points), rho_bulkfluid(no_species,no_points))

Read(40,*) press
press = press * 1000.

If(no_species == 2) THEN
     Read(40,*) y_gas(1,:)
     y_gas(2,:) = 1. - y_gas(1,:)
Else
   y_gas(1,:) = 1.0
   y_gas(2,:) = 0.0
End If

Do j = 1, no_species
 Do i = 1, no_points
    Call calc_fugacity_1(i, j, rho_bf)
    fuga(i) = fugacity(j)
    rho_bulkfluid(j,i) = rho_bf
 End Do
END DO

Call adsorption_isotherm(abs_average, error, no_species,no_points, music_name)

excess_av = abs_average - rho_bulkfluid * vol_bf

press = press / 1000.
fuga = fuga / 1000.

If(no_species == 1) THEN

   Write(80,*) 'pressure  fugacity   N_abs      error     N_ex        N_ex      N_ex'
   Write(80,*) '  kPa        kPa    molec/uc  molec/uc  molec/uc     mmol/g   cm3(STP)/cm3'
   write(*,*)
   Write(*,*) 'pressure  fugacity   N_abs      error     N_ex        N_ex      N_ex'
   Write(*,*) '  kPa        kPa    molec/uc  molec/uc  molec/uc     mmol/g   cm3(STP)/cm3'

END IF

! 
! Adapt the following lines if you would like the output in different units. excess_av
! is the excess amount adsorbed in molecules / uc.


Do i = 1, no_points

   Write(80,'(2(ES10.3),5(F10.3))') press(i), fuga(i), abs_average(1,i), error(1,i),  excess_av(1,i), &
                      excess_av(1,i)/mass_uc,excess_av(1,i) * 22.4E3/mass_uc/1000. * chrys_dens
   Write(*,'(2(ES10.3),5(F10.3))') press(i), fuga(i), abs_average(1,i), error(1,i),  excess_av(1,i), &
                      excess_av(1,i)/mass_uc,excess_av(1,i) * 22.4E3/mass_uc/1000. * chrys_dens

End do

END Program






                                                                                                                                                                                                                                                                                                                                                                                                                                                makefile                                                                                            0000644 0565266 0565266 00000000654 11100642674 012212  0                                                                                                    ustar   tduren                          tduren                                                                                                                                                                                                                 OBJS   = div_mod.o \
         adsorbent_mod.o \
         fuga_mod.o \
         molecules_prop.o \
         adsorption_isotherm.o \
         adsorbent_properties_UFF.o \
         calc_fugacity_bin.o \
         fluid_properties.o \
         main_excess.o \

FOPS = -g 

fuga: $(OBJS) 
	@echo "Linking excess ..."
	@ifort $(FOPS) $(OBJS) -o excess_UFF.exe
	@echo "done"

clean:;	@ rm -f *.o *.mod


%.o: %.f90
	ifort -c $(FOPS) $^
                                                                                    molecules_prop.f90                                                                                  0000644 0565266 0565266 00000000701 11100652174 014047  0                                                                                                    ustar   tduren                          tduren                                                                                                                                                                                                                 MODULE Molecules_Prop
!
! no_species		integer	number of species (molecule)
! name_spec		character charater name of species (molecule)
! y_gas			real	mole fraction of species (molecule) i
!
 USE diverses
 IMPLICIT NONE
 SAVE
!
 INTEGER                                            :: no_species
 Real(kind = realkind), Dimension(:,:), Allocatable :: y_gas
 CHARACTER(10), ALLOCATABLE, DIMENSION(:)           :: name_spec
!
END MODULE Molecules_Prop   
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               